/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.StandAloneDataTypeManager;

public class CompositeViewerDataTypeManager
extends StandAloneDataTypeManager {
    private DataTypeManager originalDTM;
    private Composite originalComposite;
    private Composite viewComposite;
    private int transactionID;

    public CompositeViewerDataTypeManager(String rootName, Composite originalComposite) {
        super(rootName, originalComposite.getDataTypeManager().getDataOrganization());
        this.originalComposite = originalComposite;
        this.transactionID = this.startTransaction("");
        this.originalDTM = originalComposite.getDataTypeManager();
        this.universalID = this.originalDTM.getUniversalID();
        this.viewComposite = (Composite)super.resolve((DataType)originalComposite, null);
    }

    public void close() {
        this.endTransaction(this.transactionID, true);
        super.close();
    }

    public ArchiveType getType() {
        return this.originalDTM.getType();
    }

    public boolean allowsDefaultBuiltInSettings() {
        return this.originalDTM.allowsDefaultBuiltInSettings();
    }

    public DataType resolve(DataType dataType, DataTypeConflictHandler handler) {
        if (dataType == this.originalComposite && this.viewComposite != null) {
            return this.viewComposite;
        }
        return super.resolve(dataType, handler);
    }
}

