/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.assembler;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.autocomplete.AutocompletionEvent;
import docking.widgets.autocomplete.AutocompletionListener;
import docking.widgets.autocomplete.TextFieldAutocompleter;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.FieldPanelOverLayoutListener;
import docking.widgets.fieldpanel.FieldPanelOverLayoutManager;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.plugin.assembler.Assembler;
import ghidra.app.plugin.assembler.Assemblers;
import ghidra.app.plugin.core.assembler.AbstractPatchAction;
import ghidra.app.plugin.core.assembler.AssemblyDualTextField;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.database.util.ProgramTransaction;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.task.CachingSwingWorker;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.KeyStroke;
import org.apache.commons.collections4.map.DefaultedMap;
import org.apache.commons.collections4.map.LazyMap;

public class PatchInstructionAction
extends AbstractPatchAction {
    private static final String ASSEMBLY_RATING = "assemblyRating";
    private static final String ASSEMBLY_MESSAGE = "assemblyMessage";
    private static final KeyStroke KEYBIND_PATCH_INSTRUCTION = KeyStroke.getKeyStroke("ctrl shift G");
    private final Map<Language, CachingSwingWorker<Assembler>> cache = LazyMap.lazyMap(new HashMap(), language -> new AssemblerConstructorWorker((Language)language));
    static final Map<Language, Boolean> SHOWN_WARNING = DefaultedMap.defaultedMap(new HashMap(), (Object)false);
    final AssemblyDualTextField input = this.newAssemblyDualTextField();
    private final ListenerForAccept listenerForAccept = new ListenerForAccept();
    protected Language language;
    protected Assembler assembler;
    private FieldPanelOverLayoutListener listenerToMoveAutocompleter = ev -> {
        TextFieldAutocompleter<AssemblyDualTextField.AssemblyCompletion> autocompleter = this.input.getAutocompleter();
        if (autocompleter.isCompletionListVisible()) {
            autocompleter.updateDisplayLocation();
        }
    };

    public PatchInstructionAction(Plugin owner) {
        this(owner, "Patch Instruction");
    }

    public PatchInstructionAction(Plugin owner, String name) {
        super(owner, name);
        this.setPopupMenuData(new MenuData(new String[]{name}, "Disassembly"));
        this.setKeyBindingData(new KeyBindingData(KEYBIND_PATCH_INSTRUCTION));
        this.setHelpLocation(new HelpLocation(owner.getName(), "patch_instruction"));
        this.input.getMnemonicField().setBorder(BorderFactory.createLineBorder(Color.RED, 2));
        this.input.getOperandsField().setBorder(BorderFactory.createLineBorder(Color.RED, 2));
        this.input.getAssemblyField().setBorder(BorderFactory.createLineBorder(Color.RED, 2));
        this.input.getAutocompleter().addAutocompletionListener((AutocompletionListener)this.listenerForAccept);
        this.init();
    }

    protected AssemblyDualTextField newAssemblyDualTextField() {
        return new AssemblyDualTextField();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.input.dispose();
    }

    @Override
    protected void addInputFocusListener(FocusListener listener) {
        this.input.addFocusListener(listener);
    }

    @Override
    protected void addInputKeyListener(KeyListener listener) {
        this.input.addKeyListener(listener);
    }

    @Override
    protected void addLayoutListeners(FieldPanelOverLayoutManager fieldLayoutManager) {
        fieldLayoutManager.addLayoutListener(this.listenerToMoveAutocompleter);
    }

    @Override
    protected void removeLayoutListeners(FieldPanelOverLayoutManager fieldLayoutManager) {
        fieldLayoutManager.removeLayoutListener(this.listenerToMoveAutocompleter);
    }

    @Override
    protected boolean isApplicableToUnit(CodeUnit cu) {
        return true;
    }

    protected void warnLanguage() {
        AssemblyRating rating = AssemblyRating.valueOf(this.language.getProperty("assemblyRating:" + this.language.getLanguageID(), AssemblyRating.UNRATED.name()));
        if (AssemblyRating.PLATINUM != rating) {
            String message = this.language.getProperty("assemblyMessage:" + this.language.getLanguageID(), rating.message);
            if (!SHOWN_WARNING.get(this.language).booleanValue()) {
                Msg.showWarn((Object)((Object)this), null, (String)"Assembler Rating", (Object)("<html><body><p style='width: 300px;'>" + message + "</p></body></html>"));
                SHOWN_WARNING.put(this.language, true);
            }
        }
    }

    protected Language getLanguage(CodeUnit cu) {
        return cu.getProgram().getLanguage();
    }

    protected Assembler getAssembler(CodeUnit cu) {
        return Assemblers.getAssembler((Program)cu.getProgram());
    }

    @Override
    protected void prepare() {
        CodeUnit cu = this.getCodeUnit();
        this.language = this.getLanguage(cu);
        this.warnLanguage();
        this.cache.get(this.language).get(null);
        this.assembler = this.getAssembler(cu);
    }

    @Override
    protected void setInputFont(Font font) {
        this.input.setFont(font);
    }

    protected Instruction getExistingInstruction() {
        Program program = this.getProgram();
        if (program == null) {
            return null;
        }
        return program.getListing().getInstructionAt(this.getAddress());
    }

    @Override
    protected boolean showInputs(FieldPanel fieldPanel) {
        this.input.setAssembler(this.assembler);
        this.input.setAddress(this.getAddress());
        this.input.setExisting(this.getExistingInstruction());
        FieldLocation locMnem = this.findFieldLocation(this.getAddress(), "Mnemonic");
        if (locMnem == null) {
            Msg.showError((Object)((Object)this), (Component)fieldPanel, (String)this.getName(), (Object)"The Mnemonic field must be present to patch instruction");
            return false;
        }
        FieldLocation locOpns = this.findFieldLocation(this.getAddress(), "Operands");
        if (locOpns == null) {
            fieldPanel.add((Component)this.input.getAssemblyField(), (Object)locMnem);
            this.input.setVisible(AssemblyDualTextField.VisibilityMode.SINGLE_VISIBLE);
        } else {
            fieldPanel.add((Component)this.input.getMnemonicField(), (Object)locMnem);
            fieldPanel.add((Component)this.input.getOperandsField(), (Object)locOpns);
            this.input.setVisible(AssemblyDualTextField.VisibilityMode.DUAL_VISIBLE);
        }
        return true;
    }

    @Override
    protected void fillInputs() {
        CodeUnit cu = this.getCodeUnit();
        if (cu instanceof Instruction) {
            Instruction ins = (Instruction)cu;
            String instr = ins.toString();
            if (ins.isInDelaySlot()) {
                assert (instr.startsWith("_"));
                instr = instr.substring(1).trim();
            }
            this.input.setText(instr);
            this.input.setCaretPosition(instr.length());
            if (this.input.getVisible() == AssemblyDualTextField.VisibilityMode.SINGLE_VISIBLE) {
                this.input.getAssemblyField().grabFocus();
            } else if (instr.contains(" ")) {
                this.input.getOperandsField().grabFocus();
            } else {
                this.input.getMnemonicField().grabFocus();
            }
        } else {
            this.input.setText("");
            this.input.setCaretPosition(0);
            if (this.input.getVisible() == AssemblyDualTextField.VisibilityMode.SINGLE_VISIBLE) {
                this.input.getAssemblyField().grabFocus();
            } else {
                this.input.getMnemonicField().grabFocus();
            }
        }
    }

    @Override
    public void accept() {
    }

    protected void applyPatch(byte[] data) throws MemoryAccessException {
        this.assembler.patchProgram(data, this.getAddress());
    }

    public void accept(AssemblyDualTextField.AssemblyInstruction ins) {
        Program program = this.getProgram();
        Address address = this.getAddress();
        try (ProgramTransaction trans = ProgramTransaction.open((Program)program, (String)("Assemble @" + address + ": " + this.input.getText()));){
            this.applyPatch(ins.getData());
            trans.commit();
            this.hide();
        }
        catch (MemoryAccessException e) {
            Msg.showError((Object)((Object)this), null, (String)"Assemble", (Object)"Could not patch selected instruction", (Throwable)e);
        }
    }

    private class ListenerForAccept
    implements AutocompletionListener<AssemblyDualTextField.AssemblyCompletion> {
        private ListenerForAccept() {
        }

        public void completionActivated(AutocompletionEvent<AssemblyDualTextField.AssemblyCompletion> ev) {
            if (ev.getSelection() instanceof AssemblyDualTextField.AssemblyInstruction) {
                AssemblyDualTextField.AssemblyInstruction ins = (AssemblyDualTextField.AssemblyInstruction)ev.getSelection();
                PatchInstructionAction.this.accept(ins);
            }
        }
    }

    static enum AssemblyRating {
        UNRATED("This processor has not been tested with the assembler. The assembler will probably work on this language."),
        POOR("This processor received a rating of POOR during testing. We DO NOT recommend trying to assemble."),
        BRONZE("This processor received a rating of BRONZE during testing. A fair number of instructions may assemble, but we DO NOT recommend trying to assemble."),
        SILVER("This processor received a rating of SILVER during testing. Most instructions should work, but you will likely encounter a few errors."),
        GOLD("This processor received a rating of GOLD during testing. You should rarely encounter an error."),
        PLATINUM("This processor received a rating of PLATINUM during testing.");

        final String message;

        private AssemblyRating(String message) {
            this.message = message;
        }
    }

    private static class AssemblerConstructorWorker
    extends CachingSwingWorker<Assembler> {
        private Language language;

        public AssemblerConstructorWorker(Language language) {
            super("Assemble", false);
            this.language = language;
        }

        protected Assembler runInBackground(TaskMonitor monitor) {
            monitor.setMessage("Constructing assembler for " + this.language);
            return Assemblers.getAssembler((Language)this.language);
        }
    }
}

