/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.util.PseudoDisassembler;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.BasicBlockModel;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.block.SimpleBlockModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalLocationIterator;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.ContextEvaluatorAdapter;
import ghidra.program.util.SymbolicPropogator;
import ghidra.program.util.VarnodeContext;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class CreateThunkFunctionCmd
extends BackgroundCommand {
    private Address entry;
    private AddressSetView body;
    private Address referencedFunctionAddr;
    private Symbol referencedSymbol;
    private Function thunkFunction;
    private Function referencedFunction;
    private List<Address> referringThunkAddresses = new ArrayList<Address>();
    private boolean checkForSideEffects = true;
    private static final int MAX_NUMBER_OF_THUNKING_INSTRUCTIONS = 8;
    static String DEFAULT_FUNCTION_COMMENT = " THUNK-FUNCTION";

    public CreateThunkFunctionCmd(Address entry, AddressSetView body, Address referencedFunctionAddr, List<Address> referringThunkAddresses) {
        this(entry, body, referencedFunctionAddr);
        if (referringThunkAddresses != null) {
            this.referringThunkAddresses.addAll(0, referringThunkAddresses);
        }
    }

    public CreateThunkFunctionCmd(Address entry, AddressSetView body, Address referencedFunctionAddr) {
        super("Create Thunk Function", false, false, false);
        this.entry = entry;
        this.body = body;
        this.referencedFunctionAddr = referencedFunctionAddr;
        this.referringThunkAddresses.add(entry);
    }

    public CreateThunkFunctionCmd(Address entry, AddressSetView body, Symbol referencedSymbol) {
        this(entry, body, (Address)null);
        this.referencedSymbol = referencedSymbol;
    }

    public CreateThunkFunctionCmd(Address entry, boolean checkForSideEffects) {
        this(entry, (AddressSetView)null, (Symbol)null);
        this.checkForSideEffects = checkForSideEffects;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        Program program = (Program)obj;
        FunctionManager functionMgr = program.getFunctionManager();
        if (this.referencedFunctionAddr == Address.NO_ADDRESS) {
            this.referencedFunctionAddr = null;
        }
        this.thunkFunction = functionMgr.getFunctionAt(this.entry);
        if (this.body != null) {
            for (Function f : functionMgr.getFunctions(this.body, true)) {
                if (f == this.thunkFunction) continue;
                this.setStatusMsg("Specified body overlaps existing function '" + f.getName() + "' at " + f.getEntryPoint());
                return false;
            }
        }
        this.referencedFunction = this.getReferencedFunction(this.referencedFunctionAddr == null && this.referencedSymbol == null, program, monitor);
        if (this.referencedFunction == null) {
            this.thunkFunction = null;
            return false;
        }
        this.referencedFunctionAddr = this.referencedFunction.getEntryPoint();
        if (this.thunkFunction != null) {
            try {
                this.thunkFunction.setThunkedFunction(this.referencedFunction);
            }
            catch (IllegalArgumentException e) {
                this.setStatusMsg("Invalid thunked function specified: " + e.getMessage());
                return false;
            }
            if (this.body != null) {
                try {
                    this.thunkFunction.setBody(this.body);
                }
                catch (OverlappingFunctionException e) {
                    this.setStatusMsg("Specified body overlaps existing function(s): " + e.getMessage());
                    return false;
                }
            }
            return true;
        }
        if (program.getListing().getFunctionContaining(this.entry) != null) {
            this.setStatusMsg("Thunk function entry contained within another function");
            return false;
        }
        if (this.body == null) {
            this.body = this.computeThunkBody(program);
            if (this.body == null) {
                return false;
            }
        } else if (this.body.contains(this.referencedFunctionAddr)) {
            this.body = this.body.subtract(this.referencedFunction.getBody());
            if (this.body.getNumAddressRanges() != 1 || !this.body.contains(this.entry)) {
                return false;
            }
        }
        Namespace namespace = program.getGlobalNamespace();
        String name = null;
        SourceType source = SourceType.DEFAULT;
        Symbol s = program.getSymbolTable().getPrimarySymbol(this.entry);
        if (s != null) {
            name = s.getName();
            namespace = s.getParentNamespace();
            source = s.getSource();
        }
        try {
            this.thunkFunction = functionMgr.createThunkFunction(name, namespace, this.entry, this.body, this.referencedFunction, source);
        }
        catch (OverlappingFunctionException e) {
            this.setStatusMsg("Specified body overlaps existing function(s): " + e.getMessage());
            return false;
        }
        return true;
    }

    private AddressSetView computeThunkBody(Program program) {
        if (program.getMemory().isExternalBlockAddress(this.entry)) {
            return new AddressSet(this.entry, this.entry);
        }
        Listing listing = program.getListing();
        Instruction instr = listing.getInstructionAt(this.entry);
        if (instr == null) {
            return null;
        }
        FlowType flowtype = instr.getFlowType();
        if (flowtype == RefType.UNCONDITIONAL_JUMP || flowtype == RefType.COMPUTED_JUMP || flowtype == RefType.COMPUTED_CALL_TERMINATOR || flowtype == RefType.CALL_TERMINATOR) {
            return new AddressSet(instr.getMinAddress(), instr.getMaxAddress());
        }
        this.setStatusMsg("Must specify thunk function body");
        return null;
    }

    private Function getReferencedFunction(boolean autoThunkOK, Program program, TaskMonitor monitor) {
        CreateThunkFunctionCmd extThunkCmd;
        Listing listing = program.getListing();
        if (this.referencedSymbol != null) {
            Object obj = this.referencedSymbol.getObject();
            if (obj instanceof Function) {
                return (Function)obj;
            }
            if (obj instanceof ExternalLocation) {
                return ((ExternalLocation)obj).createFunction();
            }
            this.referencedFunctionAddr = this.referencedSymbol.getAddress();
        } else if ((this.referencedFunctionAddr == null || this.referencedFunctionAddr == Address.NO_ADDRESS) && autoThunkOK) {
            this.referencedFunctionAddr = CreateThunkFunctionCmd.getThunkedExternalFunctionAddress(program, this.entry);
            if (this.referencedFunctionAddr == null) {
                this.referencedFunctionAddr = CreateThunkFunctionCmd.getThunkedAddr(program, this.entry, this.checkForSideEffects);
            }
            if (this.referencedFunctionAddr == null || this.referencedFunctionAddr == Address.NO_ADDRESS) {
                try {
                    if (this.resolveComputableFlow(program, this.entry, monitor)) {
                        this.referencedFunctionAddr = CreateThunkFunctionCmd.getThunkedAddr(program, this.entry, this.checkForSideEffects);
                    }
                }
                catch (CancelledException e) {
                    return null;
                }
            }
            if (this.referencedFunctionAddr == null || this.referencedFunctionAddr == Address.NO_ADDRESS) {
                this.referencedFunctionAddr = this.getFirstBlockJumpCall(program, monitor);
            }
        } else if (this.referencedFunctionAddr != null) {
            this.referencedFunctionAddr = PseudoDisassembler.getNormalizedDisassemblyAddress((Program)program, (Address)this.referencedFunctionAddr);
        }
        if (this.referencedFunctionAddr == null) {
            this.setStatusMsg("Failed to create thunk at " + this.entry + ": unable to find thunked function");
            return null;
        }
        Function f = listing.getFunctionAt(this.referencedFunctionAddr);
        if (f == null && program.getMemory().isExternalBlockAddress(this.referencedFunctionAddr) && (extThunkCmd = new CreateThunkFunctionCmd(this.referencedFunctionAddr, false)).applyTo((DomainObject)program)) {
            f = extThunkCmd.getThunkFunction();
        }
        if (f != null) {
            if (f.getEntryPoint().equals((Object)this.entry)) {
                this.setStatusMsg("Invalid referenced function: circular reference");
                return null;
            }
            return f;
        }
        if (this.referencedFunctionAddr.isExternalAddress()) {
            Symbol s = program.getSymbolTable().getPrimarySymbol(this.referencedFunctionAddr);
            if (s != null) {
                ExternalLocation extLoc = (ExternalLocation)s.getObject();
                Msg.trace((Object)((Object)this), (Object)("Converting external location to function as a result of thunk at: " + this.entry));
                return extLoc.createFunction();
            }
            return null;
        }
        if (!this.referencedFunctionAddr.isMemoryAddress()) {
            this.setStatusMsg("Referenced address/symbol is not a valid memory location");
            return null;
        }
        if (!program.getMemory().contains(this.referencedFunctionAddr)) {
            return this.getExternalFunction(program);
        }
        f = listing.getFunctionContaining(this.referencedFunctionAddr);
        if (f != null || listing.getInstructionAt(this.referencedFunctionAddr) == null) {
            this.setStatusMsg("Invalid referenced function entry address");
            return null;
        }
        if (this.referringThunkAddresses.contains(this.referencedFunctionAddr)) {
            this.setStatusMsg("Invalid referenced function: circular reference");
            return null;
        }
        CreateFunctionCmd funcCmd = new CreateFunctionCmd(this.referencedFunctionAddr, this.referringThunkAddresses);
        if (funcCmd.applyTo((DomainObject)program)) {
            return funcCmd.getFunction();
        }
        this.setStatusMsg("Failed to create thunk at " + this.entry + ": unable to create thunked-function at " + this.referencedFunctionAddr);
        return null;
    }

    private Address getFirstBlockJumpCall(Program program, TaskMonitor monitor) {
        SimpleBlockModel simpleBlockModel = new SimpleBlockModel(program);
        try {
            CodeBlock codeBlockAt = simpleBlockModel.getCodeBlockAt(this.entry, monitor);
            if (codeBlockAt == null) {
                return null;
            }
            CodeBlockReferenceIterator destinations = codeBlockAt.getDestinations(monitor);
            while (destinations.hasNext()) {
                CodeBlockReference destRef = destinations.next();
                FlowType flowType = destRef.getFlowType();
                if (!flowType.isCall() && !flowType.isJump() || !flowType.isUnConditional()) continue;
                return destRef.getDestinationAddress();
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        return null;
    }

    private Function getExternalFunction(Program program) {
        ExternalManager externalMgr = program.getExternalManager();
        ExternalLocationIterator externalLocations = externalMgr.getExternalLocations(this.referencedFunctionAddr);
        if (!externalLocations.hasNext()) {
            ExternalLocation extLoc;
            try {
                extLoc = externalMgr.addExtFunction("<EXTERNAL>", null, this.referencedFunctionAddr, SourceType.DEFAULT);
                Msg.debug((Object)((Object)this), (Object)("Created new external location for address " + this.referencedFunctionAddr + ": " + extLoc.toString()));
            }
            catch (DuplicateNameException | InvalidInputException e) {
                throw new RuntimeException("Unexpected exception", e);
            }
            return extLoc.getFunction();
        }
        ExternalLocation extLoc = externalLocations.next();
        if (extLoc.isFunction()) {
            return extLoc.getFunction();
        }
        Msg.debug((Object)((Object)this), (Object)("Converting external location to a function: " + extLoc.toString()));
        return extLoc.createFunction();
    }

    private boolean resolveComputableFlow(final Program program, Address location, TaskMonitor monitor) throws CancelledException {
        final Register isaModeSwitchRegister = program.getRegister("ISAModeSwitch");
        final Register isaModeRegister = program.getRegister("ISA_MODE");
        BasicBlockModel basicBlockModel = new BasicBlockModel(program);
        CodeBlock jumpBlockAt = basicBlockModel.getFirstCodeBlockContaining(location, monitor);
        if (jumpBlockAt == null) {
            return false;
        }
        final AtomicInteger foundCount = new AtomicInteger(0);
        SymbolicPropogator prop = new SymbolicPropogator(program);
        prop.flowConstants(jumpBlockAt.getFirstStartAddress(), (AddressSetView)jumpBlockAt, (ContextEvaluator)new ContextEvaluatorAdapter(){

            @Override
            public boolean evaluateReference(VarnodeContext context, Instruction instr, int pcodeop, Address address, int size, RefType refType) {
                if (refType.isComputed() && refType.isFlow() && program.getMemory().contains(address)) {
                    this.propogateCodeMode(context, address);
                    foundCount.incrementAndGet();
                    return true;
                }
                return false;
            }

            @Override
            public boolean allowAccess(VarnodeContext context, Address addr) {
                return true;
            }

            private void propogateCodeMode(VarnodeContext context, Address addr) {
                if (isaModeSwitchRegister == null) {
                    return;
                }
                BigInteger value = context.getValue(isaModeSwitchRegister, false);
                if (value != null && program.getListing().getInstructionAt(addr) == null) {
                    try {
                        program.getProgramContext().setValue(isaModeRegister, addr, addr, value);
                    }
                    catch (ContextChangeException contextChangeException) {
                        // empty catch block
                    }
                }
            }
        }, false, monitor);
        return foundCount.get() == 1;
    }

    public Function getThunkFunction() {
        return this.thunkFunction;
    }

    public Function getReferencedFunction() {
        return this.referencedFunction;
    }

    public static Address getThunkedAddr(Program program, Address entry) {
        return CreateThunkFunctionCmd.getThunkedAddr(program, entry, true);
    }

    public static Address getThunkedAddr(Program program, Address entry, boolean checkForSideEffects) {
        Listing listing = program.getListing();
        Instruction instr = listing.getInstructionAt(entry);
        if (instr == null) {
            return null;
        }
        Address simpleFlowAddr = CreateThunkFunctionCmd.getSimpleFlow(instr);
        if (simpleFlowAddr != null) {
            return simpleFlowAddr;
        }
        boolean allow8bitNonUse = true;
        if (program.getAddressFactory().getDefaultAddressSpace().getSize() <= 16) {
            allow8bitNonUse = false;
        }
        int numInstr = 1;
        HashSet<Varnode> setAtStartRegisters = new HashSet<Varnode>();
        HashSet<Varnode> setRegisters = new HashSet<Varnode>();
        HashSet<Varnode> usedRegisters = new HashSet<Varnode>();
        CreateThunkFunctionCmd.addSetRegisters(program, entry, setAtStartRegisters);
        while (instr != null && numInstr++ <= 8) {
            PcodeOp[] pcode;
            FlowType flowType = instr.getFlowType();
            PcodeOp[] pcodeOpArray = pcode = instr.getPcode(false);
            int n = pcodeOpArray.length;
            for (int i = 0; i < n; ++i) {
                PcodeOp element;
                PcodeOp pcodeOp = element = pcodeOpArray[i];
                if (checkForSideEffects && pcodeOp.getOpcode() == 3) {
                    return null;
                }
                if (!checkForSideEffects || CreateThunkFunctionCmd.addRegisterUsage(program, setAtStartRegisters, setRegisters, usedRegisters, pcodeOp, allow8bitNonUse)) continue;
                return null;
            }
            if (instr.isFallthrough() && instr.getDelaySlotDepth() == 0) {
                Address fallAddr = instr.getFallThrough();
                instr = listing.getInstructionAt(fallAddr);
                continue;
            }
            if (CreateThunkFunctionCmd.isLocalBranch(listing, instr, flowType)) continue;
            return CreateThunkFunctionCmd.getFlowingAddrFromFinalState(program, instr, flowType, checkForSideEffects, setRegisters, usedRegisters);
        }
        return null;
    }

    private static void addSetRegisters(Program program, Address entry, HashSet<Varnode> setRegisters) {
        Register[] regWithVals;
        for (Register register : regWithVals = program.getProgramContext().getRegistersWithValues()) {
            RegisterValue regVal;
            if (register.isProcessorContext() || (regVal = program.getProgramContext().getRegisterValue(register, entry)) == null || !regVal.hasValue()) continue;
            Register reg = regVal.getRegister();
            setRegisters.add(new Varnode(reg.getAddress(), reg.getMinimumByteSize()));
        }
    }

    static Address getThunkedExternalFunctionAddress(Program program, Address entry) {
        if (!program.getMemory().isExternalBlockAddress(entry)) {
            return null;
        }
        SymbolTable symbolTable = program.getSymbolTable();
        Symbol[] symbols = symbolTable.getSymbols(entry);
        if (symbols.length != 1) {
            return null;
        }
        Symbol s = symbols[0];
        if (s.isDynamic() || s.getSymbolType() != SymbolType.LABEL || !s.getParentNamespace().isGlobal()) {
            return null;
        }
        try {
            ExternalManager extMgr = program.getExternalManager();
            ExternalLocation extLoc = extMgr.addExtFunction("<EXTERNAL>", s.getName(), null, s.getSource());
            return extLoc.getExternalSpaceAddress();
        }
        catch (DuplicateNameException | InvalidInputException throwable) {
            return null;
        }
    }

    private static boolean isLocalBranch(Listing listing, Instruction instr, FlowType flowType) {
        if (!flowType.isJump() || flowType.isConditional()) {
            return false;
        }
        Address[] flows = instr.getFlows();
        if (flows.length != 1) {
            return false;
        }
        Address minAddress = instr.getMinAddress();
        if (!minAddress.hasSameAddressSpace(flows[0])) {
            return false;
        }
        return Math.abs(flows[0].subtract(instr.getMinAddress())) <= 8L;
    }

    private static Address getFlowingAddrFromFinalState(Program program, Instruction instr, FlowType flowType, boolean checkForSideEffects, HashSet<Varnode> setRegisters, HashSet<Varnode> usedRegisters) {
        Address flowingAddr = null;
        if ((flowType.isJump() || flowType.equals((Object)RefType.COMPUTED_CALL_TERMINATOR) || flowType.equals((Object)RefType.CALL_TERMINATOR)) && !flowType.isConditional()) {
            Register PC = program.getLanguage().getProgramCounter();
            if (PC != null) {
                usedRegisters.add(new Varnode(PC.getAddress(), PC.getMinimumByteSize()));
            }
            setRegisters.removeAll(usedRegisters);
            Iterator<Varnode> iterator = setRegisters.iterator();
            while (iterator.hasNext()) {
                Varnode rvnode = iterator.next();
                Register reg = program.getRegister(rvnode);
                if (reg == null || !reg.isHidden()) continue;
                iterator.remove();
            }
            if (!checkForSideEffects || setRegisters.size() == 0) {
                flowingAddr = CreateThunkFunctionCmd.getFlowingAddress(program, instr);
            }
        }
        return flowingAddr;
    }

    private static Address getSimpleFlow(Instruction instr) {
        Address[] flows;
        FlowType flowType = instr.getFlowType();
        if (instr.getDelaySlotDepth() == 0 && !flowType.isConditional() && (flowType.isJump() || flowType.isCall() && flowType.isTerminal()) && (flows = instr.getFlows()).length == 1) {
            return flows[0];
        }
        return null;
    }

    private static boolean addRegisterUsage(Program program, HashSet<Varnode> setAtStartRegisters, HashSet<Varnode> setRegisters, HashSet<Varnode> usedRegisters, PcodeOp pcode, boolean allow8bitNonUse) {
        Varnode[] inputs;
        int opcode = pcode.getOpcode();
        Varnode output = pcode.getOutput();
        if (opcode == 1) {
            if (output.isAddress()) {
                return false;
            }
            if (output.equals((Object)pcode.getInput(0))) {
                return true;
            }
        }
        for (Varnode input : inputs = pcode.getInputs()) {
            Varnode inVarnode = input;
            if (!inVarnode.isRegister()) continue;
            if (!(allow8bitNonUse && inVarnode.getSize() <= 1 || CreateThunkFunctionCmd.containsRegister(program, setRegisters, inVarnode) || CreateThunkFunctionCmd.containsRegister(program, setAtStartRegisters, inVarnode))) {
                return false;
            }
            if (output != null && output.getSize() < inVarnode.getSize()) continue;
            usedRegisters.add(inVarnode);
        }
        if (output != null && output.isRegister() && (!allow8bitNonUse || output.getSize() > 1)) {
            setRegisters.add(output);
            usedRegisters.remove(output);
        }
        return true;
    }

    private static boolean containsRegister(Program program, HashSet<Varnode> setRegisters, Varnode regVarnode) {
        if (setRegisters.contains(regVarnode)) {
            return true;
        }
        Register register = program.getRegister(regVarnode);
        if (register == null) {
            return false;
        }
        Register parentRegister = register.getParentRegister();
        if (parentRegister == null) {
            return false;
        }
        Varnode parentVarnode = new Varnode(parentRegister.getAddress(), parentRegister.getBitLength() / 8);
        return setRegisters.contains(parentVarnode);
    }

    private static Address getFlowingAddress(Program program, Instruction instr) {
        Reference flowRef = null;
        Reference dataRef = null;
        for (Reference reference : instr.getReferencesFrom()) {
            RefType refType = reference.getReferenceType();
            if (refType.isData()) {
                dataRef = reference;
                continue;
            }
            if (!refType.isFlow()) continue;
            if (flowRef != null) {
                return null;
            }
            flowRef = reference;
        }
        if (flowRef == null) {
            flowRef = dataRef;
        }
        if (flowRef != null) {
            RefType refType = flowRef.getReferenceType();
            if (refType.isData() || refType.isIndirect()) {
                Address toAddr = flowRef.getToAddress();
                Reference[] referencesFrom = program.getReferenceManager().getReferencesFrom(toAddr);
                if (referencesFrom.length == 1 && (referencesFrom[0].getReferenceType() == RefType.DATA || referencesFrom[0].isExternalReference())) {
                    return referencesFrom[0].getToAddress();
                }
                return null;
            }
            return flowRef.getToAddress();
        }
        return Address.NO_ADDRESS;
    }

    public static boolean isThunk(Program program, Function func) {
        Address entry = func.getEntryPoint();
        return CreateThunkFunctionCmd.getThunkedAddr(program, entry) != null;
    }
}

