/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.zip;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.zip.ZipFileSystemFactory;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemIndexHelper;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@FileSystemInfo(type="zip", description="ZIP", factory=ZipFileSystemFactory.class, priority=10)
public class ZipFileSystemBuiltin
implements GFileSystem {
    static final String TEMPFILE_PREFIX = "ghidra_tmp_zipfile";
    private FileSystemIndexHelper<ZipEntry> fsIndexHelper;
    private FSRLRoot fsFSRL;
    private ZipFile zipFile;
    private FileSystemRefManager refManager = new FileSystemRefManager((GFileSystem)this);
    private FileSystemService fsService;

    public ZipFileSystemBuiltin(FSRLRoot fsFSRL, FileSystemService fsService) {
        this.fsFSRL = fsFSRL;
        this.fsService = fsService;
        this.fsIndexHelper = new FileSystemIndexHelper((GFileSystem)this, fsFSRL);
    }

    public String getName() {
        return this.fsFSRL.getContainer().getName();
    }

    public void close() throws IOException {
        this.refManager.onClose();
        if (this.zipFile != null) {
            this.zipFile.close();
            this.zipFile = null;
        }
        this.fsIndexHelper.clear();
    }

    public boolean isClosed() {
        return this.zipFile == null;
    }

    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    public int getFileCount() {
        return this.fsIndexHelper.getFileCount();
    }

    public void mount(File f, boolean deleteFileWhenDone, TaskMonitor monitor) throws CancelledException, IOException {
        deleteFileWhenDone = deleteFileWhenDone && f.getName().startsWith(TEMPFILE_PREFIX);
        int openMode = deleteFileWhenDone ? 5 : 1;
        this.zipFile = new ZipFile(f, openMode);
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            monitor.checkCanceled();
            ZipEntry currentEntry = entries.nextElement();
            this.fsIndexHelper.storeFile(currentEntry.getName(), -1L, currentEntry.isDirectory(), currentEntry.getSize(), (Object)currentEntry);
        }
    }

    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        ZipEntry zipEntry = (ZipEntry)this.fsIndexHelper.getMetadata(file);
        if (zipEntry == null) {
            return null;
        }
        FileAttributes result = new FileAttributes();
        result.add(FileAttributeType.COMMENT_ATTR, (Object)zipEntry.getComment());
        result.add(FileAttributeType.SIZE_ATTR, (Object)zipEntry.getSize());
        Date date = new Date(zipEntry.getLastModifiedTime().toMillis());
        result.add(FileAttributeType.MODIFIED_DATE_ATTR, (Object)date);
        result.add(FileAttributeType.COMPRESSED_SIZE_ATTR, (Object)zipEntry.getCompressedSize());
        result.add("CRC", (Object)Long.toHexString(zipEntry.getCrc()));
        result.add("Compression Method", (Object)("0x" + Integer.toHexString(zipEntry.getMethod())));
        return result;
    }

    public String toString() {
        return "ZipFilesystemBuiltin [ fsrl=" + this.fsFSRL + ", filename=" + this.zipFile.getName() + " ]";
    }

    public GFile lookup(String path) throws IOException {
        return this.fsIndexHelper.lookup(path);
    }

    public InputStream getInputStream(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        ZipEntry zipEntry = (ZipEntry)this.fsIndexHelper.getMetadata(file);
        return zipEntry != null ? this.zipFile.getInputStream(zipEntry) : null;
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        ZipEntry zipEntry = (ZipEntry)this.fsIndexHelper.getMetadata(file);
        if (zipEntry == null) {
            return null;
        }
        return this.fsService.getDerivedByteProvider(this.fsFSRL.getContainer(), file.getFSRL(), zipEntry.getName(), zipEntry.getSize(), () -> this.zipFile.getInputStream(zipEntry), monitor);
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return this.fsIndexHelper.getListing(directory);
    }

    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }
}

