/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.cmd;

import docking.widgets.ListSelectionTableDialog;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.dump.cmd.DumpPeShim;
import ghidra.file.formats.dump.cmd.ProgramInsertByteProvider;
import ghidra.program.database.ProgramDB;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.mem.Memory;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ModuleToPeHelper {
    public static void queryModules(Program program, TaskMonitor taskMon) {
        Memory memory = program.getMemory();
        ProgramModule root = program.getListing().getDefaultRootModule();
        Group[] children = root.getChildren();
        ArrayList<String> names = new ArrayList<String>();
        HashMap<String, Group> map = new HashMap<String, Group>();
        for (Group child : children) {
            names.add(child.getName());
            map.put(child.getName(), child);
        }
        ListSelectionTableDialog dialog = new ListSelectionTableDialog("Modules To Apply", names);
        List selected = dialog.showSelectMultiple(null);
        for (String key : selected) {
            ProgramFragment mod;
            Group value = (Group)map.get(key);
            if (!(value instanceof ProgramFragment) || (mod = (ProgramFragment)value).isEmpty()) continue;
            try {
                taskMon.setMessage("Analyzing " + mod.getName());
                taskMon.checkCanceled();
                ProgramInsertByteProvider provider = new ProgramInsertByteProvider(memory, mod);
                DumpPeShim loader = new DumpPeShim((ProgramDB)program);
                loader.load(provider, null, null, program, mod, taskMon, new MessageLog());
            }
            catch (Exception e) {
                Msg.error(null, (Object)e.getMessage());
                taskMon.clearCanceled();
            }
        }
    }
}

