/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.apport;

import aQute.lib.io.IO;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.FileByteProvider;
import ghidra.file.formats.dump.DumpFile;
import ghidra.file.formats.dump.apport.Apport;
import ghidra.file.formats.dump.apport.ApportHeader;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.AccessMode;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Base64;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class DecodedProvider
implements ByteProvider {
    private String name;
    private ApportHeader fileHeader;
    private long decompressedLength;
    private FileByteProvider tempProvider;
    private byte compressionMethod;
    private byte compressionHeaderFlags;
    private Object compressionTimeStamp;
    private byte compressionFlags;
    private byte compressionOS;

    public DecodedProvider(DumpFile df, ByteProvider provider, TaskMonitor monitor) throws CancelledException, IOException {
        Apport pt = (Apport)df;
        this.fileHeader = pt.getFileHeader();
        this.name = provider.getName() + "(decoded)";
        this.init(monitor);
    }

    private void init(TaskMonitor monitor) throws CancelledException, IOException {
        FileAttribute<Set<PosixFilePermission>> permissions = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-------"));
        File tempFile = Files.createTempFile("decode", ".dat", permissions).toFile();
        boolean success = false;
        try {
            try (OutputStream out = IO.outputStream((File)tempFile);){
                Base64.Decoder decoder = Base64.getDecoder();
                Inflater inflater = new Inflater(true);
                byte[] decompressed = new byte[0x10000000];
                monitor.setMessage("Decompressing data");
                monitor.initialize(this.decompressedLength);
                int written = 0;
                byte[] header = decoder.decode(this.fileHeader.getBlob(0).trim());
                this.parseHeader(header);
                for (int i = 1; i < this.fileHeader.getBlobCount(); ++i) {
                    monitor.checkCanceled();
                    byte[] decode = decoder.decode(this.fileHeader.getBlob(i).trim());
                    inflater.setInput(decode, 0, decode.length);
                    int nDecompressed = inflater.inflate(decompressed);
                    out.write(decompressed, 0, nDecompressed);
                    monitor.setProgress((long)(written += nDecompressed));
                }
                this.decompressedLength = written;
            }
            this.tempProvider = new FileByteProvider(tempFile, null, AccessMode.READ);
            success = true;
        }
        catch (DataFormatException e) {
            throw new IOException("apport decompress failure", e);
        }
        finally {
            if (!success) {
                tempFile.delete();
            }
        }
    }

    private void parseHeader(byte[] header) {
        this.compressionMethod = header[2];
        this.compressionHeaderFlags = header[3];
        this.compressionTimeStamp = ((header[4] << 8 | header[5]) << 8 | header[6]) << 8 | header[7];
        this.compressionFlags = header[8];
        this.compressionOS = header[9];
    }

    public File getFile() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getAbsolutePath() {
        return null;
    }

    public long length() {
        if (this.decompressedLength <= 0L) {
            throw new RuntimeException("Decompressed length = " + this.decompressedLength);
        }
        return this.decompressedLength;
    }

    public boolean isValidIndex(long index) {
        return index < this.length();
    }

    public void close() throws IOException {
        File tempFile = this.tempProvider.getFile();
        this.tempProvider.close();
        tempFile.delete();
    }

    public byte readByte(long index) throws IOException {
        return this.readBytes(index, 1L)[0];
    }

    public byte[] readBytes(long index, long length) throws IOException {
        try {
            return this.tempProvider.readBytes(index, length);
        }
        catch (IOException e) {
            return new byte[(int)length];
        }
    }

    public byte getCompressionMethod() {
        return this.compressionMethod;
    }

    public byte getCompressionHeaderFlags() {
        return this.compressionHeaderFlags;
    }

    public Object getCompressionTimeStamp() {
        return this.compressionTimeStamp;
    }

    public byte getCompressionFlags() {
        return this.compressionFlags;
    }

    public byte getCompressionOS() {
        return this.compressionOS;
    }
}

