/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.bplist;

import ghidra.file.formats.bplist.NSObject;
import ghidra.file.formats.bplist.NSStringTypes;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class NSString
extends NSObject {
    private String string;
    private NSStringTypes type;

    public NSString(String string, NSStringTypes type) {
        this.string = string;
        this.type = type;
    }

    @Override
    public String getType() {
        return "NSString";
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("NSString_" + this.string.length(), 0);
        this.addHeader((Structure)structure, this.string.length());
        if (this.string.length() > 0) {
            if (this.type == NSStringTypes.TYPE_ASCII) {
                structure.add(STRING, this.string.length(), "ascii", null);
            } else if (this.type == NSStringTypes.TYPE_UTF16BE) {
                structure.add(UTF16, this.string.length() * 2, "utf16be", null);
            } else {
                throw new RuntimeException();
            }
        }
        return structure;
    }

    @Override
    public String toString() {
        return this.string;
    }
}

