/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.vdex.headers;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.file.formats.android.dex.DexHeaderFactory;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.format.DexHeaderQuickMethods;
import ghidra.file.formats.android.vdex.VdexHeader;
import ghidra.file.formats.android.vdex.sections.DexSectionHeader_002;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class VdexHeader_006
extends VdexHeader {
    private String version_;
    private int number_of_dex_files_;
    private int dex_size_;
    private int verifier_deps_size_;
    private int quickening_info_size_;
    private int[] dex_checksums_;

    public VdexHeader_006(BinaryReader reader) throws IOException {
        super(reader);
        this.version_ = reader.readNextAsciiString(4);
        this.number_of_dex_files_ = reader.readNextInt();
        this.dex_size_ = reader.readNextInt();
        this.verifier_deps_size_ = reader.readNextInt();
        this.quickening_info_size_ = reader.readNextInt();
        this.dex_checksums_ = reader.readNextIntArray(this.number_of_dex_files_);
    }

    @Override
    public void parse(BinaryReader reader, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Parsing DEX files inside VDEX (oreo)...");
        monitor.setProgress(0L);
        monitor.setMaximum((long)(this.number_of_dex_files_ * 2));
        for (int i = 0; i < this.number_of_dex_files_; ++i) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            long index = reader.getPointerIndex();
            ByteProvider provider = reader.getByteProvider();
            ByteProviderWrapper tmpProvider = new ByteProviderWrapper(provider, index, provider.length() - index);
            BinaryReader tmpReader = new BinaryReader((ByteProvider)tmpProvider, reader.isLittleEndian());
            tmpReader.setPointerIndex(0);
            this.dexHeaderList.add(DexHeaderFactory.getDexHeader(tmpReader));
            tmpReader.setPointerIndex(0);
            int length = DexHeaderQuickMethods.getDexLength(tmpReader);
            this.dexHeaderStartsList.add(index);
            reader.setPointerIndex(index + (long)length);
        }
    }

    @Override
    public String getVersion() {
        return this.version_;
    }

    public int getNumberOfDexFiles() {
        return this.number_of_dex_files_;
    }

    public int getDexSize() {
        return this.dex_size_;
    }

    @Override
    public int getVerifierDepsSize() {
        return this.verifier_deps_size_;
    }

    @Override
    public int getQuickeningInfoSize() {
        return this.quickening_info_size_;
    }

    @Override
    public int[] getDexChecksums() {
        return this.dex_checksums_;
    }

    @Override
    public boolean isDexHeaderEmbeddedInDataType() {
        return true;
    }

    @Override
    public DexSectionHeader_002 getDexSectionHeader_002() {
        return null;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        int i;
        Structure structure = (Structure)super.toDataType();
        structure.add(STRING, 4, "version_", null);
        structure.add(DWORD, "number_of_dex_files_", null);
        structure.add(DWORD, "dex_size_", null);
        structure.add(DWORD, "verifier_deps_size_", null);
        structure.add(DWORD, "quickening_info_size_", null);
        for (i = 0; i < this.dex_checksums_.length; ++i) {
            structure.add(DWORD, "dex_checksums_" + i, null);
        }
        for (i = 0; i < this.dexHeaderList.size(); ++i) {
            DexHeader dexHeader = (DexHeader)this.dexHeaderList.get(i);
            DataType dexHeaderDataType = dexHeader.toDataType();
            try {
                dexHeaderDataType.setName(dexHeaderDataType.getName() + "_" + i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            structure.add(dexHeaderDataType, "dex_header_" + i, null);
            ArrayDataType array = new ArrayDataType(BYTE, dexHeader.getFileSize() - dexHeaderDataType.getLength(), BYTE.getLength());
            structure.add((DataType)array, "dex_header_bytes_" + i, null);
        }
        if (this.stringTable != null) {
            structure.add(this.stringTable.toDataType(), "strings", null);
        }
        return structure;
    }
}

