/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.prof;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.android.prof.ProfileConstants;
import ghidra.file.formats.android.prof.ProfileHeader;
import ghidra.file.formats.zlib.ZLIB;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.formats.gfilesystem.fileinfo.FileAttribute;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

@FileSystemInfo(type="prof", description="PROF", factory=GFileSystemBaseFactory.class)
public class ProfileFileSystem
extends GFileSystemBase {
    private ProfileHeader header;
    private GFileImpl dataFile;

    public ProfileFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        BinaryReader reader = new BinaryReader(this.provider, true);
        this.header = new ProfileHeader(reader);
        this.dataFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)"uncompressed-data", (boolean)false, (long)this.header.getUncompressedSizeOfZippedData(), null);
    }

    public void close() throws IOException {
        super.close();
        this.header = null;
        this.dataFile = null;
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        if (this.dataFile.equals((Object)file)) {
            InputStream compressedStream = this.provider.getInputStream((long)this.header.getCompressedDataOffset());
            ZLIB zlib = new ZLIB();
            ByteArrayOutputStream decompressedBytes = zlib.decompress(compressedStream, this.header.getUncompressedSizeOfZippedData());
            return new ByteArrayProvider(decompressedBytes.toByteArray(), file.getFSRL());
        }
        return null;
    }

    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        if (file == this.dataFile) {
            return FileAttributes.of((FileAttribute[])new FileAttribute[]{FileAttribute.create((String)"Magic", (Object)this.header.getMagic())});
        }
        return null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        ArrayList<GFile> list = new ArrayList<GFile>();
        if (directory == null || directory.equals(this.root)) {
            list.add((GFile)this.dataFile);
        }
        return list;
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        return ProfileConstants.isProfile(this.provider);
    }
}

