/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBBlock;
import SWIG.SBFunction;
import SWIG.SBStream;
import agent.lldb.lldb.DebugClient;
import agent.lldb.model.iface2.LldbModelTargetFunction;
import agent.lldb.model.iface2.LldbModelTargetStackFrame;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import agent.lldb.model.impl.LldbModelTargetStackFrameImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="Function", attributes={@TargetAttributeType(type=Object.class)}, canonicalContainer=true)
public class LldbModelTargetFunctionImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetFunction {
    protected final LldbModelTargetStackFrame frame;
    protected final Map<Integer, LldbModelTargetStackFrameImpl> framesByLevel = new WeakValueHashMap();

    protected static String keyFunction(SBFunction fn) {
        return PathUtils.makeKey((String)DebugClient.getId(fn));
    }

    public LldbModelTargetFunctionImpl(LldbModelTargetStackFrame frame, SBFunction function) {
        super(frame.getModel(), (TargetObject)frame, "Function", function, "Function");
        this.frame = frame;
        if (function.IsValid()) {
            String mangledName;
            AddressSpace space = this.getModel().getAddressSpace("ram");
            Address min = space.getAddress(function.GetStartAddress().GetOffset().longValue());
            Address max = space.getAddress(function.GetStartAddress().GetOffset().longValue());
            String name = function.GetName();
            String displayName = function.GetDisplayName();
            if (displayName == null) {
                displayName = name;
            }
            if ((mangledName = function.GetMangledName()) == null) {
                mangledName = name;
            }
            long prologSize = function.GetPrologueByteSize();
            this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDescription(0), "Start", min, "End", max, "Language", function.GetLanguage().toString(), "Name", name, "Display Name", displayName, "Mangled Name", mangledName, "Prolog Size", prologSize, "Block", this.getBlockDescription(function.GetBlock())), "Initialized");
        }
    }

    @Override
    public String getDescription(int level) {
        SBStream stream = new SBStream();
        SBFunction function = (SBFunction)this.getModelObject();
        function.GetDescription(stream);
        return stream.GetData();
    }

    public String getBlockDescription(SBBlock block) {
        SBStream stream = new SBStream();
        block.GetDescription(stream);
        return stream.GetData();
    }
}

