/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.iface2;

import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.LldbEventsListenerAdapter;
import agent.lldb.model.iface1.LldbModelSelectableObject;
import agent.lldb.model.iface1.LldbModelTargetAccessConditioned;
import agent.lldb.model.iface1.LldbModelTargetExecutionStateful;
import agent.lldb.model.iface1.LldbModelTargetInterpreter;
import agent.lldb.model.iface1.LldbModelTargetInterruptible;
import agent.lldb.model.iface1.LldbModelTargetResumable;
import agent.lldb.model.iface2.LldbModelTargetModuleContainer;
import agent.lldb.model.iface2.LldbModelTargetProcessContainer;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.target.TargetAggregate;
import ghidra.dbg.target.TargetConsole;
import java.util.List;
import java.util.Map;

public interface LldbModelTargetSession
extends LldbModelTargetAccessConditioned,
LldbModelTargetExecutionStateful,
LldbModelTargetInterpreter,
LldbModelTargetInterruptible,
LldbModelTargetResumable,
LldbEventsListenerAdapter,
LldbModelSelectableObject,
TargetAggregate {
    public LldbModelTargetProcessContainer getProcesses();

    public LldbModelTargetModuleContainer getModules();

    @Override
    default public void consoleOutput(String output, int mask) {
        TargetConsole.Channel chan = TargetConsole.Channel.STDOUT;
        if (((long)mask & DebugClient.DebugOutputFlags.DEBUG_OUTPUT_ERROR.getValue()) == DebugClient.DebugOutputFlags.DEBUG_OUTPUT_ERROR.getValue() || ((long)mask & DebugClient.DebugOutputFlags.DEBUG_OUTPUT_WARNING.getValue()) == DebugClient.DebugOutputFlags.DEBUG_OUTPUT_WARNING.getValue()) {
            chan = TargetConsole.Channel.STDERR;
        }
        if (output.contains("loaded *kernel* extension dll for usermode")) {
            return;
        }
        ((DebuggerModelListener)this.getListeners().fire).consoleOutput(this.getProxy(), chan, output);
    }

    @Override
    default public void promptChanged(String prompt) {
        this.changeAttributes(List.of(), Map.of("_prompt", prompt), "Refreshed");
    }
}

