/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.SBBreakpoint;
import SWIG.SBTarget;
import SWIG.SBWatchpoint;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.impl.LldbManagerImpl;

public class LldbDeleteBreakpointsCommand
extends AbstractLldbCommand<Void> {
    private final String[] ids;

    public LldbDeleteBreakpointsCommand(LldbManagerImpl manager, String ... ids) {
        super(manager);
        this.ids = ids;
    }

    @Override
    public Void complete(LldbPendingCommand<?> pending) {
        SBTarget currentSession = this.manager.getCurrentSession();
        for (String id : this.ids) {
            this.manager.doBreakpointDeleted(currentSession, id, pending);
        }
        return null;
    }

    @Override
    public void invoke() {
        SBTarget currentSession = this.manager.getCurrentSession();
        for (String id : this.ids) {
            Object info = this.manager.getBreakpoint(currentSession, id);
            if (info instanceof SBBreakpoint) {
                SBBreakpoint bpt = (SBBreakpoint)info;
                currentSession.BreakpointDelete(bpt.GetID());
            }
            if (!(info instanceof SBWatchpoint)) continue;
            SBWatchpoint wpt = (SBWatchpoint)info;
            currentSession.DeleteWatchpoint(wpt.GetID());
        }
    }
}

