/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.app.services.MapEntry;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceStaticMappingManager;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public interface MapProposal<T, P, E extends MapEntry<T, P>> {
    public static <T, P, E extends MapEntry<T, P>, M extends MapProposal<T, P, E>> Collection<E> flatten(Collection<M> proposals) {
        LinkedHashSet<E> result = new LinkedHashSet<E>();
        for (MapProposal map : proposals) {
            result.addAll(map.computeMap().values());
        }
        return result;
    }

    public static <E extends MapEntry<?, ?>> Set<E> removeOverlapping(Collection<E> entries) {
        return entries.stream().filter(e -> {
            TraceStaticMappingManager manager = e.getFromTrace().getStaticMappingManager();
            return manager.findAllOverlapping(e.getFromRange(), e.getFromLifespan()).isEmpty();
        }).collect(Collectors.toSet());
    }

    public Trace getTrace();

    public Program getProgram();

    public P getToObject(T var1);

    public double computeScore();

    public Map<T, E> computeMap();
}

