/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.app.plugin.core.debug.service.workflow.DebuggerWorkflowServicePlugin;
import ghidra.app.services.DebuggerBotInfo;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.framework.options.AutoOptions;
import ghidra.framework.options.annotation.HelpInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.lifecycle.Internal;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.classfinder.ExtensionPoint;

public interface DebuggerBot
extends ExtensionPoint {
    @Internal
    public static void noAnnot(Class<?> cls, String methodName) {
        Msg.error(DebuggerBot.class, (Object)("Debugger bot " + cls + " must apply @" + DebuggerBotInfo.class.getSimpleName() + " or override getDescription()"));
    }

    @Internal
    public static DebuggerBotInfo getInfo(Class<?> cls, String methodName) {
        DebuggerBotInfo info = cls.getAnnotation(DebuggerBotInfo.class);
        if (info == null) {
            DebuggerBot.noAnnot(cls, methodName);
        }
        return info;
    }

    default public String getDescription() {
        DebuggerBotInfo info = DebuggerBot.getInfo(this.getClass(), "getDescription");
        if (info == null) {
            return "<NO DESCRIPTION>";
        }
        return info.description();
    }

    default public String getDetails() {
        DebuggerBotInfo info = DebuggerBot.getInfo(this.getClass(), "getDetails");
        if (info == null) {
            return "";
        }
        return info.details();
    }

    default public HelpLocation getHelpLocation() {
        DebuggerBotInfo info = DebuggerBot.getInfo(this.getClass(), "getHelpLocation");
        if (info == null) {
            return null;
        }
        return AutoOptions.getHelpLocation((String)"DebuggerBots", (HelpInfo)info.help());
    }

    default public boolean isEnabledByDefault() {
        DebuggerBotInfo info = DebuggerBot.getInfo(this.getClass(), "isEnabledByDefault");
        if (info == null) {
            return false;
        }
        return info.enabledByDefault();
    }

    public boolean isEnabled();

    default public void setEnabled(DebuggerWorkflowServicePlugin plugin, boolean enabled) {
        if (this.isEnabled() == enabled) {
            return;
        }
        if (enabled) {
            this.enable(plugin);
        } else {
            this.disable();
        }
    }

    public void enable(DebuggerWorkflowServicePlugin var1);

    public void disable();

    default public void modelAdded(DebuggerObjectModel model) {
    }

    default public void modelRemoved(DebuggerObjectModel model) {
    }

    default public void programOpened(PluginTool tool, Program program) {
    }

    default public void programClosed(PluginTool tool, Program program) {
    }

    default public void traceOpened(PluginTool tool, Trace trace) {
    }

    default public void traceClosed(PluginTool tool, Trace trace) {
    }
}

