/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.gdb;

import ghidra.app.plugin.core.debug.mapping.DebuggerMappingOffer;
import ghidra.app.plugin.core.debug.platform.gdb.DefaultGdbDebuggerMappingOpinion;
import ghidra.dbg.target.TargetObject;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.util.DefaultLanguageService;
import java.util.Collection;
import java.util.Set;

public class GdbArmDebuggerMappingOpinion
extends DefaultGdbDebuggerMappingOpinion {
    @Override
    protected Set<DebuggerMappingOffer> offersForLanguageAndCSpec(TargetObject target, String arch, Endian endian, LanguageCompilerSpecPair lcsp) {
        LanguageDescription desc;
        LanguageService langServ = DefaultLanguageService.getLanguageService();
        try {
            desc = langServ.getLanguageDescription(lcsp.languageID);
        }
        catch (LanguageNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        String proc = desc.getProcessor().toString();
        if ("ARM".equalsIgnoreCase(proc)) {
            if ("Cortex".equalsIgnoreCase(desc.getVariant())) {
                return Set.of(new GdbArmOffer(target, 50, "ARM-Cortex/GDB for " + arch, lcsp, Set.of()));
            }
            return Set.of(new GdbArmOffer(target, 50, "ARM/GDB for " + arch, lcsp, Set.of("cpsr")));
        }
        if ("AARCH64".equalsIgnoreCase(proc)) {
            return Set.of(new GdbAArch64Offer(target, 50, "AARCH64/GDB for " + arch, lcsp, Set.of("cpsr")));
        }
        return Set.of();
    }

    protected static class GdbArmOffer
    extends DefaultGdbDebuggerMappingOpinion.GdbDefaultOffer {
        public GdbArmOffer(TargetObject target, int confidence, String description, LanguageCompilerSpecPair lcsp, Collection<String> extraRegNames) {
            super(target, confidence, description, lcsp, extraRegNames);
        }
    }

    protected static class GdbAArch64Offer
    extends DefaultGdbDebuggerMappingOpinion.GdbDefaultOffer {
        public GdbAArch64Offer(TargetObject target, int confidence, String description, LanguageCompilerSpecPair lcsp, Collection<String> extraRegNames) {
            super(target, confidence, description, lcsp, extraRegNames);
        }
    }
}

