/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.time;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.time.DebuggerSnapshotTablePanel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.trace.model.Trace;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DebuggerTimeSelectionDialog
extends DialogComponentProvider {
    private final PluginTool tool;
    DebuggerSnapshotTablePanel snapshotPanel;
    JTextField scheduleText;
    TraceSchedule schedule;
    JButton tickStep;
    JButton tickBack;
    JButton opStep;
    JButton opBack;

    public DebuggerTimeSelectionDialog(PluginTool tool) {
        super("Select Time", true, true, true, false);
        this.tool = tool;
        this.populateComponents();
    }

    protected void doStep(Function<TraceSchedule, TraceSchedule> stepper) {
        try {
            TraceSchedule stepped = stepper.apply(this.schedule);
            if (stepped == null) {
                return;
            }
            this.setScheduleText(stepped.toString());
        }
        catch (Throwable e) {
            Msg.warn((Object)((Object)this), (Object)e.getMessage());
        }
    }

    protected void populateComponents() {
        JPanel workPanel = new JPanel(new BorderLayout());
        Box hbox = Box.createHorizontalBox();
        hbox.setBorder(BorderFactory.createTitledBorder("Schedule"));
        hbox.add(new JLabel("Expression: "));
        this.scheduleText = new JTextField();
        hbox.add(this.scheduleText);
        hbox.add(new JLabel("Ticks: "));
        this.tickBack = new JButton(DebuggerResources.ICON_STEP_BACK);
        hbox.add(this.tickBack);
        this.tickStep = new JButton(DebuggerResources.ICON_STEP_INTO);
        hbox.add(this.tickStep);
        hbox.add(new JLabel("Ops: "));
        this.opBack = new JButton(DebuggerResources.ICON_STEP_BACK);
        hbox.add(this.opBack);
        this.opStep = new JButton(DebuggerResources.ICON_STEP_INTO);
        hbox.add(this.opStep);
        workPanel.add((Component)hbox, "North");
        this.tickBack.addActionListener(evt -> this.doStep(s -> s.steppedBackward(this.getTrace(), 1L)));
        this.tickStep.addActionListener(evt -> this.doStep(s -> s.steppedForward(null, 1L)));
        this.opBack.addActionListener(evt -> this.doStep(s -> s.steppedPcodeBackward(1)));
        this.opStep.addActionListener(evt -> this.doStep(s -> s.steppedPcodeForward(null, 1)));
        this.snapshotPanel = new DebuggerSnapshotTablePanel(this.tool);
        workPanel.add((Component)this.snapshotPanel, "Center");
        this.snapshotPanel.getSelectionModel().addListSelectionListener(evt -> {
            Long snap = this.snapshotPanel.getSelectedSnapshot();
            if (snap == null) {
                return;
            }
            if (this.schedule.getSnap() == snap.longValue()) {
                return;
            }
            this.scheduleText.setText(snap.toString());
        });
        this.scheduleText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DebuggerTimeSelectionDialog.this.scheduleTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DebuggerTimeSelectionDialog.this.scheduleTextChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DebuggerTimeSelectionDialog.this.scheduleTextChanged();
            }
        });
        this.addWorkPanel(workPanel);
        this.addOKButton();
        this.addCancelButton();
        this.setMinimumSize(600, 600);
    }

    protected void scheduleTextChanged() {
        this.schedule = null;
        try {
            this.schedule = TraceSchedule.parse((String)this.scheduleText.getText());
            this.snapshotPanel.setSelectedSnapshot(this.schedule.getSnap());
            this.schedule.validate(this.getTrace());
            this.setStatusText("");
            this.setOkEnabled(true);
        }
        catch (Exception e) {
            this.setStatusText(e.getMessage(), MessageType.ERROR);
            this.setOkEnabled(false);
        }
        this.enableStepButtons(this.schedule != null);
    }

    protected void enableStepButtons(boolean enabled) {
        this.tickBack.setEnabled(enabled);
        this.tickStep.setEnabled(enabled);
        this.opBack.setEnabled(enabled);
        this.opStep.setEnabled(enabled);
    }

    public void okCallback() {
        assert (this.schedule != null);
        super.okCallback();
        this.close();
    }

    public void cancelCallback() {
        this.schedule = null;
        super.cancelCallback();
    }

    public void close() {
        super.close();
        this.snapshotPanel.setTrace(null);
        this.snapshotPanel.setSelectedSnapshot(null);
    }

    public TraceSchedule promptTime(Trace trace, TraceSchedule defaultTime) {
        this.snapshotPanel.setTrace(trace);
        this.schedule = defaultTime;
        this.scheduleText.setText(defaultTime.toString());
        this.tool.showDialog((DialogComponentProvider)this);
        return this.schedule;
    }

    public Trace getTrace() {
        return this.snapshotPanel.getTrace();
    }

    public void setScheduleText(String text) {
        this.scheduleText.setText(text);
    }
}

