/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.stack;

import com.google.common.collect.Range;
import ghidra.app.plugin.core.debug.gui.stack.DebuggerStackProvider;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.database.UndoableTransaction;

public class StackFrameRow {
    private final DebuggerStackProvider provider;
    final TraceStackFrame frame;
    private int level;

    public StackFrameRow(DebuggerStackProvider provider, TraceStackFrame frame) {
        this.provider = provider;
        this.frame = frame;
        this.level = frame.getLevel();
    }

    private StackFrameRow(DebuggerStackProvider provider) {
        this.provider = provider;
        this.frame = null;
        this.level = 0;
    }

    public int getFrameLevel() {
        return this.level;
    }

    public long getSnap() {
        return this.provider.current.getSnap();
    }

    public Address getProgramCounter() {
        return this.frame.getProgramCounter(this.getSnap());
    }

    public String getComment() {
        return this.frame == null ? "" : this.frame.getComment(this.getSnap());
    }

    public void setComment(String comment) {
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.frame.getStack().getThread().getTrace(), (String)"Frame comment");){
            this.frame.setComment(this.getSnap(), comment);
        }
    }

    public boolean isCommentable() {
        return this.frame != null;
    }

    public Function getFunction() {
        if (this.provider.mappingService == null) {
            return null;
        }
        TraceThread curThread = this.provider.current.getThread();
        if (curThread == null) {
            return null;
        }
        Address pc = this.getProgramCounter();
        if (pc == null) {
            return null;
        }
        DefaultTraceLocation dloc = new DefaultTraceLocation(curThread.getTrace(), curThread, Range.singleton((Comparable)Long.valueOf(this.getSnap())), pc);
        ProgramLocation sloc = this.provider.mappingService.getOpenMappedLocation((TraceLocation)dloc);
        if (sloc == null) {
            return null;
        }
        return sloc.getProgram().getFunctionManager().getFunctionContaining(sloc.getAddress());
    }

    protected void update() {
        assert (this.frame != null);
        this.level = this.frame.getLevel();
    }

    public static class Synthetic
    extends StackFrameRow {
        private Address pc;

        public Synthetic(DebuggerStackProvider provider, Address pc) {
            super(provider);
            this.pc = pc;
        }

        public void updateProgramCounter(Address pc) {
            this.pc = pc;
        }

        @Override
        public Address getProgramCounter() {
            return this.pc;
        }
    }
}

