/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.actions;

import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayAsAction;
import ghidra.app.services.ConsoleService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.xml.XmlUtilities;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jdom.Element;
import resources.ResourceManager;

public class DisplayAsXMLAction
extends DisplayAsAction {
    protected ConsoleService consoleService;
    protected ImageIcon ICON_XML = ResourceManager.loadImage((String)"images/text-xml.png");

    public DisplayAsXMLAction(PluginTool tool, String owner, DebuggerObjectsProvider provider) {
        super("DisplayXml", tool, owner, provider);
        String[] path = new String[]{"Display as...", "XML"};
        this.setPopupMenuData(new MenuData(path, (Icon)this.ICON_XML));
        this.setKeyBindingData(new KeyBindingData(69, 128));
        this.setHelpLocation(new HelpLocation(owner, "display_as_xml"));
        provider.addLocalAction((DockingActionIf)this);
    }

    @Override
    protected void doAction(ObjectContainer container) {
        this.consoleService = this.provider.getConsoleService();
        if (this.consoleService == null) {
            Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"DisplayAsXML Error", (Object)"ConsoleService not found: Please add a console service provider to your tool");
            return;
        }
        this.writeXml(container);
    }

    public void writeXml(ObjectContainer container) {
        Element root = container.toXml();
        XmlUtilities.setStringAttr((Element)root, (String)"Path", (String)container.getTargetObject().getJoinedPath("."));
        this.consoleService.println(XmlUtilities.toString((Element)root));
    }
}

