/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model.columns;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.sort.ColumnRenderedValueBackupComparator;
import docking.widgets.table.sort.DefaultColumnComparator;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.model.ColorsModified;
import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.dbg.target.TargetAttacher;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.target.schema.SchemaContext;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.Comparator;
import java.util.function.Function;
import javax.swing.JTable;

public class TraceValueObjectAttributeColumn
extends AbstractDynamicTableColumn<ObjectTableModel.ValueRow, ObjectTableModel.ValueRow, Trace> {
    private final String attributeName;
    private final Class<?> attributeType;
    private final AttributeRenderer renderer = new AttributeRenderer();
    private final Comparator<ObjectTableModel.ValueRow> comparator;
    private Color diffColor = DebuggerResources.DEFAULT_COLOR_VALUE_CHANGED;
    private Color diffColorSel = DebuggerResources.DEFAULT_COLOR_VALUE_CHANGED_SEL;

    public static Class<?> computeColumnType(SchemaContext ctx, TargetObjectSchema.AttributeSchema attributeSchema) {
        TargetObjectSchema schema = ctx.getSchema(attributeSchema.getSchema());
        Class type = schema.getType();
        if (type == TargetObject.class) {
            return TraceObject.class;
        }
        if (type == TargetExecutionStateful.TargetExecutionState.class) {
            return String.class;
        }
        if (type == TargetMethod.TargetParameterMap.class) {
            return String.class;
        }
        if (type == TargetAttacher.TargetAttachKindSet.class) {
            return String.class;
        }
        if (type == TargetBreakpointSpecContainer.TargetBreakpointKindSet.class) {
            return String.class;
        }
        if (type == TargetSteppable.TargetStepKindSet.class) {
            return String.class;
        }
        return type;
    }

    public static TraceValueObjectAttributeColumn fromSchema(SchemaContext ctx, TargetObjectSchema.AttributeSchema attributeSchema) {
        String name = attributeSchema.getName();
        Class<?> type = TraceValueObjectAttributeColumn.computeColumnType(ctx, attributeSchema);
        return new TraceValueObjectAttributeColumn(name, type);
    }

    public TraceValueObjectAttributeColumn(String attributeName, Class<?> attributeType) {
        this.attributeName = attributeName;
        this.attributeType = attributeType;
        this.comparator = this.newTypedComparator();
    }

    public String getColumnName() {
        return this.attributeName;
    }

    public ObjectTableModel.ValueRow getValue(ObjectTableModel.ValueRow rowObject, Settings settings, Trace data, ServiceProvider serviceProvider) throws IllegalArgumentException {
        return rowObject;
    }

    public GColumnRenderer<ObjectTableModel.ValueRow> getColumnRenderer() {
        return this.renderer;
    }

    public Comparator<ObjectTableModel.ValueRow> getComparator(DynamicColumnTableModel<?> model, int columnIndex) {
        return this.comparator == null ? null : this.comparator.thenComparing((Comparator<ObjectTableModel.ValueRow>)new ColumnRenderedValueBackupComparator(model, columnIndex));
    }

    protected Object getAttributeValue(ObjectTableModel.ValueRow row) {
        TraceObjectValue edge = row.getAttribute(this.attributeName);
        return edge == null ? null : edge.getValue();
    }

    protected <C extends Comparable<C>> Comparator<ObjectTableModel.ValueRow> newTypedComparator() {
        if (Comparable.class.isAssignableFrom(this.attributeType)) {
            Class<Comparable> cls = this.attributeType.asSubclass(Comparable.class);
            Function<ObjectTableModel.ValueRow, Comparable> keyExtractor = r -> (Comparable)cls.cast(this.getAttributeValue((ObjectTableModel.ValueRow)r));
            return Comparator.comparing(keyExtractor, new DefaultColumnComparator());
        }
        return null;
    }

    public void setDiffColor(Color diffColor) {
        this.diffColor = diffColor;
    }

    public void setDiffColorSel(Color diffColorSel) {
        this.diffColorSel = diffColorSel;
    }

    public class AttributeRenderer
    extends AbstractGColumnRenderer<ObjectTableModel.ValueRow>
    implements ColorsModified.InTable {
        public AttributeRenderer() {
            this.setHTMLRenderingEnabled(true);
        }

        public String getFilterString(ObjectTableModel.ValueRow t, Settings settings) {
            return t.getAttributeDisplay(TraceValueObjectAttributeColumn.this.attributeName);
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            ObjectTableModel.ValueRow row = (ObjectTableModel.ValueRow)data.getValue();
            this.setText(row.getAttributeHtmlDisplay(TraceValueObjectAttributeColumn.this.attributeName));
            this.setToolTipText(row.getAttributeToolTip(TraceValueObjectAttributeColumn.this.attributeName));
            this.setForeground(this.getForegroundFor(data.getTable(), row.isAttributeModified(TraceValueObjectAttributeColumn.this.attributeName), data.isSelected()));
            return this;
        }

        @Override
        public Color getDiffForeground(JTable table) {
            return TraceValueObjectAttributeColumn.this.diffColor;
        }

        @Override
        public Color getDiffSelForeground(JTable table) {
            return TraceValueObjectAttributeColumn.this.diffColorSel;
        }
    }
}

