/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import com.google.common.collect.Range;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeRenderer;
import docking.widgets.tree.support.GTreeSelectionEvent;
import docking.widgets.tree.support.GTreeSelectionListener;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.model.ColorsModified;
import ghidra.app.plugin.core.debug.gui.model.KeepTreeState;
import ghidra.app.plugin.core.debug.gui.model.ObjectTreeModel;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObjectKeyPath;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class ObjectsTreePanel
extends JPanel {
    protected final ObjectTreeModel treeModel;
    protected final GTree tree;
    protected DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    protected boolean limitToSnap = true;
    protected boolean showHidden = false;
    protected boolean showPrimitives = false;
    protected boolean showMethods = false;
    protected Color diffColor = DebuggerResources.DEFAULT_COLOR_VALUE_CHANGED;
    protected Color diffColorSel = DebuggerResources.DEFAULT_COLOR_VALUE_CHANGED_SEL;

    public ObjectsTreePanel() {
        super(new BorderLayout());
        this.treeModel = this.createModel();
        this.tree = new GTree((GTreeNode)this.treeModel.getRoot());
        this.tree.setCellRenderer((GTreeRenderer)new ObjectsTreeRenderer());
        this.add((Component)this.tree, "Center");
    }

    protected ObjectTreeModel createModel() {
        return new ObjectTreeModel();
    }

    protected KeepTreeState keepTreeState() {
        return new KeepTreeState(this.tree);
    }

    protected Trace computeDiffTrace(Trace current, Trace previous) {
        if (current == null) {
            return null;
        }
        if (previous == null) {
            return current;
        }
        return previous;
    }

    public void goToCoordinates(DebuggerCoordinates coords) {
        if (DebuggerCoordinates.equalsIgnoreRecorderAndView(this.current, coords)) {
            return;
        }
        DebuggerCoordinates previous = this.current;
        this.current = coords;
        if (previous.getSnap() == this.current.getSnap() && previous.getTrace() == this.current.getTrace()) {
            return;
        }
        try (KeepTreeState keep = this.keepTreeState();){
            this.treeModel.setDiffTrace(this.computeDiffTrace(this.current.getTrace(), previous.getTrace()));
            this.treeModel.setTrace(this.current.getTrace());
            this.treeModel.setDiffSnap(previous.getSnap());
            this.treeModel.setSnap(this.current.getSnap());
            if (this.limitToSnap) {
                this.treeModel.setSpan((Range<Long>)Range.singleton((Comparable)Long.valueOf(this.current.getSnap())));
            }
            this.tree.filterChanged();
        }
    }

    public void setLimitToSnap(boolean limitToSnap) {
        if (this.limitToSnap == limitToSnap) {
            return;
        }
        this.limitToSnap = limitToSnap;
        try (KeepTreeState keep = this.keepTreeState();){
            this.treeModel.setSpan((Range<Long>)(limitToSnap ? Range.singleton((Comparable)Long.valueOf(this.current.getSnap())) : Range.all()));
        }
    }

    public boolean isLimitToSnap() {
        return this.limitToSnap;
    }

    public void setShowHidden(boolean showHidden) {
        if (this.showHidden == showHidden) {
            return;
        }
        this.showHidden = showHidden;
        try (KeepTreeState keep = this.keepTreeState();){
            this.treeModel.setShowHidden(showHidden);
        }
    }

    public boolean isShowHidden() {
        return this.showHidden;
    }

    public void setShowPrimitives(boolean showPrimitives) {
        if (this.showPrimitives == showPrimitives) {
            return;
        }
        this.showPrimitives = showPrimitives;
        try (KeepTreeState keep = this.keepTreeState();){
            this.treeModel.setShowPrimitives(showPrimitives);
        }
    }

    public boolean isShowPrimitives() {
        return this.showPrimitives;
    }

    public void setShowMethods(boolean showMethods) {
        if (this.showMethods == showMethods) {
            return;
        }
        this.showMethods = showMethods;
        try (KeepTreeState keep = this.keepTreeState();){
            this.treeModel.setShowMethods(showMethods);
        }
    }

    public boolean isShowMethods() {
        return this.showMethods;
    }

    public void setDiffColor(Color diffColor) {
        if (Objects.equals(this.diffColor, diffColor)) {
            return;
        }
        this.diffColor = diffColor;
        this.repaint();
    }

    public void setDiffColorSel(Color diffColorSel) {
        if (Objects.equals(this.diffColorSel, diffColorSel)) {
            return;
        }
        this.diffColorSel = diffColorSel;
        this.repaint();
    }

    public void addTreeSelectionListener(GTreeSelectionListener listener) {
        this.tree.addGTreeSelectionListener(listener);
    }

    public void removeTreeSelectionListener(GTreeSelectionListener listener) {
        this.tree.removeGTreeSelectionListener(listener);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.tree.addMouseListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        this.tree.removeMouseListener(l);
    }

    public void setSelectionMode(int selectionMode) {
        this.tree.getSelectionModel().setSelectionMode(selectionMode);
    }

    public int getSelectionMode() {
        return this.tree.getSelectionModel().getSelectionMode();
    }

    protected <R, A> R getItemsFromPaths(TreePath[] paths, Collector<? super ObjectTreeModel.AbstractNode, A, R> collector) {
        return Stream.of(paths).map(p -> (ObjectTreeModel.AbstractNode)((Object)((Object)p.getLastPathComponent()))).collect(collector);
    }

    protected ObjectTreeModel.AbstractNode getItemFromPath(TreePath path) {
        if (path == null) {
            return null;
        }
        return (ObjectTreeModel.AbstractNode)((Object)path.getLastPathComponent());
    }

    public List<ObjectTreeModel.AbstractNode> getSelectedItems() {
        return this.getItemsFromPaths(this.tree.getSelectionPaths(), Collectors.toList());
    }

    public ObjectTreeModel.AbstractNode getSelectedItem() {
        return this.getItemFromPath(this.tree.getSelectionPath());
    }

    public ObjectTreeModel.AbstractNode getNode(TraceObjectKeyPath path) {
        return this.treeModel.getNode(path);
    }

    public void setSelectedKeyPaths(Collection<TraceObjectKeyPath> keyPaths, GTreeSelectionEvent.EventOrigin origin) {
        ArrayList<TreePath> treePaths = new ArrayList<TreePath>();
        for (TraceObjectKeyPath path : keyPaths) {
            ObjectTreeModel.AbstractNode node = this.getNode(path);
            if (node == null) continue;
            treePaths.add(node.getTreePath());
        }
        this.tree.setSelectionPaths((TreePath[])treePaths.toArray(TreePath[]::new), origin);
    }

    public void setSelectedKeyPaths(Collection<TraceObjectKeyPath> keyPaths) {
        this.setSelectedKeyPaths(keyPaths, GTreeSelectionEvent.EventOrigin.API_GENERATED);
    }

    protected class ObjectsTreeRenderer
    extends GTreeRenderer
    implements ColorsModified.InTree {
        protected ObjectsTreeRenderer() {
            this.setHTMLRenderingEnabled(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (!(value instanceof ObjectTreeModel.AbstractNode)) {
                return this;
            }
            ObjectTreeModel.AbstractNode node = (ObjectTreeModel.AbstractNode)((Object)value);
            this.setForeground(this.getForegroundFor(tree, node.isModified(), selected));
            return this;
        }

        @Override
        public Color getDiffForeground(JTree tree) {
            return ObjectsTreePanel.this.diffColor;
        }

        @Override
        public Color getDiffSelForeground(JTree tree) {
            return ObjectsTreePanel.this.diffColorSel;
        }
    }
}

