/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.debug.gui.action.DebuggerGoToTrait;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.async.AsyncUtils;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class DebuggerGoToDialog
extends DialogComponentProvider {
    private final DebuggerGoToTrait trait;
    private final DefaultComboBoxModel<String> modelSpaces;
    final JTextField textExpression;
    final JComboBox<String> comboSpaces;

    public DebuggerGoToDialog(DebuggerGoToTrait trait) {
        super("Go To", true, true, true, false);
        this.trait = trait;
        this.textExpression = new JTextField();
        this.modelSpaces = new DefaultComboBoxModel();
        this.comboSpaces = new JComboBox<String>(this.modelSpaces);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(16, 16, 16, 16));
        JLabel help = new JLabel("<html>Enter any sleigh expression to evaluate against the current thread.<br/>Note that constants and memory derefs must have a resolved size.<br/>Examples:<br/><ul><li>To go to a constant address: <code>0x00401234:4</code></li><li>To go to the address in a register: <code>RAX</code></li><li>To dereference the pointer at an address in a register: <code>*:8 RAX</code></li></ul></html>");
        help.getMaximumSize().width = 400;
        panel.add((Component)help, "North");
        Box box = Box.createHorizontalBox();
        box.setBorder(new EmptyBorder(16, 0, 0, 0));
        panel.add(box);
        box.add(new JLabel("*["));
        box.add(this.comboSpaces);
        box.add(new JLabel("]"));
        box.add(this.textExpression);
        this.addWorkPanel(panel);
        this.setFocusComponent(this.textExpression);
        this.addOKButton();
        this.addCancelButton();
    }

    protected void populateSpaces(SleighLanguage language) {
        String curSpace = (String)this.comboSpaces.getSelectedItem();
        this.modelSpaces.removeAllElements();
        AddressFactory factory = language.getAddressFactory();
        List names = Stream.of(factory.getAddressSpaces()).filter(AddressSpace::isMemorySpace).map(AddressSpace::getName).collect(Collectors.toList());
        this.modelSpaces.addAll(names);
        if (names.contains(curSpace)) {
            this.comboSpaces.setSelectedItem(curSpace);
        } else {
            this.comboSpaces.setSelectedItem(factory.getDefaultAddressSpace().getName());
        }
    }

    public void okCallback() {
        CompletableFuture<Object> future;
        try {
            future = this.trait.goToSleigh((String)this.comboSpaces.getSelectedItem(), this.textExpression.getText());
        }
        catch (Throwable t) {
            future = CompletableFuture.failedFuture(t);
        }
        ((CompletableFuture)future.thenAccept(success -> {
            if (!success.booleanValue()) {
                this.setStatusText("Address not in trace", MessageType.ERROR, true);
            } else {
                this.close();
            }
        })).exceptionally(ex -> {
            ex = AsyncUtils.unwrapThrowable((Throwable)ex);
            Msg.error((Object)((Object)this), (Object)ex.getMessage(), (Throwable)ex);
            this.setStatusText(ex.getMessage(), MessageType.ERROR, true);
            return null;
        });
    }

    public void cancelCallback() {
        this.close();
    }

    public void show(SleighLanguage language) {
        this.populateSpaces(language);
        this.trait.tool.showDialog((DialogComponentProvider)this);
    }

    public void setExpression(String expression) {
        this.textExpression.setText(expression);
    }
}

