/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile;

import docking.widgets.fieldpanel.support.ViewerPosition;
import ghidra.app.nav.LocationMemento;
import ghidra.framework.options.SaveState;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;

public class DecompilerLocationMemento
extends LocationMemento {
    private final ViewerPosition viewerPosition;

    public DecompilerLocationMemento(Program program, ProgramLocation location, ViewerPosition viewerPosition) {
        super(program, location);
        this.viewerPosition = viewerPosition;
    }

    public DecompilerLocationMemento(SaveState saveState, Program[] programs) {
        super(saveState, programs);
        int index = saveState.getInt("INDEX", 0);
        int xOffset = saveState.getInt("X_OFFSET", 0);
        int yOffset = saveState.getInt("Y_OFFSET", 0);
        this.viewerPosition = new ViewerPosition(index, xOffset, yOffset);
    }

    public ViewerPosition getViewerPosition() {
        return this.viewerPosition;
    }

    public void saveState(SaveState saveState) {
        super.saveState(saveState);
        saveState.putInt("INDEX", this.viewerPosition.getIndexAsInt());
        saveState.putInt("X_OFFSET", this.viewerPosition.getXOffset());
        saveState.putInt("Y_OFFSET", this.viewerPosition.getYOffset());
    }
}

