/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component.margin;

import docking.util.GraphicsUtils;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.listener.IndexMapper;
import docking.widgets.fieldpanel.listener.LayoutModelListener;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.component.margin.DecompilerMarginProvider;
import ghidra.app.decompiler.component.margin.LayoutPixelIndexMap;
import ghidra.program.model.listing.Program;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.math.BigInteger;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class LineNumberDecompilerMarginProvider
extends JPanel
implements DecompilerMarginProvider,
LayoutModelListener {
    private LayoutPixelIndexMap pixmap;
    private LayoutModel model;

    @Override
    public void setProgram(Program program, LayoutModel model, LayoutPixelIndexMap pixmap) {
        this.setLayoutManager(model);
        this.pixmap = pixmap;
        this.repaint();
    }

    private void setLayoutManager(LayoutModel model) {
        if (this.model == model) {
            return;
        }
        if (this.model != null) {
            this.model.removeLayoutModelListener((LayoutModelListener)this);
        }
        this.model = model;
        this.model.addLayoutModelListener((LayoutModelListener)this);
        this.setWidthForLastLine();
        if (this.model != null) {
            this.model.addLayoutModelListener((LayoutModelListener)this);
        }
    }

    @Override
    public void setOptions(DecompileOptions options) {
        this.setFont(options.getDefaultFont());
        this.setWidthForLastLine();
        this.repaint();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public void modelSizeChanged(IndexMapper indexMapper) {
        this.setWidthForLastLine();
        this.repaint();
    }

    public void dataChanged(BigInteger start, BigInteger end) {
        this.repaint();
    }

    private void setWidthForLastLine() {
        if (this.model == null) {
            return;
        }
        int lastLine = this.model.getNumIndexes().intValueExact();
        int width = this.getFontMetrics(this.getFont()).stringWidth(Integer.toString(lastLine));
        this.setPreferredSize(new Dimension(width, 0));
        this.invalidate();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Rectangle visible = this.getVisibleRect();
        BigInteger startIdx = this.pixmap.getIndex(visible.y);
        BigInteger endIdx = this.pixmap.getIndex(visible.y + visible.height);
        int ascent = g.getFontMetrics().getMaxAscent();
        BigInteger i = startIdx;
        while (i.compareTo(endIdx) <= 0) {
            GraphicsUtils.drawString((JComponent)this, (Graphics)g, (String)i.add(BigInteger.ONE).toString(), (int)0, (int)(this.pixmap.getPixel(i) + ascent));
            i = i.add(BigInteger.ONE);
        }
    }
}

