(* (c) Microsoft Corporation 2005-2007.  *)

#light
open System
open System.Resources
open System.Collections

let readResX(f:string) = 
    use rsxr = new ResXResourceReader(f)
    rsxr |> Seq.untyped_to_list 
         |> List.map (fun (d:DictionaryEntry) -> (d.Key :?> string), d.Value)

type resources = (string * obj) list

let writeResources((r:resources),(f:string)) = 
    use writer = new ResourceWriter(f)
    r |> List.iter (fun (k,v) -> writer.AddResource(k,v))

let readResources(f:string) = 
    use r = new ResourceReader(f)
    r |> Seq.untyped_to_list 
      |> List.map (fun (d:DictionaryEntry) -> (d.Key :?> string), d.Value)

let outfile = ref None
let perFile s = 
    if not (Filename.check_suffix (String.lowercase s) ".resx") then (Printf.eprintf "Error: A filename ending with suffix .resx is required as input\n"; exit 1);
    let outfile = match !outfile with None -> Filename.chop_extension(Filename.basename s) ^ ".resources" | Some f -> f in 
    writeResources(readResX(s),outfile)
  
do Arg.parse ["-o", Arg.String (fun s -> outfile := Some s), "Name the output file"; ] perFile "resxc <filename>.resx"


