(* (c) Microsoft Corporation. All rights reserved *)
(*-------------------------------------------------------------------------
 * A fairly simple optimizer.  The main aim is to inline simple, known functions
 * and constant values, and to eliminate non-side-affecting bindings that 
 * are never used.
 *------------------------------------------------------------------------- *)

(*F# 
module Microsoft.FSharp.Compiler.Opt
open Microsoft.FSharp.Compiler 
open Microsoft.Research.AbstractIL 
open Microsoft.Research.AbstractIL.Internal 
F#*)

(* Switches *)
val localopt : unit -> bool 
val abstract_big_targets : bool ref 
val jitopt_user : bool option ref 
val localopt_user : bool option ref 
val crossmoduleopt_user : bool option ref 
val lambda_inline_threshold : int ref 
val jitopt : unit -> bool 
val keep_opt_values : unit -> bool 

(* Optimization information *)
type modul_info
type value_info

val modul_infoL : modul_info -> Layout.layout
val value_infoL : value_info -> Layout.layout
(* Building optimization environments incrementally *)
type env
type cenv
val empty_env : env 
val mk_cenv : Tast.ccu (* scope *) -> Env.tcGlobals -> Import.importMap -> cenv 
val bind_ccu : Tast.ccu -> modul_info -> env -> env 

(* The entry point. Boolean indicates 'incremental extension' in FSI *)
val optimize_assembly : cenv -> env -> bool -> Tast.typedAssembly -> env * Tast.typedAssembly * modul_info
val info_of_struct : value_info -> modul_info 

(* Saving and re-reading optimization information *)
val pmodul_info : modul_info -> Pickle.outstate -> unit 
val umodul_info : Pickle.instate -> modul_info

(* rewrite the modul info using the export remapping *)
val remapModulInfo : Env.tcGlobals -> Tastops.expr_remap -> (modul_info -> modul_info)
val abstractModulInfoToEssentials : (modul_info -> modul_info)