// (c) Microsoft Corporation 2005-2007.

#light

namespace Microsoft.FSharp.Core

open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core.Operators
open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators
open System

/// Simple operations on signed bytes
[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module SByte = 

    let compare (x:int8) y = compare x y

    let zero = 0y
    let one = 1y
    let minus_one = - 1y
    let neg (x:int8) =  - x
    let add (x:int8) (y:int8) = x + y
    let sub (x:int8) (y:int8) = x - y
    let mul (x:int8) (y:int8) = x * y
    let div (x:int8) (y:int8) = x / y
    let rem (x:int8) (y:int8) = x % y
    let succ (x:int8) = x + 1y
    let pred (x:int8) = x - 1y
    let abs (x:int8) = if x < zero then neg x else x
    let max_int = 0x7Fuy
    let min_int = 0x80y
    let logand (x:int8) (y:int8) = x &&& y
    let logor (x:int8) (y:int8) = x ||| y
    let logxor (x:int8) (y:int8) = x ^^^ y
    let lognot (x:int8) = ~~~ x
    let shift_left (x:int8) (n:int) =  x <<< n
    let shift_right (x:int8) (n:int) =  x >>> n
    let of_uint8 (n:byte)   = (# "conv.i1" n : int8 #)
    let to_uint8 (x:int8) = (# "conv.u1" x : byte #)

    let of_byte (n:byte)   = (# "conv.i1" n : int8 #)
    let to_byte (x:int8) = (# "conv.u1" x : byte #)

    let of_int (n:int)   = (# "conv.i1" n : int8 #)
    let to_int (x:int8) = (# "conv.i4" x : int #)

    let of_int16 (n:int16) = (# "conv.i1" n : int8 #)
    let to_int16 (x:int8)  = (# "conv.i2" x : int16 #)

    let of_int32 (n:int32) = (# "conv.i1" n : int8 #)
    let to_int32 (x:int8) = (# "conv.i4" x : int32 #)
