(* (c) Microsoft Corporation. All rights reserved *)

(*----------------------------------------------------------------------------
 * Driver for F# compiler. 
 * 
 * Roughly divides into:
 *    - Parsing
 *    - Flags 
 *    - Importing IL assemblies
 *    - Compiling (including optimizing and managing ccu_thunks)
 *    - Linking (including ILX-IL transformation)
 *--------------------------------------------------------------------------*)

(*F# 
module Microsoft.FSharp.Compiler.CommandLineMain
open Microsoft.FSharp.Compiler
module Fsc = Microsoft.FSharp.Compiler.Driver
module Ast = Microsoft.FSharp.Compiler.Ast

#if CLI_AT_MOST_1_1
#else
open System.Runtime.CompilerServices
[<Dependency("FSharp.Compiler",LoadHint.Always)>] do ()
#endif
F#*)

open Fsc

(*F# let exit (n:int) = System.Environment.Exit(n); failwith "System.Environment.Exit did not exit!" F#*)

let _ = Ast.errorHandler := Fsc.reportError
let _ = Ast.warningHandler := Fsc.reportWarning
let _ = Fsc.exiter_ref := { exit = exit }
let _ = 
    try 
        
         
        
        Fsc.main(); 
        exit 0 
    with e -> Ast.errorRecoveryPoint e; exit 1

