(* (c) Microsoft Corporation 2005-2007.  *)

(*-------------------------------------------------------------------------
 * Generate the hash/compare functions we add to user-defined types by default.
 *------------------------------------------------------------------------- *)

(*F# 
module Microsoft.FSharp.Compiler.Augment 
open Microsoft.Research.AbstractIL 
open Microsoft.Research.AbstractIL.Internal 
open Microsoft.FSharp.Compiler 
module Il = Microsoft.Research.AbstractIL.IL 
F#*) 

open Tast
open Env

val mk_GetHashCode_slotsig : tcGlobals -> tslotsig
val check_augmentation_attribs : tcGlobals -> tycon_spec -> unit
val is_augmented_with_compare : tcGlobals -> tycon_spec -> bool
val is_augmented_with_equals : tcGlobals -> tycon_spec -> bool
val is_augmented_with_hash : tcGlobals -> tycon_spec -> bool

val mk_vspecs_for_hash_augmentation   : tcGlobals -> tycon_ref -> val_spec 
val mk_vspecs_for_compare_augmentation   : tcGlobals -> tycon_ref -> val_spec 
val mk_vspecs_for_equals_augmentation         : tcGlobals -> tycon_ref -> val_spec * val_spec
val mk_bindings_for_hash_augmentation : tcGlobals -> tycon_ref -> tycon_spec -> bind list
val mk_bindings_for_compare_augmentation : tcGlobals -> tycon_ref -> tycon_spec -> bind list
val mk_bindings_for_equals_augmentation       : tcGlobals -> tycon_ref -> tycon_spec -> bind list
