// (c) Microsoft Corporation 2005-2007.  

#light

namespace Microsoft.FSharp.Control

open Microsoft.FSharp.Core
open Microsoft.FSharp.Control
open Microsoft.FSharp.Collections

#nowarn "0057";; // active patterns

[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
/// Delayed computations.
module Lazy = 

    type 'a t = Lazy<'a>

    exception Undefined = Microsoft.FSharp.Control.Undefined

    /// Force the computation of the given lazy value if not already forced.
    /// Raises an exception if the computation raises (or previously raised) an exception.
    /// Raises Undefined if executingg the computation recursively forces the
    /// evaluation of the computation.
    /// Concurrency: This function does not take a lock while forcing execution
    val force: Lazy<'a> -> 'a

    /// Force the computation of the given lazy value if not already forced.
    /// Raises an exception if the computation raises (or previously raised) an exception.
    /// Raises Undefined if executingg the computation recursively forces the
    /// evaluation of the computation.
    /// Concurrency: This function does not take a lock while forcing execution
    val force_val: Lazy<'a> -> 'a

    /// Build a lazy (delayed) value from the given computation
    val lazy_from_fun: (unit -> 'a) -> Lazy<'a>

    /// Build a lazy (delayed) value from the given pre-computed value.
    val lazy_from_val: 'a -> Lazy<'a>

    /// Check if a lazy (delayed) value has already been computed
    val lazy_is_val: Lazy<'a> -> bool

    /// Like force, but this function uses the thunks itselfs as a lock while forcing execution
    /// If you have multiple threads and your lazy values can be 
    /// accessed via multiple threads then you should 
    /// consider using force_with_lock.  If you do not the lazy computations 
    /// may be executed multiple times, and the values produced by some of the 
    /// computations will be discarded. 
    val force_with_lock: Lazy<'a> -> 'a

    /// Equivalent to force
    [<System.Obsolete("This value is obsolete: lazy initialization now always uses mutual exclusion when multiple threads force evaluation of the same lazy thunk")>]
    val force_without_lock: Lazy<'a> -> 'a

    //--------------------------------------------------------------------------
    // Active patterns for working with lazy values

    val (|Lazy|) : 'a lazy -> 'a
