/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.Aborter;
import com.sun.electric.tool.ncc.NccGlobalsReportable;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.NccRandom;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.netlist.NccNetlist;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.result.BenchmarkResults;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import com.sun.electric.tool.ncc.trees.LeafEquivRecords;
import com.sun.electric.tool.user.ncc.NccGuiInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NccGlobals
implements NccGlobalsReportable {
    private static final int CODE_PART = 0;
    private static final int CODE_WIRE = 1;
    private static final int CODE_PORT = 2;
    private NccRandom randGen = new NccRandom();
    private final NccOptions options;
    private final Aborter aborter;
    private EquivRecord root;
    private EquivRecord parts;
    private EquivRecord wires;
    private EquivRecord ports;
    private Cell[] rootCells;
    private VarContext[] rootContexts;
    public int passNumber;
    private LeafEquivRecords partLeafRecs;
    private LeafEquivRecords wireLeafRecs;
    private LeafEquivRecords portLeafRecs;
    private boolean[] cantBuildNetlist;
    private NccGuiInfo nccGuiInfo;
    private BenchmarkResults benchResults = new BenchmarkResults();

    private List getNetObjs(int code, NccNetlist nets) {
        switch (code) {
            case 0: {
                return nets.getPartArray();
            }
            case 1: {
                return nets.getWireArray();
            }
            case 2: {
                return nets.getPortArray();
            }
        }
        this.error("invalid code");
        return null;
    }

    private void countNetObjs(int[] counts, Iterator<EquivRecord> it) {
        while (it.hasNext()) {
            EquivRecord er = it.next();
            this.error(!er.isLeaf(), "Must be leaf");
            int numCkts = er.numCircuits();
            this.error(counts.length != numCkts, "different number of Circuits");
            Iterator<Circuit> it2 = er.getCircuits();
            int i = 0;
            while (i < numCkts) {
                int n = i++;
                counts[n] = counts[n] + it2.next().numNetObjs();
            }
        }
    }

    private int[] getNetObjCounts(LeafEquivRecords leaves) {
        int[] counts = new int[this.getNumNetlistsBeingCompared()];
        this.countNetObjs(counts, leaves.getMatched());
        this.countNetObjs(counts, leaves.getNotMatched());
        return counts;
    }

    private EquivRecord buildEquivRec(int code, List<NccNetlist> nccNets) {
        boolean atLeastOneNetObj = false;
        ArrayList<Circuit> ckts = new ArrayList<Circuit>();
        for (NccNetlist nets : nccNets) {
            List netObjs = this.getNetObjs(code, nets);
            if (netObjs.size() != 0) {
                atLeastOneNetObj = true;
            }
            ckts.add(Circuit.please(netObjs));
        }
        if (!atLeastOneNetObj) {
            return null;
        }
        return EquivRecord.newLeafRecord(code, ckts, this);
    }

    public NccGlobals(NccOptions options, Aborter aborter) {
        this.options = options;
        this.aborter = aborter;
        this.nccGuiInfo = new NccGuiInfo();
    }

    public void prln(String s2) {
        System.out.println(s2);
        System.out.flush();
    }

    public void pr(String s2) {
        System.out.print(s2);
        System.out.flush();
    }

    public void setInitialNetlists(List<NccNetlist> nccNets) {
        this.parts = this.buildEquivRec(0, nccNets);
        this.wires = this.buildEquivRec(1, nccNets);
        this.ports = this.buildEquivRec(2, nccNets);
        ArrayList<EquivRecord> el = new ArrayList<EquivRecord>();
        if (this.parts != null) {
            el.add(this.parts);
        }
        if (this.wires != null) {
            el.add(this.wires);
        }
        if (this.ports != null) {
            el.add(this.ports);
        }
        this.root = EquivRecord.newRootRecord(el);
        this.rootCells = new Cell[nccNets.size()];
        this.rootContexts = new VarContext[nccNets.size()];
        this.cantBuildNetlist = new boolean[nccNets.size()];
        int i = 0;
        for (NccNetlist nl : nccNets) {
            this.rootCells[i] = nl.getRootCell();
            this.rootContexts[i] = nl.getRootContext();
            this.cantBuildNetlist[i] = nl.cantBuildNetlist();
            ++i;
        }
    }

    public void initLeafLists() {
        this.partLeafRecs = new LeafEquivRecords(this.parts, this);
        this.wireLeafRecs = new LeafEquivRecords(this.wires, this);
        this.portLeafRecs = new LeafEquivRecords(this.ports, this);
    }

    public EquivRecord getRoot() {
        return this.root;
    }

    public EquivRecord getParts() {
        return this.parts;
    }

    public EquivRecord getWires() {
        return this.wires;
    }

    public EquivRecord getPorts() {
        return this.ports;
    }

    public int getNumNetlistsBeingCompared() {
        return this.rootCells.length;
    }

    @Override
    public Cell[] getRootCells() {
        return this.rootCells;
    }

    @Override
    public VarContext[] getRootContexts() {
        return this.rootContexts;
    }

    @Override
    public String[] getRootCellNames() {
        String[] rootCellNames = new String[this.rootCells.length];
        for (int i = 0; i < this.rootCells.length; ++i) {
            rootCellNames[i] = NccUtils.fullName(this.rootCells[i]);
        }
        return rootCellNames;
    }

    public void status1(String msg) {
        if (this.options.howMuchStatus >= 1) {
            this.prln(msg);
        }
    }

    public void status2(String msg) {
        if (this.options.howMuchStatus >= 2) {
            this.prln(msg);
        }
    }

    public void flush() {
        System.out.flush();
    }

    public void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    public void error(String msg) {
        Job.error(true, msg);
    }

    @Override
    public NccOptions getOptions() {
        return this.options;
    }

    public int getRandom() {
        return this.randGen.next();
    }

    public LeafEquivRecords getPartLeafEquivRecs() {
        return this.partLeafRecs;
    }

    public LeafEquivRecords getWireLeafEquivRecs() {
        return this.wireLeafRecs;
    }

    public LeafEquivRecords getPortLeafEquivRecs() {
        return this.portLeafRecs;
    }

    @Override
    public HierarchyEnumerator.NetNameProxy[][] getEquivalentNets() {
        int numDes = this.getNumNetlistsBeingCompared();
        HierarchyEnumerator.NetNameProxy[][] equivNets = new HierarchyEnumerator.NetNameProxy[numDes][];
        int numMatched = this.wireLeafRecs.numMatched();
        for (int i = 0; i < numDes; ++i) {
            equivNets[i] = new HierarchyEnumerator.NetNameProxy[numMatched];
        }
        int wireNdx = 0;
        Iterator<EquivRecord> it = this.wireLeafRecs.getMatched();
        while (it.hasNext()) {
            EquivRecord er = it.next();
            int cktNdx = 0;
            Iterator<Circuit> cit = er.getCircuits();
            while (cit.hasNext()) {
                Circuit ckt = cit.next();
                Job.error(ckt.numNetObjs() != 1, "not matched?");
                Wire w = (Wire)ckt.getNetObjs().next();
                equivNets[cktNdx][wireNdx] = w.getNameProxy().getNetNameProxy();
                ++cktNdx;
            }
            ++wireNdx;
        }
        return equivNets;
    }

    @Override
    public HierarchyEnumerator.NodableNameProxy[][] getEquivalentNodes() {
        int numDes = this.getNumNetlistsBeingCompared();
        HierarchyEnumerator.NodableNameProxy[][] equivParts = new HierarchyEnumerator.NodableNameProxy[numDes][];
        int numMatched = this.partLeafRecs.numMatched();
        for (int i = 0; i < numDes; ++i) {
            equivParts[i] = new HierarchyEnumerator.NodableNameProxy[numMatched];
        }
        int partNdx = 0;
        Iterator<EquivRecord> it = this.partLeafRecs.getMatched();
        while (it.hasNext()) {
            EquivRecord er = it.next();
            int cktNdx = 0;
            Iterator<Circuit> cit = er.getCircuits();
            while (cit.hasNext()) {
                Circuit ckt = cit.next();
                Job.error(ckt.numNetObjs() != 1, "not matched?");
                Part p = (Part)ckt.getNetObjs().next();
                equivParts[cktNdx][partNdx] = p.getNameProxy().getNodableNameProxy();
                ++cktNdx;
            }
            ++partNdx;
        }
        return equivParts;
    }

    @Override
    public NccGuiInfo getNccGuiInfo() {
        return this.nccGuiInfo;
    }

    public boolean cantBuildNetlist() {
        for (int i = 0; i < this.cantBuildNetlist.length; ++i) {
            if (!this.cantBuildNetlist[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean[] cantBuildNetlistBits() {
        return this.cantBuildNetlist;
    }

    @Override
    public int[] getPartCounts() {
        return this.getNetObjCounts(this.partLeafRecs);
    }

    @Override
    public int[] getWireCounts() {
        return this.getNetObjCounts(this.wireLeafRecs);
    }

    @Override
    public int[] getPortCounts() {
        return this.getNetObjCounts(this.portLeafRecs);
    }

    public boolean userWantsToAbort() {
        return this.aborter.userWantsToAbort();
    }

    @Override
    public BenchmarkResults getBenchmarkResults() {
        return this.benchResults;
    }
}

