/*
 * Decompiled with CFR 0.152.
 */
package ccl.util;

import ccl.util.FileUtil;
import ccl.util.Util;

public class IniFile {
    public static final int OK = 0;
    public static final int FILE_ERROR = 1;
    public static final int SECTION_ERROR = 2;
    public static final int KEY_ERROR = 3;
    private static int _status = 0;

    private static String _getSection(String sSectionName_, String sIniFileContent_) {
        _status = 0;
        String sIniContent = "\n" + sIniFileContent_;
        int index = sIniContent.indexOf("\n[" + sSectionName_ + "]");
        if (index == -1) {
            _status = 2;
            return "";
        }
        String sSectionContent = sIniFileContent_.substring(index += 3 + sSectionName_.length());
        int indexOfFollowingSection = sSectionContent.indexOf("\n[") + 1;
        if (indexOfFollowingSection == 0) {
            indexOfFollowingSection = sSectionContent.length();
        }
        sSectionContent = sSectionContent.substring(0, indexOfFollowingSection);
        return sSectionContent;
    }

    private static String _getKeyValue(String sKey_, String sSectionContent_) {
        String sSection = "\n" + sSectionContent_;
        int indexStart = sSection.indexOf("\n" + sKey_ + "=");
        if (indexStart == -1) {
            _status = 3;
            return "";
        }
        String sValue = sSection.substring(indexStart += 2 + sKey_.length());
        int indexEnd = sValue.indexOf(10);
        if (indexEnd == -1) {
            indexEnd = sValue.length();
        }
        sValue = sValue.substring(0, indexEnd).trim();
        return sValue;
    }

    public static String getKeyValue(String sIniFullFileName_, String sSectionName_, String sKey_) {
        Util.debug("ccl.util.IniFile.getKeyValue(..).sIniFullFileName_: " + sIniFullFileName_);
        Util.debug("ccl.util.IniFile.getKeyValue(..).sSectionName_:     " + sSectionName_);
        Util.debug("ccl.util.IniFile.getKeyValue(..).sKey_:             " + sKey_);
        String sIniFileContent = "";
        _status = 0;
        try {
            sIniFileContent = FileUtil.readFile(sIniFullFileName_);
        }
        catch (Exception e) {
            Util.debug("ccl.util.IniFile.getKeyValue(..).e: " + e);
            _status = 1;
            return "";
        }
        String sValue = IniFile.getKeyValueFromString(sSectionName_, sKey_, sIniFileContent);
        return sValue;
    }

    public static String getKeyValue(String sIniFullFileName_, String sSectionName_, String sKey_, String sIniFileContent_) {
        _status = 0;
        if (sIniFileContent_ == null) {
            return IniFile.getKeyValue(sIniFullFileName_, sSectionName_, sKey_);
        }
        String sRetVal = IniFile.getKeyValue(sIniFullFileName_, sSectionName_, sKey_);
        if (!Util.isEmpty(sRetVal) || sIniFileContent_ == null) {
            return sRetVal;
        }
        _status = 0;
        String sSectionContent = IniFile._getSection(sSectionName_, sIniFileContent_);
        if (_status != 0) {
            return "";
        }
        String sValue = IniFile._getKeyValue(sKey_, sSectionContent);
        return sValue;
    }

    public static String getKeyValueFromString(String sSectionName_, String sKey_, String sIniFileContent_) {
        _status = 0;
        if (sIniFileContent_ == null) {
            return "";
        }
        String sSectionContent = IniFile._getSection(sSectionName_, sIniFileContent_);
        if (_status != 0) {
            return "";
        }
        String sValue = IniFile._getKeyValue(sKey_, sSectionContent);
        return sValue;
    }

    public static int getStatus() {
        return _status;
    }

    public static void setKeyValue(String sIniFileName_, String sSection_, String sKey_, String sValue_) {
        String sIniFileContent = "";
        _status = 0;
        try {
            sIniFileContent = FileUtil.readFile(sIniFileName_);
        }
        catch (Exception e) {
            sIniFileContent = "[" + sSection_ + "]\n" + sKey_ + "=" + sValue_ + "\n";
        }
        String sCompleteSection = IniFile._getSection(sSection_, sIniFileContent);
        Util.debug("IniFile.setKeyValue(String, String, String, String).sCompleteSection: \n" + sCompleteSection);
        int status = IniFile.getStatus();
        Util.debug("IniFile.setKeyValue(String, String, String, String).status: " + status);
        if (status == 2) {
            sCompleteSection = "\n[" + sSection_ + "]\n" + sKey_ + "=" + sValue_ + "\n";
            sIniFileContent = sIniFileContent + sCompleteSection;
            _status = 0;
        }
        if (sCompleteSection.equals("") || !sCompleteSection.startsWith("\n")) {
            sCompleteSection = "\n" + sCompleteSection;
        }
        Util.debug("IniFile.setKeyValue(String, String, String, String).sIniFileContent: " + sIniFileContent);
        int indexKeyStart = sCompleteSection.indexOf("\n" + sKey_ + "=") + 1;
        Util.debug("IniFile.setKeyValue(String, String, String, String).indexKeyStart, sKey_: " + indexKeyStart + ", " + sKey_);
        Util.debug("IniFile.setKeyValue(String, String, String, String).sCompleteSection: \n" + sCompleteSection);
        int indexKeyStop = sCompleteSection.indexOf("\n", indexKeyStart) + 1;
        String sNewSection = null;
        if (indexKeyStart == 0 || indexKeyStop == -1) {
            Util.debug("IniFile.setKeyValue(..): key does not exist!");
            sNewSection = "\n" + sKey_ + "=" + sValue_ + "\n" + sCompleteSection.substring(1, sCompleteSection.length());
        } else {
            sNewSection = sCompleteSection.substring(0, indexKeyStart) + sKey_ + "=" + sValue_ + "\n" + sCompleteSection.substring(indexKeyStop, sCompleteSection.length());
        }
        int indexSectionStart = sIniFileContent.indexOf(sCompleteSection);
        String sNewIniFileContent = sIniFileContent.substring(0, indexSectionStart) + sNewSection + sIniFileContent.substring(indexSectionStart + sCompleteSection.length(), sIniFileContent.length());
        try {
            FileUtil.writeFile(sIniFileName_, sNewIniFileContent);
        }
        catch (Exception e) {
            _status = 1;
            return;
        }
    }
}

