/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.swing.AutoGridBagLayout;
import ccl.swing.SwingUtil;
import ccl.util.Util;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ListToListPanel
extends JPanel
implements ActionListener {
    private static final int STANDARD_LINES = 15;
    private static final int STANDARD_WIDTH = 200;
    private Vector _vLeftSide;
    private Vector _vRightSide;
    private JList _lstLeft;
    private JList _lstRight;
    private JButton _btnSelect = new JButton("Select ->");
    private JButton _btnDeselect = new JButton("<- Deselect");
    private JButton _btnSelectAll = new JButton("Select All =>");
    private JButton _btnDeselectAll = new JButton("<= Deselect All");

    private void _updateLists() {
        SwingUtil.setList(this._lstLeft, Util.sort(this._vLeftSide));
        SwingUtil.setList(this._lstRight, Util.sort(this._vRightSide));
    }

    public ListToListPanel(String sLeftMessage_, String sRightMessage_, int insets_) {
        this(sLeftMessage_, sRightMessage_, new Vector(), new Vector(), insets_);
    }

    public ListToListPanel(String sLeftMessage_, String sRightMessage_, Vector vLeftSide_, Vector vRightSide_, int insets_) {
        Util.panicIf(vLeftSide_ == null || vRightSide_ == null);
        this._vLeftSide = (Vector)vLeftSide_.clone();
        this._vRightSide = (Vector)vRightSide_.clone();
        AutoGridBagLayout pAutoGridBagLayout = new AutoGridBagLayout();
        pAutoGridBagLayout.setInsets(insets_);
        this.setLayout(pAutoGridBagLayout);
        this._lstLeft = new JList(new DefaultListModel());
        this._lstRight = new JList(new DefaultListModel());
        this._lstLeft.setSelectionMode(2);
        this._lstRight.setSelectionMode(2);
        pAutoGridBagLayout.setFillNone();
        pAutoGridBagLayout.setAnchor(17);
        this.add(new JLabel(sLeftMessage_));
        this.add(new JLabel(" "));
        this.add(new JLabel(" "));
        this.add(new JLabel(" "));
        this.add(new JLabel(sRightMessage_));
        pAutoGridBagLayout.endLine();
        JScrollPane scpLeft = new JScrollPane(this._lstLeft);
        scpLeft.setBorder(SwingUtil.createCCLBorder());
        pAutoGridBagLayout.setExpandBoth();
        pAutoGridBagLayout.setFillBoth();
        pAutoGridBagLayout.setExtend(1, 7);
        this.add(scpLeft);
        pAutoGridBagLayout.setExtend(1, 1);
        pAutoGridBagLayout.setFillNone();
        pAutoGridBagLayout.setExpandNone();
        this.add(new JLabel(" "));
        pAutoGridBagLayout.setFillHorizontal();
        pAutoGridBagLayout.setExpandVertical();
        this.add(new JLabel(" "));
        pAutoGridBagLayout.setExpandNone();
        pAutoGridBagLayout.nextLine();
        this.add(this._btnSelect);
        pAutoGridBagLayout.nextLine();
        this.add(this._btnDeselect);
        pAutoGridBagLayout.nextLine();
        this.add(new JLabel(" "));
        pAutoGridBagLayout.nextLine();
        this.add(this._btnSelectAll);
        pAutoGridBagLayout.nextLine();
        this.add(this._btnDeselectAll);
        pAutoGridBagLayout.nextLine();
        pAutoGridBagLayout.setFillHorizontal();
        pAutoGridBagLayout.setExpandVertical(2.0);
        this.add(new JLabel(" "));
        pAutoGridBagLayout.setExpandNone();
        pAutoGridBagLayout.gotoGrid(3, 1);
        pAutoGridBagLayout.setFillNone();
        pAutoGridBagLayout.setExpandNone();
        this.add(new JLabel(" "));
        JScrollPane scpRight = new JScrollPane(this._lstRight);
        scpRight.setBorder(SwingUtil.createCCLBorder());
        pAutoGridBagLayout.setExpandBoth();
        pAutoGridBagLayout.setFillBoth();
        pAutoGridBagLayout.setExtend(1, 7);
        this.add(scpRight);
        pAutoGridBagLayout.setExtend(1, 1);
        SwingUtil.setList(this._lstLeft, Util.sort(this._vLeftSide));
        SwingUtil.setList(this._lstRight, Util.sort(this._vRightSide));
        this._btnSelect.addActionListener(this);
        this._btnSelectAll.addActionListener(this);
        this._btnDeselect.addActionListener(this);
        this._btnDeselectAll.addActionListener(this);
    }

    public void actionPerformed(ActionEvent pActionEvent_) {
        Object oSource = pActionEvent_.getSource();
        if (oSource == this._btnSelectAll) {
            this._vRightSide = Util.concat(this._vRightSide, this._vLeftSide);
            this._vLeftSide = new Vector();
            this._updateLists();
        } else if (oSource == this._btnDeselectAll) {
            this._vLeftSide = Util.concat(this._vLeftSide, this._vRightSide);
            this._vRightSide = new Vector();
            this._updateLists();
        } else if (oSource == this._btnSelect) {
            Vector vSelected = Util.objectsToVector(this._lstLeft.getSelectedValues());
            this._vRightSide = Util.concat(this._vRightSide, vSelected);
            this._vLeftSide = Util.subtract(this._vLeftSide, vSelected);
            this._updateLists();
        } else if (oSource == this._btnDeselect) {
            Vector vSelected = Util.objectsToVector(this._lstRight.getSelectedValues());
            this._vLeftSide = Util.concat(this._vLeftSide, vSelected);
            this._vRightSide = Util.subtract(this._vRightSide, vSelected);
            this._updateLists();
        }
    }

    public synchronized void removeAll() {
        this._vLeftSide = new Vector();
        this._vRightSide = new Vector();
        this._updateLists();
    }

    public synchronized void add(Vector vLeft_, Vector vRight_) {
        this._vLeftSide = Util.concat(this._vLeftSide, vLeft_);
        this._vRightSide = Util.concat(this._vRightSide, vRight_);
        this._updateLists();
    }

    public synchronized Vector getLeft() {
        return (Vector)this._vLeftSide.clone();
    }

    public synchronized Vector getRight() {
        return (Vector)this._vRightSide.clone();
    }
}

