/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.IHashEq;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.Murmur3;
import clojure.lang.Named;
import clojure.lang.RT;
import clojure.lang.Util;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class Symbol
extends AFn
implements IObj,
Comparable,
Named,
Serializable,
IHashEq {
    final String ns;
    final String name;
    private int _hasheq;
    final IPersistentMap _meta;
    String _str;

    public String toString() {
        if (this._str == null) {
            this._str = this.ns != null ? (this.ns + "/" + this.name).intern() : this.name;
        }
        return this._str;
    }

    @Override
    public String getNamespace() {
        return this.ns;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static Symbol create(String ns, String name) {
        return Symbol.intern(ns, name);
    }

    public static Symbol create(String nsname) {
        return Symbol.intern(nsname);
    }

    public static Symbol intern(String ns, String name) {
        return new Symbol(ns == null ? null : ns.intern(), name.intern());
    }

    public static Symbol intern(String nsname) {
        int i = nsname.indexOf(47);
        if (i == -1 || nsname.equals("/")) {
            return new Symbol(null, nsname.intern());
        }
        return new Symbol(nsname.substring(0, i).intern(), nsname.substring(i + 1).intern());
    }

    private Symbol(String ns_interned, String name_interned) {
        this.name = name_interned;
        this.ns = ns_interned;
        this._meta = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Symbol)) {
            return false;
        }
        Symbol symbol = (Symbol)o;
        return this.name == symbol.name && this.ns == symbol.ns;
    }

    public int hashCode() {
        return Util.hashCombine(this.name.hashCode(), Util.hash(this.ns));
    }

    @Override
    public int hasheq() {
        if (this._hasheq == 0) {
            this._hasheq = Util.hashCombine(Murmur3.hashUnencodedChars(this.name), Util.hash(this.ns));
        }
        return this._hasheq;
    }

    @Override
    public IObj withMeta(IPersistentMap meta) {
        return new Symbol(meta, this.ns, this.name);
    }

    private Symbol(IPersistentMap meta, String ns, String name) {
        this.name = name;
        this.ns = ns;
        this._meta = meta;
    }

    public int compareTo(Object o) {
        Symbol s = (Symbol)o;
        if (this.equals(o)) {
            return 0;
        }
        if (this.ns == null && s.ns != null) {
            return -1;
        }
        if (this.ns != null) {
            if (s.ns == null) {
                return 1;
            }
            int nsc = this.ns.compareTo(s.ns);
            if (nsc != 0) {
                return nsc;
            }
        }
        return this.name.compareTo(s.name);
    }

    private Object readResolve() throws ObjectStreamException {
        return Symbol.intern(this.ns, this.name);
    }

    @Override
    public Object invoke(Object obj) {
        return RT.get(obj, this);
    }

    @Override
    public Object invoke(Object obj, Object notFound) {
        return RT.get(obj, this, notFound);
    }

    @Override
    public IPersistentMap meta() {
        return this._meta;
    }
}

