create table AppUser
(
    name 	     VARCHAR(32) NOT NULL
   ,password 	  VARCHAR(16)  NOT NULL
   ,description  VARCHAR(255) NOT NULL
   ,admin        INT         NOT NULL      -- BOOLEAN
)
;

create table Account
(
    id             INT          NOT NULL
   ,name           VARCHAR(48)  NOT NULL
   ,description    VARCHAR(255) NOT NULL
   ,currency_iso   CHAR(3)      NOT NULL
   ,type           CHAR(7)      NOT NULL
   ,parent         INT          NULL
   ,tax_percentage DOUBLE PRECISION      NOT NULL
   ,tax_deductible INT          NOT NULL   -- BOOLEAN
)
;
create index account_idx on Account( id );

create table tblTransaction
(
    transaction_id          INT          NOT NULL
   ,account_id              INT          NOT NULL
   ,double_entry_account_id INT          NOT NULL
   ,payment                 DOUBLE PRECISION       NOT NULL
   ,deposit                 DOUBLE PRECISION       NOT NULL
   ,double_entry_payment    DOUBLE PRECISION       NOT NULL
   ,double_entry_deposit    DOUBLE PRECISION       NOT NULL
   ,exchange_rate           DOUBLE PRECISION       NOT NULL
   ,transaction_date        DATETIME         NOT NULL   -- format "yyyy-mm-dd" NOT NULL
   ,payee                   VARCHAR(255) NOT NULL
   ,description             VARCHAR(255) NOT NULL
   ,tax_percentage          DOUBLE PRECISION       NOT NULL
   ,tax_deductible          INT          NOT NULL   -- BOOLEAN
)
;

create table tblPosition
(
    account_id                INT          NOT NULL
   ,security_id               INT          NOT NULL
   ,quantity                  NUMERIC(12,0)         NOT NULL
   ,absolut_amount            DOUBLE PRECISION       NOT NULL
   ,abs_avg_share_price       DOUBLE PRECISION       NOT NULL
   ,commission                DOUBLE PRECISION       NOT NULL
   ,amount                    DOUBLE PRECISION       NOT NULL
   ,avg_share_price           DOUBLE PRECISION       NOT NULL
)
;

create table Movement
(
    transaction_id          INT          NOT NULL
   ,security_id             INT          NOT NULL
   ,valuta                  DATETIME         NOT NULL   -- format "yyyy-mm-dd" NOT NULL
   ,quantity                NUMERIC(12,0)         NOT NULL
   ,share_price             DOUBLE PRECISION       NOT NULL
   ,commission              DOUBLE PRECISION       NOT NULL
)
;

create table Security
(
    id                      INT          NOT NULL
   ,name                    VARCHAR(255) NOT NULL
   ,wkn                     CHAR(9)      NOT NULL
   ,valor                   CHAR(9)      NOT NULL
   ,ticker                  CHAR(6)      NOT NULL
   ,stock_exchange          CHAR(32)     NOT NULL
);

--  ganymed stuff
create table SchweizerEinkommen
(
   id      INT      NOT NULL
  ,jahr    INT      NOT NULL
  ,monat   INT      NOT NULL
  ,stunden       DOUBLE PRECISION   NOT NULL
  ,stundensatz   DOUBLE PRECISION   NOT NULL
  ,umsatz        DOUBLE PRECISION   NOT NULL
  ,spesen        DOUBLE PRECISION   NOT NULL
  ,bvg           DOUBLE PRECISION   NOT NULL
  ,brutto        DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_ahv_prozent   DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_ahv_basis     DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_ahv_betrag     DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_alv1_prozent   DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_alv1_basis     DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_alv1_betrag    DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_alv2_prozent   DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_alv2_basis     DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_alv2_betrag    DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_fak_prozent   DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_fak_basis     DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_fak_betrag    DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_verwalt_prozent   DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_verwalt_basis     DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_verwalt_betrag    DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_bu_prozent   DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_bu_basis     DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_bu_betrag    DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_ergnbu_prozent   DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_ergnbu_basis     DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_ergnbu_betrag    DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_ergnbu1_prozent   DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_ergnbu1_basis     DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_ergnbu1_betrag    DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_ergnbu2_prozent   DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_ergnbu2_basis     DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_ergnbu2_betrag    DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_ergnbu3_prozent   DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_ergnbu3_basis     DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_ergnbu3_betrag    DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_kktg_prozent   DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_kktg_basis     DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_kktg_betrag    DOUBLE PRECISION   NOT NULL
  ,arbeitgeber_total          DOUBLE PRECISION   NOT NULL
  ,nettolohn                  DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_ahv_prozent   DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_ahv_basis     DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_ahv_betrag     DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_alv1_prozent   DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_alv1_basis     DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_alv1_betrag    DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_alv2_prozent   DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_alv2_basis     DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_alv2_betrag    DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_nbu_prozent   DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_nbu_basis     DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_nbu_betrag    DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_ergnbu_prozent   DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_ergnbu_basis     DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_ergnbu_betrag    DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_ergnbu1_prozent   DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_ergnbu1_basis     DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_ergnbu1_betrag    DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_ergnbu2_prozent   DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_ergnbu2_basis     DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_ergnbu2_betrag    DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_ergnbu3_prozent   DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_ergnbu3_basis     DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_ergnbu3_betrag    DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_kktg_prozent   DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_kktg_basis     DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_kktg_betrag    DOUBLE PRECISION   NOT NULL
  ,quellensteuer_prozent   DOUBLE PRECISION   NOT NULL
  ,quellensteuer_basis     DOUBLE PRECISION   NOT NULL
  ,quellensteuer_betrag    DOUBLE PRECISION   NOT NULL
  ,arbeitnehmer_total          DOUBLE PRECISION   NOT NULL
  ,nettogehalt                 DOUBLE PRECISION   NOT NULL
  ,auszahlung                  DOUBLE PRECISION   NOT NULL
)
;

create table ExchangeRate
(
   id            INT       NOT NULL
  ,convert_from  CHAR(3)   NOT NULL
  ,convert_to    CHAR(3)   NOT NULL
  ,rate          DOUBLE PRECISION    NOT NULL
  ,updated       DATETIME  NOT NULL
)
;

create table DepotValue
(
   id            INT       NOT NULL
  ,currency_iso  CHAR(3)   NOT NULL
  ,value         DOUBLE PRECISION    NOT NULL
  ,updated       DATETIME  NOT NULL
)
;

create table Balance
(
   period           DATETIME            NOT NULL
  ,monthly_amount   DOUBLE PRECISION    NOT NULL
  ,total_amount     DOUBLE PRECISION    NOT NULL
)
;

create table Company
(
   id            INT       NOT NULL
  ,security_id   INT       NOT NULL
  ,shares_outstanding   NUMERIC(12,0)   NOT NULL
  ,dividend      DOUBLE PRECISION   NOT NULL
)
;

create table Price
(
   id            INT       NOT NULL
  ,security_id   INT       NOT NULL
  ,value         DOUBLE PRECISION   NOT NULL
  ,updated       DATETIME   NOT NULL
)
;
