//
//  JCF Java Class File Manipulation Package (package lti.java.jcf)
//  Copyright (c) 1997 Matt T. Yourst. All rights reserved.
//
//  Version:  1.00.174
//  Date:     January through May 1997
//  Author:   Matt Yourst [yourst@laserstars.com]
//  Language: Java 1.1+
//

package lti.java.jcf;

import java.io.*;

/**
 * The attribute "Code". Includes symbolic information, JVM bytecode, and exceptions.
 */
public class JcfCodeAttribute extends JcfAttribute
{
  public short catMaxStack;
  public short catMaxLocals;
  public byte catCode[];
  public JcfExceptionTable catExceptionTable;
  /** "Code" attributes may contain nested "LineNumberTable" and other attributes. */
  public JcfAttributeCollection catExtraAttributes;
  
  public JcfCodeAttribute (JcfClassInput ist, short nameIndex,
    JcfConstantPool p) throws IOException, ClassFormatError
    { super(ist, nameIndex, p); }
    
  /** Reads header data, then calls readCode to read in the bytecode. */
  public void readData (JcfClassInput ist)
    throws IOException, ClassFormatError
  {
    catMaxStack = ist.readShort();
    catMaxLocals = ist.readShort();
    catCode = new byte[ist.readInt()];
    readCode(ist);
    catExceptionTable = new JcfExceptionTable(ist, this);
    catExtraAttributes = constPool.getClassFile().readAttributes(ist);
  }
  
  /**
   * In order to calculate the correct updated atrLength field, creates a new
   * ByteArrayOutputStream to buffer the Code attribute specific data and any
   * subattributes. Then, the superclass write() is called.
   *
   * @revision 1997-11-27 "atrLength = atrData.length" line added to prevent
   *                      Netscape verifier from complaining about incorrect
   *                      code segment lengths.
   */
  public void write (JcfClassOutput ost) throws IOException
  {
    ByteArrayOutputStream bost = new ByteArrayOutputStream(512);
    JcfClassOutputStream jost = new JcfClassOutputStream(bost);
    jost.writeShort(catMaxStack);
    jost.writeShort(catMaxLocals);
    jost.writeInt(catCode.length);
    writeCode(jost);
    catExceptionTable.write(jost);
    catExtraAttributes.write(jost);
    atrData = bost.toByteArray();
    atrLength = atrData.length;
    super.write(ost);
  }

  public void writeCode (JcfClassOutput ost) throws IOException,
    ClassFormatError
  {
    ost.write(catCode);
  }

  public void readCode (JcfClassInput ist) throws IOException,
    ClassFormatError
  {
    ist.readFully(catCode);
  }
}
