/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import ccl.util.*;

/**
 * Dialog which shows currently running threads.
 *
 * @version  $Id: ThreadsDialog.java,v 1.8 2003/05/01 16:44:29 clemens Exp clemens $
 * @author   <a href="http://www.kclee.com/clemens/">
 *           Chr. Clemens Lee</a>
 *           &lt;<a href="mailto:clemens@kclee.com">
 *           clemens@kclee.com
 *           </a>>
 */
public class ThreadsDialog extends ExitJFrame
                           implements Runnable,
                                      ActionListener,
                                      ItemListener
{
    private static final String S_DEPTH = "   ";
    private JComboBox _jcbInterval = new JComboBox();
    private JButton _btnUpdate = new JButton("  Update Now  ");
    private JButton _btnOK = new JButton("OK");
    private int _updateInterval;
    private Thread _pThread;
    private boolean _bExit = false;

    private JTextArea _txtThreads;
    private JScrollPane _jspThreads;

    private String _sThreadOutput = "";

    private ThreadGroup _getRootThreadGroup() 
    {
        ThreadGroup _tgrRoot = Thread.currentThread().getThreadGroup();
        ThreadGroup _tgrNext = _tgrRoot;
        while (_tgrNext != null) 
        {
            _tgrRoot = _tgrNext;
            _tgrNext = _tgrNext.getParent();
        }
        
        return _tgrRoot;
    }
    
    private void _insertChildren(ThreadGroup pThreadGroup_, String sDepth_)
    {
        Thread athrChildren[] = new Thread[pThreadGroup_.activeCount()];
        pThreadGroup_.enumerate(athrChildren, false);
        for (int index = 0; index < athrChildren.length; index++) 
        {
            Thread thrChild = athrChildren[index];
            if (thrChild == null) 
            {
                break;
            }
            _sThreadOutput += sDepth_ + athrChildren[index].toString() + "\n";
        }
        
        ThreadGroup atgrChildren[] = new ThreadGroup
               [pThreadGroup_.activeGroupCount()];
        pThreadGroup_.enumerate(atgrChildren);
        for (int index = 0; index < atgrChildren.length; index++) 
        {
            ThreadGroup tgrChild = atgrChildren[index];
            if (tgrChild == null) 
            {
                break;
            }
            _sThreadOutput += sDepth_ + tgrChild.toString().substring(10) + "\n";
            
            _insertChildren(tgrChild, sDepth_ += S_DEPTH);
        }
    }

    private void _updateValues() 
    {
        ThreadGroup tgrRoot = _getRootThreadGroup();
        
        _sThreadOutput = tgrRoot.toString().substring(10) + "\n";
        
        _insertChildren(tgrRoot, S_DEPTH);
        
        _txtThreads.setText(_sThreadOutput);
    }
    
    /*public Insets getInsets() {
      Insets insRetVal = super.getInsets();
      insRetVal.top += 3;
      insRetVal.bottom += 1;
      insRetVal.left += 3;
      insRetVal.right += 3;
      
      return insRetVal;
      }*/
    
    public ThreadsDialog() 
    {
        this(new Frame());
    }
    
    public ThreadsDialog(Frame frmParent_) 
    {
        super("Threads");
        setBackground(frmParent_.getBackground());
        AutoGridBagLayout agblMemory = new AutoGridBagLayout();
        agblMemory.setInsets(3);
        JPanel pnlMain = new JPanel();
        pnlMain.setLayout(agblMemory);
        getContentPane().setLayout(new BorderLayout());
        
        // List line ---------------------------------------------
        _txtThreads = new JTextArea();
        _txtThreads.setFont(new Font("Dialog", Font.BOLD, 12));
        _jspThreads = new JScrollPane(_txtThreads);
        _jspThreads.setBorder(new CCLBorder());
        _jspThreads.setPreferredSize(new Dimension(300, 300));
        agblMemory.setExpandBoth();
        agblMemory.setFillBoth();
        agblMemory.setExtend(4, 1);
        pnlMain.add(_jspThreads);
        agblMemory.setExtend(1, 1);
        agblMemory.setFillNone();
        agblMemory.setExpandNone();
        
        agblMemory.endLine();
        
        // update line -------------------------------------------
        agblMemory.setAnchor(GridBagConstraints.EAST);
        pnlMain.add(new JLabel("Update every "));
        
        _jcbInterval.addItem("1");
        _jcbInterval.addItem("2");
        _jcbInterval.addItem("3");
        _jcbInterval.addItem("4");
        _jcbInterval.addItem("5");
        _jcbInterval.addItem("10");
        _jcbInterval.addItem("20");
        _jcbInterval.addItem("30");
        _jcbInterval.addItem("60");
        _jcbInterval.addItem("300  ");
        _updateInterval = 10;
        _jcbInterval.setSelectedItem(Util.itoa(_updateInterval));
        _jcbInterval.addItemListener(this);
        
        agblMemory.setAnchor(GridBagConstraints.CENTER);
        pnlMain.add(_jcbInterval);
        
        agblMemory.setAnchor(GridBagConstraints.WEST);
        pnlMain.add(new JLabel(" seconds. "));
        
        _btnUpdate.addActionListener(this);
        agblMemory.setFillHorizontal();
        pnlMain.add(_btnUpdate);
        agblMemory.setFillNone();
        
        agblMemory.endLine();
        
        // OK line --------------------------------------------
        _btnOK.setFont(new Font("Dialog", Font.BOLD, 12));
        _btnOK.addActionListener(this);
        agblMemory.setAnchor(GridBagConstraints.CENTER);
        agblMemory.setExtend(4, 1);
        pnlMain.add(_btnOK);
        agblMemory.setExtend(1, 1);
        agblMemory.endLine();
                
        pnlMain.setBorder(BorderFactory.createEmptyBorder(3, 3, 1, 3));
        getContentPane().add(pnlMain, BorderLayout.CENTER);
        
        pack();
        setSize(getPreferredSize());
        SwingUtil.centerComponent(this);
        show();
        _pThread = new Thread(this);
        _pThread.start();
    }

    public void actionPerformed(ActionEvent pActionEvent_) 
    {
        Object oSource = pActionEvent_.getSource();
        if (oSource == _btnOK) 
        {
            setExit();
        }
        else if (oSource == _btnUpdate) 
        {
            _pThread.interrupt();
        }
    }
    
    public void itemStateChanged(ItemEvent pItemEvent_) 
    {
        _updateInterval = Util.atoi(_jcbInterval.getSelectedItem().toString());
        _pThread.interrupt();
    }
    
    public void run() 
    {
        while(_pThread != null) 
        {
            if (_bExit) 
            {
                _pThread = null;
                exit();
            }
            
            _updateValues();
            repaint();
            
            try 
            {
                _pThread.sleep(_updateInterval * 1000);
            }
            catch (InterruptedException e) 
            {
            }
        }
    }

    public void setExit() 
    {
        _bExit = true;
        _pThread.interrupt();
    }
}
