/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import ccl.util.Util;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import javax.swing.JPanel;

/**
 * Animation panel. Nowadays swing is able to handle animated
 * gifs, so consider this a legacy class.
 *
 * @deprecated
 * @version $Id: AnimationPanel.java,v 1.7 2002/10/06 16:41:25 clemens Exp clemens $
 * @author <a href="http://www.kclee.com/clemens/">
 *         Chr. Clemens Lee</a>
 *         &lt;<a href="mailto:clemens@kclee.com">
 *         clemens@kclee.com
 *         </a>>
 */
public class AnimationPanel extends JPanel
                            implements Runnable,
                                       ImageObserver
{
    /** This consists of n images (same width and height) in one row */
    private Image _imArray = null;
    private String _sImage = null;

    private int _size = -1;
    private int _images = 0;
    private int _nextImage = 0;
    private long _lSleep = 1000;
    private Thread _pThread = null;

    private boolean _bStop = false;

    public AnimationPanel(String sFileName_) 
    {
        this(sFileName_, 1000);
    }

    public AnimationPanel(String sFileName_, long lSleep_) 
    {
        this( Toolkit.getDefaultToolkit().
              getImage( sFileName_ ), 
              lSleep_ );
    }

    public AnimationPanel( Image image_, long lSleep_ ) 
    {
        super();

        _bStop = false;
        _lSleep = lSleep_;
        _imArray = image_;
        _waitWhileImageIsLoading(_imArray);
        if (_imArray != null) 
        {
            int width = _imArray.getWidth(this);
            int height = _imArray.getHeight(this);
            _size = Math.min(width, height);
            int max = Math.max(width, height);
            if (_size != 0) 
            {
                _images = max / _size;
            }
        }
    }

    private synchronized void _waitWhileImageIsLoading(Image pImage_) 
    {
        while( pImage_.getWidth(this) == -1 
               && pImage_.getHeight(this) == -1 )
        {
            try 
            {
                wait();
            }
            catch (InterruptedException e) 
            { 
            }
        }
    }

    public void update(Graphics pGraphics_) 
    {
        if (_size > 0 && _images > 0) 
        {
            pGraphics_.clipRect(0, 0, _size, _size);
            pGraphics_.drawImage(_imArray, -(_nextImage * _size), 0, this);
        }
    }

    public void paint(Graphics pGraphics_) 
    {
        Util.debug("AnimationPanel.paint(..)");
        update(pGraphics_);
    }

    public synchronized boolean imageUpdate(Image pImage_, int flags_,
                                            int x_, int y_, int w_, int h_)
    {
        notifyAll();

        return true;
    }

    public void run() 
    {
        _bStop = false;

        Thread.currentThread().setPriority(Thread.MAX_PRIORITY);

        if (_imArray != null) 
        {
            Util.debug("AnimationPanel.<init>._size: " + _size);
            Util.debug("AnimationPanel.<init>._images: " + _images);

            while ( _bStop == false 
                    && _pThread != null )
            {
                repaint();
                try 
                {
                    Thread.sleep(_lSleep);
                }
                catch (InterruptedException e) 
                {
                }
                _nextImage++;
                if (_nextImage == _images) 
                {
                    _nextImage = 0;
                }
            }
        }
    }

    public void start() 
    {
        if (_pThread == null ) 
        {
            _pThread = new Thread(this);
            _pThread.start();
        }
    }

    public Dimension getPreferredSize() 
    {
        return getMinimumSize();
    }

    public Dimension getMinimumSize() 
    {
        return new Dimension(Math.max(_size, 32), Math.max(_size, 32));
    }

    public void stop() 
    {
        if (_pThread != null && _pThread.isAlive())
        {
            _bStop = true;
            _pThread.interrupt();
        }
        _pThread = null;
    }
}

