/*
 * Decompiled with CFR 0.152.
 */
package lti.java.jcf;

import java.io.IOException;
import java.util.Vector;
import lti.java.jcf.CptClass;
import lti.java.jcf.CptDouble;
import lti.java.jcf.CptField;
import lti.java.jcf.CptFloat;
import lti.java.jcf.CptGeneric;
import lti.java.jcf.CptInteger;
import lti.java.jcf.CptInterface;
import lti.java.jcf.CptLong;
import lti.java.jcf.CptMemberOrInterface;
import lti.java.jcf.CptMethod;
import lti.java.jcf.CptNameType;
import lti.java.jcf.CptString;
import lti.java.jcf.CptUTF;
import lti.java.jcf.CptUnicode;
import lti.java.jcf.JcfClassFile;
import lti.java.jcf.JcfClassInput;
import lti.java.jcf.JcfClassOutput;
import lti.java.jcf.RuntimeConstants;

public class JcfConstantPool
extends Vector
implements RuntimeConstants {
    protected JcfClassFile parent;

    public final JcfClassFile getClassFile() {
        return this.parent;
    }

    public int readConstant(JcfClassInput st, byte tag) throws IOException, ClassFormatError {
        int extra = 0;
        switch (tag) {
            case 1: {
                this.addConstant(new CptUTF(st, this, this.size()));
                break;
            }
            case 12: {
                this.addConstant(new CptNameType(st, this, this.size()));
                break;
            }
            case 7: {
                this.addConstant(new CptClass(st, this, this.size()));
                break;
            }
            case 10: {
                this.addConstant(new CptMethod(st, this, this.size()));
                break;
            }
            case 9: {
                this.addConstant(new CptField(st, this, this.size()));
                break;
            }
            case 8: {
                this.addConstant(new CptString(st, this, this.size()));
                break;
            }
            case 3: {
                this.addConstant(new CptInteger(st, this, this.size()));
                break;
            }
            case 4: {
                this.addConstant(new CptFloat(st, this, this.size()));
                break;
            }
            case 5: {
                this.addConstant(new CptLong(st, this, this.size()));
                this.addElement(null);
                ++extra;
                break;
            }
            case 6: {
                this.addConstant(new CptDouble(st, this, this.size()));
                this.addElement(null);
                ++extra;
                break;
            }
            case 2: {
                this.addConstant(new CptUnicode(st, this, this.size()));
                break;
            }
            case 11: {
                this.addConstant(new CptInterface(st, this, this.size()));
                break;
            }
            default: {
                throw new ClassFormatError("Unrecognized constant pool tag: " + tag);
            }
        }
        return extra;
    }

    public void read(JcfClassInput ist) throws ClassFormatError, IOException {
        int constCount = ist.readShort();
        this.ensureCapacity(constCount);
        this.addElement(null);
        int i = 1;
        while (i < constCount) {
            byte tag = ist.readByte();
            i += this.readConstant(ist, tag);
            ++i;
        }
    }

    public JcfConstantPool(JcfClassInput ist, JcfClassFile p) throws ClassFormatError, IOException {
        super(256, 256);
        this.parent = p;
        this.read(ist);
    }

    public JcfConstantPool(JcfClassFile p, int initialCapacity, int capacityIncrement) {
        super(initialCapacity, capacityIncrement);
        this.parent = p;
        this.addElement(null);
    }

    public JcfConstantPool(JcfClassFile p, int initialCapacity) {
        this(p, initialCapacity, 256);
    }

    public JcfConstantPool(JcfClassFile p) {
        this(p, 256, 256);
    }

    public void addConstant(CptGeneric constant) {
        this.addElement(constant);
    }

    public CptGeneric constantAt(int index) throws ArrayIndexOutOfBoundsException {
        if (index == 0) {
            throw new ArrayIndexOutOfBoundsException(0);
        }
        return (CptGeneric)this.elementAt(index);
    }

    public void insertConstantAt(CptGeneric constant, int index) {
        this.insertElementAt(constant, index);
    }

    public void write(JcfClassOutput ost) throws IOException {
        int count = this.size();
        ost.writeShort(count);
        int i = 1;
        while (i < count) {
            CptGeneric constant = this.constantAt(i);
            if (constant != null) {
                this.writeConstant(ost, constant, i);
            }
            ++i;
        }
    }

    public void writeConstant(JcfClassOutput ost, CptGeneric constant, int index) throws IOException {
        ost.writeByte(constant.getTag());
        constant.write(ost);
    }

    public final String utfAt(int index) {
        return ((CptUTF)this.elementAt((int)index)).value;
    }

    public final String classNameAt(int index) {
        return this.utfAt(((CptClass)this.elementAt((int)index)).nameIndex);
    }

    public final String stringTextAt(int index) {
        return this.utfAt(((CptString)this.elementAt((int)index)).StringIndex);
    }

    public final String memberClassNameAt(int index) {
        return this.classNameAt(((CptMemberOrInterface)this.elementAt((int)index)).classIndex);
    }

    public final String memberNameAt(int index) {
        return this.utfAt(((CptNameType)this.elementAt((int)((CptMemberOrInterface)this.elementAt((int)index)).nameTypeIndex)).nameIndex);
    }

    public final String memberSignatureAt(int index) {
        return this.utfAt(((CptNameType)this.elementAt((int)((CptMemberOrInterface)this.elementAt((int)index)).nameTypeIndex)).signatureIndex);
    }
}

