/*
 * Decompiled with CFR 0.152.
 */
package ccl.util;

import ccl.util.Util;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class DBUtil {
    public static final DBConstant INSTANTDB = new DBConstant();
    public static final DBConstant SYBASE = new DBConstant();
    public static final DBConstant POSTGRESQL = new DBConstant();
    private static boolean _bInitialized = false;
    private static DBConstant _database = null;

    public static void initializeIDB() throws Exception {
        DBUtil.initializeDB("org.enhydra.instantdb.jdbc.idbDriver");
    }

    public static void initializePGDB() throws Exception {
        DBUtil.initializeDB("org.postgresql.Driver");
    }

    public static void initializeSybDB() throws Exception {
        DBUtil.initializeDB("com.sybase.jdbc2.jdbc.SybDriver");
    }

    public static void initializeDB(String sDriver) throws Exception {
        if (_bInitialized) {
            return;
        }
        Class.forName(sDriver).newInstance();
        _bInitialized = true;
    }

    public static void initializeDB(DBConstant database) throws Exception {
        if (database == INSTANTDB) {
            DBUtil.initializeIDB();
        } else if (database == POSTGRESQL) {
            DBUtil.initializePGDB();
        } else if (database == SYBASE) {
            DBUtil.initializeSybDB();
        }
        _database = database;
    }

    public static Connection createIDBConnection(String sDatabaseFile) throws SQLException {
        try {
            DBUtil.initializeIDB();
        }
        catch (Exception exception) {
            throw new SQLException("Could not load idb driver: " + exception.getMessage());
        }
        String sUser = "no_use";
        String sPassword = "no_password";
        Connection connection = DriverManager.getConnection("jdbc:idb:" + sDatabaseFile, sUser, sPassword);
        return connection;
    }

    public static Connection createPGConnection(String sDatabaseName) throws SQLException {
        try {
            DBUtil.initializePGDB();
        }
        catch (Exception exception) {
            throw new SQLException("Could not load postgresql driver: " + exception.getMessage());
        }
        String sUser = (String)System.getProperties().get("user.name");
        String sPassword = "no_password";
        Connection connection = DriverManager.getConnection("jdbc:postgresql:" + sDatabaseName, sUser, sPassword);
        return connection;
    }

    public static Connection createConnection(DBConstant database, String url, String user, String password, String applicationname, String clienthost) throws SQLException {
        try {
            DBUtil.initializeDB(database);
        }
        catch (Exception exception) {
            throw new SQLException("Could not load db driver: " + exception.getMessage());
        }
        Properties prop = new Properties();
        prop.put("user", user);
        prop.put("password", password);
        prop.put("applicationname", applicationname);
        prop.put("hostname", clienthost);
        Connection connection = DriverManager.getConnection(url, prop);
        return connection;
    }

    public static Statement createIDBStatement(String sDatabaseFile) throws SQLException {
        try {
            DBUtil.initializeIDB();
        }
        catch (Exception exception) {
            throw new SQLException("Could not load idb driver: " + exception.getMessage());
        }
        Connection connection = DBUtil.createIDBConnection(sDatabaseFile);
        Statement statement = connection.createStatement();
        return statement;
    }

    public static void close(Statement statement_) throws SQLException {
        Connection connection = statement_.getConnection();
        statement_.close();
        connection.close();
    }

    public static void deleteTable(Connection connection_, String sTableName_) throws SQLException {
        Statement statement = connection_.createStatement();
        statement.executeUpdate("delete from " + sTableName_);
        statement.close();
    }

    public static Vector getIDBUserTables(String sDatabaseFile) throws Exception {
        DBUtil.initializeIDB();
        Connection connection = DBUtil.createIDBConnection(sDatabaseFile);
        Vector vRetVal = DBUtil.getUserTables(connection);
        connection.close();
        return vRetVal;
    }

    public static Vector getUserTables(Connection connection) throws Exception {
        DatabaseMetaData metaData = connection.getMetaData();
        String[] asTableType = new String[]{"TABLE"};
        ResultSet result = metaData.getTables(null, null, null, asTableType);
        Vector<String> vResVal = new Vector<String>();
        while (result.next()) {
            String sTableSchema = result.getString(2);
            if (sTableSchema != null && sTableSchema.trim().equals("SYS_INFO")) continue;
            vResVal.addElement(result.getString(3));
        }
        result.close();
        return vResVal;
    }

    public static void copyRecord(ResultSet rsRecord_, Hashtable htRecord_) throws SQLException {
        ResultSetMetaData metaData = rsRecord_.getMetaData();
        int numberOfColumns = metaData.getColumnCount();
        int column = 1;
        while (column <= numberOfColumns) {
            String sColumnName = metaData.getColumnName(column);
            String sValue = rsRecord_.getString(sColumnName);
            htRecord_.put(sColumnName, sValue);
            ++column;
        }
    }

    public static String getNextId(Statement statement, String sTableName) throws SQLException {
        String sNextId = "1";
        ResultSet result = statement.executeQuery("select max(id) from " + sTableName);
        if (result.next()) {
            sNextId = Util.itoa(result.getInt(1) + 1);
        }
        result.close();
        return sNextId;
    }

    public static class DBConstant {
        private DBConstant() {
        }
    }
}

