/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing.test;

import ccl.swing.CCLLineBorder;
import ccl.swing.GraphicsUtil;
import ccl.util.Test;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class CCLLineBorderTest
extends Test {
    public void testCCLLineBorder() throws Exception {
        Border lineBorder;
        BufferedImage lineImage;
        BufferedImage image = this.createImage(null);
        this.Assert(!GraphicsUtil.equals(image, lineImage = this.createImage(lineBorder = BorderFactory.createLineBorder(Color.black, 1))));
        CCLLineBorder emptyCCLLineBorder = new CCLLineBorder(Color.black, new Insets(0, 0, 0, 0));
        BufferedImage emptyCCLLineImage = this.createImage(emptyCCLLineBorder);
        this.Assert(GraphicsUtil.equals(image, emptyCCLLineImage));
        CCLLineBorder cclLineBorder = new CCLLineBorder(Color.black, new Insets(1, 1, 1, 1));
        BufferedImage cclLineImage = this.createImage(cclLineBorder);
        this.Assert(GraphicsUtil.equals(lineImage, cclLineImage));
        Border thickLineBorder = BorderFactory.createLineBorder(Color.black, 3);
        BufferedImage thickLineImage = this.createImage(thickLineBorder);
        CCLLineBorder thickCCLLineBorder = new CCLLineBorder(Color.black, new Insets(3, 3, 3, 3));
        BufferedImage thickCCLLineImage = this.createImage(thickCCLLineBorder);
        this.Assert(GraphicsUtil.equals(thickLineImage, thickCCLLineImage));
    }

    private BufferedImage createImage(Border border) throws IOException {
        JPanel panel = new JPanel();
        panel.setSize(new Dimension(100, 100));
        panel.setPreferredSize(new Dimension(100, 100));
        panel.setMinimumSize(new Dimension(100, 100));
        panel.setMaximumSize(new Dimension(100, 100));
        panel.setBackground(Color.white);
        panel.setBorder(border);
        JFrame frame = new JFrame("CCLLineBorderTest");
        frame.getContentPane().setBackground(Color.red);
        frame.getContentPane().setLayout(null);
        frame.getContentPane().add(panel);
        panel.setLocation(50, 50);
        frame.pack();
        frame.setSize(200, 200);
        frame.setVisible(true);
        BufferedImage image = GraphicsUtil.componentToImage(panel, new JFrame().getContentPane());
        frame.setVisible(false);
        frame.dispose();
        return image;
    }

    public CCLLineBorderTest() {
    }

    public CCLLineBorderTest(Test pTest_) {
        super(pTest_);
    }

    protected void _doIt() throws Exception {
        this.testCCLLineBorder();
    }

    public static void main(String[] asArg_) {
        CCLLineBorderTest pTest = new CCLLineBorderTest();
        pTest.setVerbose(true);
        pTest.run();
        pTest.printResult();
        System.exit(0);
    }
}

