/*
 * Decompiled with CFR 0.152.
 */
package ccl.jcf;

import ccl.jcf.DumpClassToTxt;
import ccl.util.FileUtil;
import ccl.util.Util;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import lti.java.jcf.JcfClassFile;
import lti.java.jcf.JcfClassInputStream;

public class JavaDump {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("JavaDump 1.0  Copyright 1997 Matt Yourst");
            System.out.println();
            System.out.println("Purpose:");
            System.out.println("  Generates a complete report on the structures within");
            System.out.println("  Java class files. Sends report (in HTML format) to");
            System.out.println("  standard output; can be redirected to file if desired.");
            System.out.println("Syntax is:");
            System.out.println("  JavaDump <class file name> [-noconstpool]");
            System.out.println("  -noconstpool = Omit constant pool from report");
            return;
        }
        String sOutputFileName = args[1];
        FileInputStream fist = null;
        try {
            fist = new FileInputStream(args[0]);
        }
        catch (IOException ioe) {
            System.err.println("JavaDump Error: Cannot open " + args[0]);
            return;
        }
        JcfClassInputStream ist = new JcfClassInputStream(new BufferedInputStream(fist, Math.min(fist.available(), Short.MAX_VALUE)));
        JcfClassFile jcf = null;
        try {
            jcf = new JcfClassFile(ist);
            fist.close();
        }
        catch (Exception ex) {
            System.err.println("JavaDump Error: Exception while reading class file");
            fist.close();
            throw ex;
        }
        StringBuffer sbOutput = new StringBuffer();
        int flags = 0;
        if (args.length >= 2 && args[1].equals("-noconstpool")) {
            flags |= 1;
        }
        new DumpClassToTxt(jcf, sbOutput, flags).dump();
        try {
            FileUtil.writeFile(sOutputFileName, sbOutput.toString());
        }
        catch (Exception pException) {
            Util.debug("JavaDump.main(..).pException: " + pException);
        }
    }
}

