#=Ruby Ghostscript engine - Document Builder
#==About
#RubyGhost (RGhost) is a library for document developers wanting a quick and easy 
#way to generate pdf files. Notable features include: inserting images, 
#vector drawing , font suppoort , EPS template support and multiple output formats. 
#RGhost acts as Ruby a wrapper over the Ghostscript engine enriched by predefined 
#set Postscript(ps) functions. For example:
#
#Ruby code you'll write: 
#
#  h=HorizontalLine.new :middle, :start_in => 3, :size => 2
#
#gets translated to the following Postscript function. Note how this is not actually 
#raw Postscript, instead it makes use of a set of predefined functions shipped with Rghost. 
#
#  3 unit 2 unit exch gsave current_row row_height sqrt add moveto 0 rlineto stroke grestore
#
#Unless embarking into deep Postscript wizardry you don't need to be aware of this fact. 
#Basically RGhost is a helper for creating of Postscript documents. 
#The resulting Postscript document is rendered to the target format (usually pdf but not just) 
#by invoking  Ghostscript the free Postscript interpreter. Ghostscript settings very 
#a lot depending on your platform. Initially RGhost was developed for *nix environments 
#where Ghostscript is (almost always) native and used as a printing filter (CUPS, LPRng etc) 
#and also as a document format converter. So it became necessary to make an interface 
#between Ruby and Ghostscript in two ways:
#
#* gsapi     - based on the exchange of data between Ruby and Ghostscript via rgengine.so using gslib.so.8 or gslib-esp.so.8 
#* gsparams  - In this mode RGhost just pass parameters to the Ghostscript framework.1.1 Files
#	
#During the conversion of the postscript code to the desired format 4 files are created, 3 of them being temporary.
#
#====Input
#The input file is a pure postscript file with a .rgin extension that will be automatically removed after the conversion process, even if errors show up.
#
#====Errors
#Using a .rgerr extension, its content are the errors generated by ghostscript. It'll be deleted after the conversion. The content of the file is available on the errors variable of the RubyGhostEngine class.
#
#====Log
#The log file is set using the option :logfile of the RubyGhostEngine class, appending all logs to it. Disabled by default.
#
#====Output
#The output files will have the extension passed to the RGhost::Document#render method. For multi page formats it will return an array of files. These files aren't deleted automatically, meaning that the developer will have to deal with them.
#====Author
#Shairon Toledo  shairon.toledo(at)gmail.com http://www.hashcode.eti.br Brazil Jun/2008
#====Thanks
#Dee Zsombor[http://deezsombor.com] and Mereghost
#   
#==Installation and Setup
#====Ghostscript
#You need to have ESP Ghostscript 8.xx or GNU Ghostscript 8.xx installed
#
#=====Non-coupled installation: *gsparams* (recommended)
#This is the simplest setup, you'll have to dowload and install the Ghostscript framework(http://www.cs.wisc.edu/~ghost/). 
#Rhgost will invoke the ghostscript interpreter in the background to generate the desired output.
#
#===== Coupled installation: *gslib* (Linux only) 
#You can use the native ghostrcipt interface via the  gs-esp and libgs-esp8 (libgs-esp.so) packages. This may be already set up for you on Linux or you'll have to compile ghostscript
#=====Installation via remote gem
#  gem install rghost
#  
#=====Rails plugin installation 
#Gets last version in RubyForge[http://rubyforge.org/frs/?group_id=3796&release_id=18301] unpack on RAILS_ROOT/lib
#====Setup
#Look at RGhost::Config
#==Namespace 
#You can work either full namespace of including RGhost module. 
#=====Full namespace
# doc=RGhost::Document.new
#=====Including module RGhost
# include RGhost
# doc=Document.new

class RGhost::HowTo
  
end
