/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.linux.mips64el;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum OpenFlags implements Constant
{
    O_RDONLY(0L),
    O_WRONLY(1L),
    O_RDWR(2L),
    O_ACCMODE(3L),
    O_NONBLOCK(128L),
    O_APPEND(8L),
    O_SYNC(16400L),
    O_ASYNC(4096L),
    O_FSYNC(16400L),
    O_NOFOLLOW(131072L),
    O_CREAT(256L),
    O_TRUNC(512L),
    O_EXCL(1024L),
    O_DIRECTORY(65536L),
    O_NOCTTY(2048L),
    O_TMPFILE(0x410000L),
    O_CLOEXEC(524288L);

    private final long value;
    public static final long MIN_VALUE = 0L;
    public static final long MAX_VALUE = 0x410000L;

    private OpenFlags(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<OpenFlags, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<OpenFlags, String> generateTable() {
            EnumMap<OpenFlags, String> map2 = new EnumMap<OpenFlags, String>(OpenFlags.class);
            map2.put(O_RDONLY, "O_RDONLY");
            map2.put(O_WRONLY, "O_WRONLY");
            map2.put(O_RDWR, "O_RDWR");
            map2.put(O_ACCMODE, "O_ACCMODE");
            map2.put(O_NONBLOCK, "O_NONBLOCK");
            map2.put(O_APPEND, "O_APPEND");
            map2.put(O_SYNC, "O_SYNC");
            map2.put(O_ASYNC, "O_ASYNC");
            map2.put(O_FSYNC, "O_FSYNC");
            map2.put(O_NOFOLLOW, "O_NOFOLLOW");
            map2.put(O_CREAT, "O_CREAT");
            map2.put(O_TRUNC, "O_TRUNC");
            map2.put(O_EXCL, "O_EXCL");
            map2.put(O_DIRECTORY, "O_DIRECTORY");
            map2.put(O_NOCTTY, "O_NOCTTY");
            map2.put(O_TMPFILE, "O_TMPFILE");
            map2.put(O_CLOEXEC, "O_CLOEXEC");
            return map2;
        }
    }
}

