/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.jruby.Ruby;
import org.jruby.RubyArithmeticSequence;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyComplex;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertBytes;
import org.jruby.util.ConvertDouble;
import org.jruby.util.Numeric;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"Numeric"}, include={"Comparable"})
public class RubyNumeric
extends RubyObject {
    public static final double DBL_EPSILON = 2.220446049250313E-16;
    private static final String[] STEP_KEYS = new String[]{"to", "by"};

    public static RubyClass createNumericClass(Ruby runtime2) {
        RubyClass numeric = runtime2.defineClass("Numeric", runtime2.getObject(), RubyNumeric::new);
        numeric.setClassIndex(ClassIndex.NUMERIC);
        numeric.setReifiedClass(RubyNumeric.class);
        numeric.kindOf = new RubyModule.JavaClassKindOf(RubyNumeric.class);
        numeric.includeModule(runtime2.getComparable());
        numeric.defineAnnotatedMethods(RubyNumeric.class);
        return numeric;
    }

    public RubyNumeric(Ruby runtime2, RubyClass metaClass) {
        super(runtime2, metaClass);
    }

    public RubyNumeric(RubyClass metaClass) {
        super(metaClass);
    }

    public RubyNumeric(Ruby runtime2, RubyClass metaClass, boolean useObjectSpace) {
        super(runtime2, metaClass, useObjectSpace);
    }

    @Deprecated
    public RubyNumeric(Ruby runtime2, RubyClass metaClass, boolean useObjectSpace, boolean canBeTainted) {
        super(runtime2, metaClass, useObjectSpace, canBeTainted);
    }

    public static RoundingMode getRoundingMode(ThreadContext context, IRubyObject opts) {
        IRubyObject halfArg = ArgsUtil.extractKeywordArg(context, "half", opts);
        if (halfArg == context.nil) {
            return RoundingMode.HALF_UP;
        }
        if (halfArg instanceof RubySymbol || halfArg instanceof RubyString) {
            RubyString asString = halfArg.asString();
            if (!asString.getEncoding().isAsciiCompatible()) {
                throw context.runtime.newEncodingCompatibilityError("ASCII incompatible encoding: " + asString.getEncoding());
            }
            switch (halfArg.asJavaString()) {
                case "up": {
                    return RoundingMode.HALF_UP;
                }
                case "even": {
                    return RoundingMode.HALF_EVEN;
                }
                case "down": {
                    return RoundingMode.HALF_DOWN;
                }
            }
        }
        throw context.runtime.newArgumentError("invalid rounding mode: " + halfArg);
    }

    public long getLongValue() {
        return 0L;
    }

    public int getIntValue() {
        return (int)this.getLongValue();
    }

    public double getDoubleValue() {
        return this.getLongValue();
    }

    public BigInteger getBigIntegerValue() {
        return BigInteger.valueOf(this.getLongValue());
    }

    public static RubyNumeric newNumeric(Ruby runtime2) {
        return new RubyNumeric(runtime2, runtime2.getNumeric());
    }

    public static int num2int(IRubyObject arg2) {
        long num = RubyNumeric.num2long(arg2);
        RubyNumeric.checkInt(arg2, num);
        return (int)num;
    }

    public static int checkInt(Ruby runtime2, long num) {
        if ((long)((int)num) != num) {
            RubyNumeric.checkIntFail(runtime2, num);
        }
        return (int)num;
    }

    public static void checkInt(IRubyObject arg2, long num) {
        if ((long)((int)num) != num) {
            RubyNumeric.checkIntFail(arg2.getRuntime(), num);
        }
    }

    private static void checkIntFail(Ruby runtime2, long num) {
        if (num < Integer.MIN_VALUE) {
            throw runtime2.newRangeError("integer " + num + " too small to convert to `int'");
        }
        throw runtime2.newRangeError("integer " + num + " too big to convert to `int'");
    }

    public static byte num2chr(IRubyObject arg2) {
        if (arg2 instanceof RubyString && ((RubyString)arg2).size() > 0) {
            return (byte)((RubyString)arg2).getByteList().get(0);
        }
        return (byte)RubyNumeric.num2int(arg2);
    }

    public static long num2long(IRubyObject arg2) {
        return arg2 instanceof RubyFixnum ? ((RubyFixnum)arg2).value : RubyNumeric.other2long(arg2);
    }

    private static long other2long(IRubyObject arg2) throws RaiseException {
        if (arg2 instanceof RubyFloat) {
            return RubyNumeric.float2long((RubyFloat)arg2);
        }
        if (arg2 instanceof RubyBignum) {
            return RubyBignum.big2long((RubyBignum)arg2);
        }
        if (arg2.isNil()) {
            throw arg2.getRuntime().newTypeError("no implicit conversion from nil to integer");
        }
        return arg2.convertToInteger().getLongValue();
    }

    public static long float2long(RubyFloat flt) {
        double aFloat = flt.value;
        if (aFloat <= 9.223372036854776E18 && aFloat >= -9.223372036854776E18) {
            return (long)aFloat;
        }
        throw flt.getRuntime().newRangeError("float " + aFloat + " out of range of integer");
    }

    public static long num2ulong(IRubyObject arg2) {
        while (!(arg2 instanceof RubyFixnum)) {
            if (arg2 instanceof RubyBignum) {
                return RubyBignum.big2ulong((RubyBignum)arg2);
            }
            if (arg2 instanceof RubyFloat) {
                return RubyNumeric.float2ulong((RubyFloat)arg2);
            }
            if (arg2.isNil()) {
                throw arg2.getRuntime().newTypeError("no implicit conversion from nil to integer");
            }
            arg2 = arg2.convertToInteger();
        }
        return ((RubyFixnum)arg2).value;
    }

    public static long float2ulong(RubyFloat flt) {
        double aFloat = flt.value;
        if (aFloat <= 9.223372036854776E18 && aFloat >= 0.0) {
            BigDecimal bd = BigDecimal.valueOf(aFloat);
            BigInteger bi = bd.toBigInteger();
            return bi.longValue();
        }
        throw flt.getRuntime().newRangeError("float " + aFloat + " out of range of integer");
    }

    public static IRubyObject dbl2num(Ruby runtime2, double val) {
        return RubyFloat.newFloat(runtime2, val);
    }

    public static RubyInteger dbl2ival(Ruby runtime2, double val) {
        BigInteger big;
        if (Double.isNaN(val) || Double.isInfinite(val)) {
            throw runtime2.newFloatDomainError(Double.toString(val));
        }
        long fix2 = (long)val;
        if (fix2 == Long.MIN_VALUE || fix2 == Long.MAX_VALUE ? RubyNumeric.posFixable(big = BigDecimal.valueOf(val).toBigInteger()) && RubyNumeric.negFixable(big) : RubyNumeric.posFixable(val) && RubyNumeric.negFixable(val)) {
            return RubyFixnum.newFixnum(runtime2, fix2);
        }
        return RubyBignum.newBignorm(runtime2, val);
    }

    public static double num2dbl(IRubyObject arg2) {
        return RubyNumeric.num2dbl(arg2.getRuntime().getCurrentContext(), arg2);
    }

    public static double num2dbl(ThreadContext context, IRubyObject arg2) {
        switch (((RubyBasicObject)arg2).getNativeClassIndex()) {
            case FLOAT: {
                return ((RubyFloat)arg2).value;
            }
            case FIXNUM: {
                if (!context.sites.Fixnum.to_f.isBuiltin(arg2)) break;
                return ((RubyFixnum)arg2).value;
            }
            case BIGNUM: {
                if (!context.sites.Bignum.to_f.isBuiltin(arg2)) break;
                return ((RubyBignum)arg2).getDoubleValue();
            }
            case RATIONAL: {
                if (!context.sites.Rational.to_f.isBuiltin(arg2)) break;
                return ((RubyRational)arg2).getDoubleValue();
            }
            case STRING: 
            case NIL: 
            case TRUE: 
            case FALSE: {
                throw context.runtime.newTypeError(RubyStringBuilder.str(context.runtime, "can't convert ", arg2.inspect(), " into Float"));
            }
        }
        IRubyObject val = TypeConverter.convertToType(arg2, context.runtime.getFloat(), "to_f");
        return ((RubyFloat)val).value;
    }

    public static IRubyObject dbl_cmp(Ruby runtime2, double a, double b2) {
        if (Double.isNaN(a) || Double.isNaN(b2)) {
            return runtime2.getNil();
        }
        return a == b2 ? RubyFixnum.zero(runtime2) : (a > b2 ? RubyFixnum.one(runtime2) : RubyFixnum.minus_one(runtime2));
    }

    public static long fix2long(IRubyObject arg2) {
        return ((RubyFixnum)arg2).value;
    }

    public static int fix2int(IRubyObject arg2) {
        long num = arg2 instanceof RubyFixnum ? RubyNumeric.fix2long(arg2) : RubyNumeric.num2long(arg2);
        RubyNumeric.checkInt(arg2, num);
        return (int)num;
    }

    public static int fix2int(RubyFixnum arg2) {
        long num = arg2.value;
        RubyNumeric.checkInt(arg2, num);
        return (int)num;
    }

    public static RubyInteger str2inum(Ruby runtime2, RubyString str, int base) {
        return RubyNumeric.str2inum(runtime2, str, base, false);
    }

    public static RubyNumeric int2fix(Ruby runtime2, long val) {
        return RubyFixnum.newFixnum(runtime2, val);
    }

    public static IRubyObject num2fix(IRubyObject val) {
        if (val instanceof RubyFixnum) {
            return val;
        }
        if (val instanceof RubyBignum) {
            throw val.getRuntime().newRangeError("integer " + val + " out of range of fixnum");
        }
        return RubyFixnum.newFixnum(val.getRuntime(), RubyNumeric.num2long(val));
    }

    public static IRubyObject str2inum(Ruby runtime2, RubyString str, int base, boolean strict, boolean exception2) {
        if (!str.getEncoding().isAsciiCompatible()) {
            throw runtime2.newEncodingCompatibilityError("ASCII incompatible encoding: " + str.getEncoding());
        }
        ByteList s2 = str.getByteList();
        return ConvertBytes.byteListToInum(runtime2, s2, base, strict, exception2);
    }

    public static RubyInteger str2inum(Ruby runtime2, RubyString str, int base, boolean strict) {
        return (RubyInteger)RubyNumeric.str2inum(runtime2, str, base, strict, true);
    }

    public static RubyFloat str2fnum(Ruby runtime2, RubyString arg2) {
        return RubyNumeric.str2fnum(runtime2, arg2, false);
    }

    public static IRubyObject str2fnum(Ruby runtime2, RubyString arg2, boolean strict, boolean exception2) {
        try {
            double value2 = ConvertDouble.byteListToDouble19(arg2.getByteList(), strict);
            return RubyFloat.newFloat(runtime2, value2);
        }
        catch (NumberFormatException e) {
            if (strict) {
                if (!exception2) {
                    return runtime2.getNil();
                }
                throw runtime2.newArgumentError("invalid value for Float(): " + arg2.callMethod(runtime2.getCurrentContext(), "inspect").toString());
            }
            return RubyFloat.newFloat(runtime2, 0.0);
        }
    }

    public static RubyFloat str2fnum(Ruby runtime2, RubyString arg2, boolean strict) {
        return (RubyFloat)RubyNumeric.str2fnum(runtime2, arg2, strict, true);
    }

    protected final IRubyObject[] getCoerced(ThreadContext context, IRubyObject other, boolean error2) {
        IRubyObject result2;
        Ruby runtime2 = context.runtime;
        IRubyObject $ex = context.getErrorInfo();
        try {
            result2 = RubyNumeric.sites((ThreadContext)context).coerce.call(context, other, other, (IRubyObject)this);
        }
        catch (RaiseException e) {
            context.setErrorInfo($ex);
            if (error2) {
                throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, RubyStringBuilder.types(runtime2, (RubyModule)other.getMetaClass()), " can't be coerced into ", RubyStringBuilder.types(runtime2, (RubyModule)this.getMetaClass())));
            }
            return null;
        }
        return RubyNumeric.coerceResult(runtime2, result2, true).toJavaArrayMaybeUnsafe();
    }

    protected final IRubyObject callCoerced(ThreadContext context, String method2, IRubyObject other, boolean err) {
        IRubyObject[] args2 = this.getCoerced(context, other, err);
        if (args2 == null) {
            return context.nil;
        }
        return args2[0].callMethod(context, method2, args2[1]);
    }

    public final IRubyObject callCoerced(ThreadContext context, String method2, IRubyObject other) {
        return this.callCoerced(context, method2, other, false);
    }

    protected final IRubyObject callCoerced(ThreadContext context, CallSite site, IRubyObject other, boolean err) {
        IRubyObject[] args2 = this.getCoerced(context, other, err);
        if (args2 == null) {
            return context.nil;
        }
        IRubyObject car = args2[0];
        return site.call(context, car, car, args2[1]);
    }

    public final IRubyObject callCoerced(ThreadContext context, CallSite site, IRubyObject other) {
        return this.callCoerced(context, site, other, false);
    }

    protected final RubyArray doCoerce(ThreadContext context, IRubyObject other, boolean err) {
        IRubyObject ary = RubyNumeric.getMetaClass(other).finvokeChecked(context, other, RubyNumeric.sites((ThreadContext)context).coerce_checked, this);
        if (ary == null) {
            if (err) {
                this.coerceFailed(context, other);
            }
            return null;
        }
        IRubyObject $ex = context.getErrorInfo();
        return RubyNumeric.coerceResult(context.runtime, ary, err);
    }

    private static RubyArray coerceResult(Ruby runtime2, IRubyObject result2, boolean err) {
        if (result2 instanceof RubyArray && ((RubyArray)result2).getLength() == 2) {
            return (RubyArray)result2;
        }
        if (err || !result2.isNil()) {
            throw runtime2.newTypeError("coerce must return [x, y]");
        }
        return null;
    }

    protected final IRubyObject coerceRescue(ThreadContext context, IRubyObject other) {
        this.coerceFailed(context, other);
        return context.nil;
    }

    protected final void coerceFailed(ThreadContext context, IRubyObject other) {
        other = other.isSpecialConst() || other instanceof RubyFloat ? other.inspect() : other.getMetaClass().name(context);
        throw context.runtime.newTypeError(String.format("%s can't be coerced into %s", other, this.getMetaClass()));
    }

    @Deprecated
    protected final IRubyObject coerceBin(ThreadContext context, String method2, IRubyObject other) {
        RubyArray ary = this.doCoerce(context, other, true);
        return ary.eltInternal(0).callMethod(context, method2, (IRubyObject)ary.eltInternal(1));
    }

    protected final IRubyObject coerceBin(ThreadContext context, CallSite site, IRubyObject other) {
        RubyArray ary = this.doCoerce(context, other, true);
        Object car = ary.eltInternal(0);
        return site.call(context, (IRubyObject)car, (IRubyObject)car, (IRubyObject)ary.eltInternal(1));
    }

    protected final IRubyObject coerceBit(ThreadContext context, String method2, IRubyObject other) {
        if (!(other instanceof RubyFixnum) && !(other instanceof RubyBignum)) {
            RubyArray ary = this.doCoerce(context, other, true);
            Object x = ary.eltInternal(0);
            Object y = ary.eltInternal(1);
            if (!(x instanceof RubyFixnum || x instanceof RubyBignum || y instanceof RubyFixnum || y instanceof RubyBignum)) {
                this.coerceFailed(context, other);
            }
            return x.callMethod(context, method2, (IRubyObject)y);
        }
        return this.callMethod(context, method2, other);
    }

    protected final IRubyObject coerceBit(ThreadContext context, JavaSites.CheckedSites site, IRubyObject other) {
        Object y;
        RubyArray ary = this.doCoerce(context, other, true);
        final Object x = ary.eltOk(0L);
        IRubyObject ret = context.safeRecurse(new ThreadContext.RecursiveFunctionEx<JavaSites.CheckedSites>(){

            @Override
            public IRubyObject call(ThreadContext context, JavaSites.CheckedSites site, IRubyObject obj, boolean recur) {
                if (recur) {
                    throw context.runtime.newNameError(RubyStringBuilder.str(context.runtime, "recursive call to ", RubyStringBuilder.ids(context.runtime, site.methodName)), context.runtime.newSymbol(site.methodName));
                }
                return RubyBasicObject.getMetaClass(x).finvokeChecked(context, x, site, obj);
            }
        }, site, (IRubyObject)(y = ary.eltOk(1L)), site.methodName, true);
        if (ret == null) {
            this.coerceFailed(context, other);
        }
        return ret;
    }

    @Deprecated
    protected final IRubyObject coerceCmp(ThreadContext context, String method2, IRubyObject other) {
        RubyArray ary = this.doCoerce(context, other, false);
        if (ary == null) {
            return context.nil;
        }
        return ary.eltInternal(0).callMethod(context, method2, (IRubyObject)ary.eltInternal(1));
    }

    protected final IRubyObject coerceCmp(ThreadContext context, CallSite site, IRubyObject other) {
        RubyArray ary = this.doCoerce(context, other, false);
        if (ary == null) {
            return context.nil;
        }
        Object car = ary.eltInternal(0);
        return site.call(context, (IRubyObject)car, (IRubyObject)car, (IRubyObject)ary.eltInternal(1));
    }

    @Deprecated
    protected final IRubyObject coerceRelOp(ThreadContext context, String method2, IRubyObject other) {
        RubyArray ary = this.doCoerce(context, other, false);
        if (ary == null) {
            return RubyComparable.cmperr(this, other);
        }
        return this.unwrapCoerced(context, method2, other, ary);
    }

    protected final IRubyObject coerceRelOp(ThreadContext context, CallSite site, IRubyObject other) {
        RubyArray ary = this.doCoerce(context, other, false);
        if (ary == null) {
            return RubyComparable.cmperr(this, other);
        }
        return this.unwrapCoerced(context, site, other, ary);
    }

    private IRubyObject unwrapCoerced(ThreadContext context, String method2, IRubyObject other, RubyArray ary) {
        IRubyObject result2 = ary.eltInternal(0).callMethod(context, method2, (IRubyObject)ary.eltInternal(1));
        if (result2 == context.nil) {
            return RubyComparable.cmperr(this, other);
        }
        return result2;
    }

    private IRubyObject unwrapCoerced(ThreadContext context, CallSite site, IRubyObject other, RubyArray ary) {
        Object car = ary.eltInternal(0);
        IRubyObject result2 = site.call(context, (IRubyObject)car, (IRubyObject)car, (IRubyObject)ary.eltInternal(1));
        if (result2 == context.nil) {
            return RubyComparable.cmperr(this, other);
        }
        return result2;
    }

    public RubyNumeric asNumeric() {
        return this;
    }

    @Override
    @JRubyMethod(name={"!"})
    public IRubyObject op_not(ThreadContext context) {
        return context.fals;
    }

    @JRubyMethod(name={"singleton_method_added"})
    public static IRubyObject singleton_method_added(ThreadContext context, IRubyObject self2, IRubyObject name2) {
        Ruby runtime2 = context.runtime;
        throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, "can't define singleton method \"", RubyStringBuilder.ids(runtime2, name2), "\" for ", RubyStringBuilder.types(runtime2, (RubyModule)self2.getType())));
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject arg2) {
        if (arg2 == this) {
            return arg2;
        }
        this.checkFrozen();
        Ruby runtime2 = this.metaClass.runtime;
        throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, "can't copy ", RubyStringBuilder.types(runtime2, (RubyModule)this.getType())));
    }

    @JRubyMethod(name={"coerce"})
    public IRubyObject coerce(IRubyObject other) {
        Ruby runtime2 = this.metaClass.runtime;
        if (this.metaClass == other.getMetaClass()) {
            return runtime2.newArray(other, (IRubyObject)this);
        }
        RubyFloat cdr = RubyKernel.new_float(runtime2, (IRubyObject)this);
        RubyFloat car = RubyKernel.new_float(runtime2, other);
        return runtime2.newArray((IRubyObject)car, (IRubyObject)cdr);
    }

    @JRubyMethod(name={"+@"})
    public IRubyObject op_uplus() {
        return this;
    }

    @JRubyMethod(name={"i"})
    public IRubyObject num_imaginary(ThreadContext context) {
        return RubyComplex.newComplexRaw(context.runtime, RubyFixnum.zero(context.runtime), this);
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus(ThreadContext context) {
        RubyArray ary = RubyFixnum.zero(context.runtime).doCoerce(context, this, true);
        Object car = ary.eltInternal(0);
        return RubyNumeric.numFuncall(context, car, RubyNumeric.sites((ThreadContext)context).op_minus, ary.eltInternal(1));
    }

    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        return this.coerceBin(context, RubyNumeric.sites((ThreadContext)context).op_plus, other);
    }

    public IRubyObject op_minus(ThreadContext context, IRubyObject other) {
        return this.coerceBin(context, RubyNumeric.sites((ThreadContext)context).op_minus, other);
    }

    @Override
    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return RubyFixnum.zero(this.metaClass.runtime);
        }
        return this.metaClass.runtime.getNil();
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        if (this.getClass() != other.getClass()) {
            return context.fals;
        }
        return RubyNumeric.equalInternal(context, this, other) ? context.tru : context.fals;
    }

    @JRubyMethod(name={"quo"})
    public IRubyObject quo(ThreadContext context, IRubyObject other) {
        return RubyRational.numericQuo(context, this, other);
    }

    @Deprecated
    public final IRubyObject quo_19(ThreadContext context, IRubyObject other) {
        return this.quo(context, other);
    }

    @JRubyMethod(name={"div"})
    public IRubyObject div(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyNumeric && ((RubyNumeric)other).isZero()) {
            throw context.runtime.newZeroDivisionError();
        }
        IRubyObject quotient = RubyNumeric.numFuncall(context, this, RubyNumeric.sites((ThreadContext)context).op_quo, other);
        return RubyNumeric.sites((ThreadContext)context).floor.call(context, quotient, quotient);
    }

    public IRubyObject idiv(ThreadContext context, IRubyObject other) {
        return this.div(context, other);
    }

    public IRubyObject idiv(ThreadContext context, long other) {
        return this.idiv(context, RubyFixnum.newFixnum(context.runtime, other));
    }

    @JRubyMethod(name={"divmod"})
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        return RubyArray.newArray(context.runtime, this.div(context, other), this.modulo(context, other));
    }

    @JRubyMethod(name={"fdiv"})
    public IRubyObject fdiv(ThreadContext context, IRubyObject other) {
        RubyFloat value2 = this.convertToFloat();
        return RubyNumeric.sites((ThreadContext)context).op_quo.call(context, (IRubyObject)value2, (IRubyObject)value2, other);
    }

    @JRubyMethod(name={"modulo", "%"})
    public IRubyObject modulo(ThreadContext context, IRubyObject other) {
        IRubyObject div2 = RubyNumeric.numFuncall(context, this, RubyNumeric.sites((ThreadContext)context).div, other);
        IRubyObject product2 = RubyNumeric.sites((ThreadContext)context).op_times.call(context, other, other, div2);
        return RubyNumeric.sites((ThreadContext)context).op_minus.call(context, (IRubyObject)this, (IRubyObject)this, product2);
    }

    IRubyObject modulo(ThreadContext context, long other) {
        return this.modulo(context, RubyFixnum.newFixnum(context.runtime, other));
    }

    @JRubyMethod(name={"remainder"})
    public IRubyObject remainder(ThreadContext context, IRubyObject y) {
        return this.numRemainder(context, y);
    }

    public IRubyObject numRemainder(ThreadContext context, IRubyObject y) {
        RubyNumeric x = this;
        JavaSites.NumericSites sites = RubyNumeric.sites(context);
        IRubyObject z = sites.op_mod.call(context, (IRubyObject)this, (IRubyObject)this, y);
        if (!Helpers.rbEqual(context, z, RubyFixnum.zero(context.runtime), sites.op_equal).isTrue() && (x.isNegative() && RubyNumeric.positiveInt(context, y) || x.isPositive() && RubyNumeric.negativeInt(context, y))) {
            if (y instanceof RubyFloat && Double.isInfinite(((RubyFloat)y).value)) {
                return x;
            }
            return sites.op_minus.call(context, z, z, y);
        }
        return z;
    }

    public static boolean positiveInt(ThreadContext context, IRubyObject num) {
        if (num instanceof RubyNumeric) {
            return ((RubyNumeric)num).isPositive();
        }
        return RubyNumeric.compareWithZero(context, num, RubyNumeric.sites((ThreadContext)context).op_gt_checked).isTrue();
    }

    public static boolean negativeInt(ThreadContext context, IRubyObject num) {
        if (num instanceof RubyNumeric) {
            return ((RubyNumeric)num).isNegative();
        }
        return RubyNumeric.compareWithZero(context, num, RubyNumeric.sites((ThreadContext)context).op_lt_checked).isTrue();
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject abs(ThreadContext context) {
        if (RubyNumeric.sites((ThreadContext)context).op_lt.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)RubyFixnum.zero(context.runtime)).isTrue()) {
            return RubyNumeric.sites((ThreadContext)context).op_uminus.call(context, this, this);
        }
        return this;
    }

    @JRubyMethod(name={"magnitude"})
    public IRubyObject magnitude(ThreadContext context) {
        return this.abs(context);
    }

    @JRubyMethod(name={"to_int"})
    public IRubyObject to_int(ThreadContext context) {
        return RubyNumeric.numFuncall(context, this, RubyNumeric.sites((ThreadContext)context).to_i);
    }

    @JRubyMethod(name={"real?"})
    public IRubyObject real_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isReal());
    }

    public boolean isReal() {
        return true;
    }

    @Deprecated
    public IRubyObject scalar_p() {
        return this.getRuntime().newBoolean(this.isReal());
    }

    @JRubyMethod(name={"integer?"})
    public IRubyObject integer_p() {
        return this.metaClass.runtime.getFalse();
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        return RubyNumeric.equalInternal(context, this, RubyFixnum.zero(runtime2)) ? runtime2.getTrue() : runtime2.getFalse();
    }

    public boolean isZero() {
        return this.zero_p(this.metaClass.runtime.getCurrentContext()).isTrue();
    }

    @JRubyMethod(name={"nonzero?"})
    public IRubyObject nonzero_p(ThreadContext context) {
        if (RubyNumeric.numFuncall(context, this, RubyNumeric.sites((ThreadContext)context).zero).isTrue()) {
            return context.nil;
        }
        return this;
    }

    @JRubyMethod(name={"floor"})
    public IRubyObject floor(ThreadContext context) {
        return this.convertToFloat().floor(context);
    }

    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil(ThreadContext context) {
        return this.convertToFloat().ceil(context);
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round(ThreadContext context) {
        return this.convertToFloat().round(context);
    }

    @JRubyMethod(name={"truncate"})
    public IRubyObject truncate(ThreadContext context) {
        return this.convertToFloat().truncate(context);
    }

    @JRubyMethod(optional=2, checkArity=false)
    public IRubyObject step(ThreadContext context, IRubyObject[] args2, Block block) {
        Arity.checkArgumentCount(context, args2, 0, 2);
        if (!block.isGiven()) {
            IRubyObject[] newArgs = new IRubyObject[3];
            this.numExtractStepArgs(context, args2, newArgs);
            IRubyObject to = newArgs[0];
            IRubyObject step2 = newArgs[1];
            IRubyObject by = newArgs[2];
            if (!by.isNil()) {
                step2 = by;
            }
            if (step2.isNil()) {
                step2 = RubyFixnum.one(context.runtime);
            } else if (step2.op_equal(context, context.runtime.newFixnum(0)).isTrue()) {
                throw context.runtime.newArgumentError("step can't be 0");
            }
            if ((to.isNil() || to instanceof RubyNumeric) && step2 instanceof RubyNumeric) {
                return RubyArithmeticSequence.newArithmeticSequence(context, this, "step", args2, this, to, step2, context.fals);
            }
            return RubyEnumerator.enumeratorizeWithSize(context, this, "step", args2, RubyNumeric::stepSize);
        }
        IRubyObject[] newArgs = new IRubyObject[2];
        boolean desc = this.scanStepArgs(context, args2, newArgs);
        return this.stepCommon(context, newArgs[0], newArgs[1], desc, block);
    }

    private int numExtractStepArgs(ThreadContext context, IRubyObject[] args2, IRubyObject[] newArgs) {
        Ruby runtime2 = context.runtime;
        newArgs[1] = newArgs[2] = context.nil;
        newArgs[0] = newArgs[2];
        IRubyObject hash2 = ArgsUtil.getOptionsArg(runtime2, args2);
        int argc = hash2.isNil() ? args2.length : args2.length - 1;
        switch (argc) {
            case 2: {
                newArgs[1] = args2[1];
            }
            case 1: {
                newArgs[0] = args2[0];
            }
        }
        if (!hash2.isNil()) {
            IRubyObject[] values2 = ArgsUtil.extractKeywordArgs(context, (RubyHash)hash2, STEP_KEYS);
            if (values2[0] != null) {
                if (argc > 0) {
                    throw runtime2.newArgumentError("to is given twice");
                }
                newArgs[0] = values2[0];
            }
            if (values2[1] != null) {
                if (argc > 1) {
                    throw runtime2.newArgumentError("step is given twice");
                }
                newArgs[2] = values2[1];
            }
        }
        return argc;
    }

    private boolean numStepCheckFixArgs(ThreadContext context, int argc, IRubyObject[] newArgs, IRubyObject by) {
        Ruby runtime2 = context.runtime;
        IRubyObject to = newArgs[0];
        IRubyObject step2 = newArgs[1];
        if (!by.isNil()) {
            newArgs[1] = step2 = by;
        } else {
            if (argc > 1 && step2.isNil()) {
                throw runtime2.newTypeError("step must be numeric");
            }
            if (step2.op_equal(context, RubyFixnum.zero(runtime2)).isTrue()) {
                throw runtime2.newArgumentError("step can't be 0");
            }
        }
        if (step2.isNil()) {
            newArgs[1] = step2 = RubyFixnum.one(runtime2);
        }
        boolean desc = RubyNumeric.numStepNegative(context, runtime2, step2);
        if (to.isNil()) {
            to = desc ? RubyNumeric.dbl2num(runtime2, Double.NEGATIVE_INFINITY) : RubyNumeric.dbl2num(runtime2, Double.POSITIVE_INFINITY);
            newArgs[0] = to;
        }
        return desc;
    }

    private boolean scanStepArgs(ThreadContext context, IRubyObject[] args2, IRubyObject[] newArgs) {
        IRubyObject[] tmpNewArgs = new IRubyObject[3];
        int argc = this.numExtractStepArgs(context, args2, tmpNewArgs);
        System.arraycopy(tmpNewArgs, 0, newArgs, 0, 2);
        IRubyObject by = tmpNewArgs[2];
        return this.numStepCheckFixArgs(context, argc, newArgs, by);
    }

    private static boolean numStepNegative(ThreadContext context, Ruby runtime2, IRubyObject num) {
        if (num instanceof RubyInteger && context.sites.Integer.op_lt.isBuiltin(num)) {
            return ((RubyInteger)num).isNegative();
        }
        RubyFixnum zero = RubyFixnum.zero(runtime2);
        IRubyObject r = RubyNumeric.getMetaClass(num).finvokeChecked(context, num, RubyNumeric.sites((ThreadContext)context).op_gt_checked, zero);
        if (r == null) {
            ((RubyNumeric)num).coerceFailed(context, zero);
        }
        return !r.isTrue();
    }

    private IRubyObject stepCommon(ThreadContext context, IRubyObject to, IRubyObject step2, boolean desc, Block block) {
        double f;
        Ruby runtime2 = context.runtime;
        if (step2.op_equal(context, RubyFixnum.zero(runtime2)).isTrue()) {
            throw context.runtime.newArgumentError("step can't be 0");
        }
        boolean inf = to instanceof RubyFloat ? Double.isInfinite(f = ((RubyFloat)to).value) && (f <= -0.0 ? desc : !desc) : false;
        if (this instanceof RubyFixnum && (inf || to instanceof RubyFixnum) && step2 instanceof RubyFixnum) {
            RubyNumeric.fixnumStep(context, runtime2, (RubyFixnum)this, to, (RubyFixnum)step2, inf, desc, block);
        } else if (this instanceof RubyFloat || to instanceof RubyFloat || step2 instanceof RubyFloat) {
            RubyNumeric.floatStep(context, runtime2, this, to, step2, false, false, block);
        } else {
            RubyNumeric.duckStep(context, this, to, step2, inf, desc, block);
        }
        return this;
    }

    private static void fixnumStep(ThreadContext context, Ruby runtime2, RubyFixnum from, IRubyObject to, RubyFixnum step2, boolean inf, boolean desc, Block block) {
        long i2 = from.value;
        long diff = step2.value;
        if (inf) {
            while (true) {
                block.yield(context, RubyFixnum.newFixnum(runtime2, i2));
                context.pollThreadEvents();
                i2 += diff;
            }
        }
        long end2 = ((RubyFixnum)to).getLongValue();
        if (desc) {
            long tov = Long.MIN_VALUE - diff;
            if (end2 > tov) {
                tov = end2;
            }
            while (i2 >= tov) {
                block.yield(context, RubyFixnum.newFixnum(runtime2, i2));
                context.pollThreadEvents();
                i2 += diff;
            }
            if (i2 >= end2) {
                block.yield(context, RubyFixnum.newFixnum(runtime2, i2));
            }
        } else {
            long tov = Long.MAX_VALUE - diff;
            if (end2 < tov) {
                tov = end2;
            }
            while (i2 <= tov) {
                block.yield(context, RubyFixnum.newFixnum(runtime2, i2));
                context.pollThreadEvents();
                i2 += diff;
            }
            if (i2 <= end2) {
                block.yield(context, RubyFixnum.newFixnum(runtime2, i2));
            }
        }
    }

    static void floatStep(ThreadContext context, Ruby runtime2, IRubyObject from, IRubyObject to, IRubyObject step2, boolean excl, boolean allowEndless, Block block) {
        double beg = RubyNumeric.num2dbl(context, from);
        double end2 = allowEndless && to.isNil() ? Double.POSITIVE_INFINITY : RubyNumeric.num2dbl(context, to);
        double unit = RubyNumeric.num2dbl(context, step2);
        double n = RubyNumeric.floatStepSize(beg, end2, unit, excl);
        if (Double.isInfinite(unit)) {
            if (n != 0.0) {
                block.yield(context, RubyFloat.newFloat(runtime2, beg));
            }
        } else {
            if (unit == 0.0) {
                RubyFloat value2 = RubyFloat.newFloat(runtime2, beg);
                while (true) {
                    block.yield(context, value2);
                    context.pollThreadEvents();
                }
            }
            long i2 = 0L;
            while ((double)i2 < n) {
                double d = (double)i2 * unit + beg;
                if (unit >= 0.0 ? end2 < d : d < end2) {
                    d = end2;
                }
                block.yield(context, RubyFloat.newFloat(runtime2, d));
                context.pollThreadEvents();
                ++i2;
            }
        }
    }

    private static void duckStep(ThreadContext context, IRubyObject from, IRubyObject to, IRubyObject step2, boolean inf, boolean desc, Block block) {
        CachingCallSite cmpSite;
        IRubyObject i2 = from;
        if (inf) {
            while (true) {
                block.yield(context, i2);
                context.pollThreadEvents();
                i2 = RubyNumeric.sites((ThreadContext)context).op_plus.call(context, i2, i2, step2);
            }
        }
        CachingCallSite cachingCallSite = cmpSite = desc ? RubyNumeric.sites((ThreadContext)context).op_lt : RubyNumeric.sites((ThreadContext)context).op_gt;
        while (!((CallSite)cmpSite).call(context, i2, i2, to).isTrue()) {
            block.yield(context, i2);
            context.pollThreadEvents();
            i2 = RubyNumeric.sites((ThreadContext)context).op_plus.call(context, i2, i2, step2);
        }
    }

    public static RubyNumeric intervalStepSize(ThreadContext context, IRubyObject from, IRubyObject to, IRubyObject step2, boolean excl) {
        Ruby runtime2 = context.runtime;
        if (from instanceof RubyFixnum && to instanceof RubyFixnum && step2 instanceof RubyFixnum) {
            long diff = ((RubyFixnum)step2).value;
            if (diff == 0L) {
                return RubyFloat.newFloat(runtime2, Double.POSITIVE_INFINITY);
            }
            long toLong = ((RubyFixnum)to).value;
            long fromLong = ((RubyFixnum)from).value;
            long delta = toLong - fromLong;
            if (!Helpers.subtractionOverflowed(toLong, fromLong, delta)) {
                if (diff < 0L) {
                    diff = -diff;
                    delta = -delta;
                }
                if (excl) {
                    --delta;
                }
                if (delta < 0L) {
                    return runtime2.newFixnum(0);
                }
                long steps = delta / diff;
                long stepSize = steps + 1L;
                if (stepSize != Long.MIN_VALUE) {
                    return new RubyFixnum(runtime2, delta / diff + 1L);
                }
                return RubyBignum.newBignum(runtime2, BigInteger.valueOf(steps).add(BigInteger.ONE));
            }
        } else if (from instanceof RubyFloat || to instanceof RubyFloat || step2 instanceof RubyFloat) {
            double n = RubyNumeric.floatStepSize(from.convertToFloat().value, to.convertToFloat().value, step2.convertToFloat().value, excl);
            if (Double.isInfinite(n)) {
                return runtime2.newFloat(n);
            }
            if (RubyNumeric.posFixable(n)) {
                return runtime2.newFloat(n).convertToInteger();
            }
            return RubyBignum.newBignorm(runtime2, n);
        }
        JavaSites.NumericSites sites = RubyNumeric.sites(context);
        CachingCallSite op_gt2 = sites.op_gt;
        CachingCallSite op_lt2 = sites.op_lt;
        CachingCallSite cmpSite = op_gt2;
        RubyFixnum zero = RubyFixnum.zero(runtime2);
        IRubyObject comparison = zero.coerceCmp(context, sites.op_cmp, step2);
        switch (RubyComparable.cmpint(context, op_gt2, op_lt2, comparison, step2, zero)) {
            case 0: {
                return RubyFloat.newFloat(runtime2, Double.POSITIVE_INFINITY);
            }
            case 1: {
                cmpSite = op_lt2;
            }
        }
        if (((CallSite)cmpSite).call(context, from, from, to).isTrue()) {
            return RubyFixnum.zero(runtime2);
        }
        IRubyObject deltaObj = sites.op_minus.call(context, to, to, from);
        IRubyObject result2 = sites.div.call(context, deltaObj, deltaObj, step2);
        IRubyObject timesPlus = sites.op_plus.call(context, from, from, sites.op_times.call(context, result2, result2, step2));
        if (!excl || ((CallSite)cmpSite).call(context, timesPlus, timesPlus, to).isTrue()) {
            result2 = sites.op_plus.call(context, result2, result2, (IRubyObject)RubyFixnum.newFixnum(runtime2, 1L));
        }
        return (RubyNumeric)result2;
    }

    private static IRubyObject stepSize(ThreadContext context, RubyNumeric from, IRubyObject[] args2) {
        IRubyObject[] newArgs = new IRubyObject[2];
        from.scanStepArgs(context, args2, newArgs);
        return RubyNumeric.intervalStepSize(context, from, newArgs[0], newArgs[1], false);
    }

    public static boolean floatStep(ThreadContext context, IRubyObject from, IRubyObject to, IRubyObject step2, boolean excl, boolean allowEndless, Block block) {
        if (from instanceof RubyFloat || to instanceof RubyFloat || step2 instanceof RubyFloat) {
            double beg = RubyNumeric.num2dbl(from);
            double unit = RubyNumeric.num2dbl(step2);
            double end2 = allowEndless && to.isNil() ? (unit < 0.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY) : RubyNumeric.num2dbl(to);
            double n = RubyNumeric.floatStepSize(beg, end2, unit, excl);
            if (Double.isInfinite(unit)) {
                if (n > 0.0) {
                    block.yield(context, RubyNumeric.dbl2num(context.runtime, beg));
                    context.pollThreadEvents();
                }
            } else {
                if (unit == 0.0) {
                    IRubyObject val = RubyNumeric.dbl2num(context.runtime, beg);
                    while (true) {
                        block.yield(context, val);
                        context.pollThreadEvents();
                    }
                }
                long i2 = 0L;
                while ((double)i2 < n) {
                    double d = (double)i2 * unit + beg;
                    if (unit >= 0.0 ? end2 < d : d < end2) {
                        d = end2;
                    }
                    block.yield(context, RubyNumeric.dbl2num(context.runtime, d));
                    context.pollThreadEvents();
                    ++i2;
                }
            }
            return true;
        }
        return false;
    }

    public static double floatStepSize(double beg, double end2, double unit, boolean excludeLast) {
        double n = (end2 - beg) / unit;
        double err = (Math.abs(beg) + Math.abs(end2) + Math.abs(end2 - beg)) / Math.abs(unit) * 2.220446049250313E-16;
        if (Double.isInfinite(unit)) {
            if (unit > 0.0) {
                return beg <= end2 ? 1.0 : 0.0;
            }
            return end2 <= beg ? 1.0 : 0.0;
        }
        if (unit == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (err > 0.5) {
            err = 0.5;
        }
        if (excludeLast) {
            if (n <= 0.0) {
                return 0.0;
            }
            n = n < 1.0 ? 0.0 : Math.floor(n - err);
            double d = (n + 1.0) * unit + beg;
            if (beg < end2) {
                if (d < end2) {
                    n += 1.0;
                }
            } else if (beg > end2 && d > end2) {
                n += 1.0;
            }
        } else {
            if (n < 0.0) {
                return 0.0;
            }
            n = Math.floor(n + err);
        }
        return n + 1.0;
    }

    protected final IRubyObject op_num_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return context.tru;
        }
        if (this.isNil()) {
            return context.fals;
        }
        return RubyNumeric.numFuncall(context, other, RubyNumeric.sites((ThreadContext)context).op_equals, this);
    }

    @JRubyMethod(name={"numerator"})
    public IRubyObject numerator(ThreadContext context) {
        IRubyObject rational = Numeric.f_to_r(context, this);
        return RubyNumeric.sites((ThreadContext)context).numerator.call(context, rational, rational);
    }

    @JRubyMethod(name={"denominator"})
    public IRubyObject denominator(ThreadContext context) {
        IRubyObject rational = Numeric.f_to_r(context, this);
        return RubyNumeric.sites((ThreadContext)context).denominator.call(context, rational, rational);
    }

    public RubyRational convertToRational() {
        ThreadContext context = this.metaClass.runtime.getCurrentContext();
        return RubyRational.newRationalRaw(context.runtime, this.numerator(context), this.denominator(context));
    }

    @JRubyMethod(name={"to_c"})
    public IRubyObject to_c(ThreadContext context) {
        return RubyComplex.newComplexCanonicalize(context, this);
    }

    @JRubyMethod(name={"real"})
    public IRubyObject real(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"imaginary", "imag"})
    public IRubyObject image(ThreadContext context) {
        return RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod(name={"abs2"})
    public IRubyObject abs2(ThreadContext context) {
        return Numeric.f_mul(context, this, this);
    }

    @JRubyMethod(name={"arg", "angle", "phase"})
    public IRubyObject arg(ThreadContext context) {
        double value2 = this.getDoubleValue();
        if (Double.isNaN(value2)) {
            return this;
        }
        if (Numeric.f_negative_p(context, this) || value2 == 0.0 && 1.0 / value2 == Double.NEGATIVE_INFINITY) {
            return context.runtime.getMath().getConstant("PI");
        }
        return RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod(name={"rectangular", "rect"})
    public IRubyObject rect(ThreadContext context) {
        return context.runtime.newArray((IRubyObject)this, (IRubyObject)RubyFixnum.zero(context.runtime));
    }

    @JRubyMethod(name={"polar"})
    public IRubyObject polar(ThreadContext context) {
        return context.runtime.newArray(Numeric.f_abs(context, this), Numeric.f_arg(context, this));
    }

    @JRubyMethod(name={"conjugate", "conj"})
    public IRubyObject conjugate(ThreadContext context) {
        return this;
    }

    @Override
    public <T> T toJava(Class<T> target) {
        return JavaUtil.getNumericConverter(target).coerce(this, target);
    }

    @JRubyMethod(name={"negative?"})
    public IRubyObject isNegative(ThreadContext context) {
        return RubyNumeric.compareWithZero(context, this, RubyNumeric.sites((ThreadContext)context).op_lt_checked);
    }

    @JRubyMethod(name={"positive?"})
    public IRubyObject isPositive(ThreadContext context) {
        return RubyNumeric.compareWithZero(context, this, RubyNumeric.sites((ThreadContext)context).op_gt_checked);
    }

    public boolean isNegative() {
        return this.isNegative(this.metaClass.runtime.getCurrentContext()).isTrue();
    }

    public boolean isPositive() {
        return this.isPositive(this.metaClass.runtime.getCurrentContext()).isTrue();
    }

    protected static IRubyObject compareWithZero(ThreadContext context, IRubyObject num, JavaSites.CheckedSites site) {
        RubyFixnum zero = RubyFixnum.zero(context.runtime);
        IRubyObject r = RubyNumeric.getMetaClass(num).finvokeChecked(context, num, site, zero);
        if (r == null) {
            RubyComparable.cmperr(num, zero);
        }
        return r;
    }

    @JRubyMethod(name={"finite?"})
    public IRubyObject finite_p(ThreadContext context) {
        return context.tru;
    }

    @JRubyMethod(name={"infinite?"})
    public IRubyObject infinite_p(ThreadContext context) {
        return context.nil;
    }

    @Deprecated
    public final IRubyObject rbClone(IRubyObject[] args2) {
        ThreadContext context = this.metaClass.runtime.getCurrentContext();
        switch (args2.length) {
            case 0: {
                return this.rbClone(context);
            }
            case 1: {
                return this.rbClone(context, args2[0]);
            }
        }
        throw context.runtime.newArgumentError("wrong number of arguments (given " + args2.length + ", expected 0)");
    }

    @JRubyMethod(name={"clone"})
    public final IRubyObject rbClone(ThreadContext context) {
        return this;
    }

    @Override
    @JRubyMethod(name={"clone"})
    public final IRubyObject rbClone(ThreadContext context, IRubyObject arg2) {
        return super.rbClone(context, arg2);
    }

    @Override
    public final IRubyObject rbClone() {
        return this;
    }

    @Override
    public IRubyObject dup() {
        return this;
    }

    public static IRubyObject numFuncall(ThreadContext context, IRubyObject x, CallSite site) {
        return context.safeRecurse(new NumFuncall0(), site, x, site.methodName, true);
    }

    public static IRubyObject numFuncall(ThreadContext context, IRubyObject x, CallSite site, IRubyObject value2) {
        return context.safeRecurse(new NumFuncall1(value2), site, x, site.methodName, true);
    }

    public static boolean fixable(Ruby runtime2, double f) {
        if (Double.isNaN(f) || Double.isInfinite(f)) {
            throw runtime2.newFloatDomainError(Double.toString(f));
        }
        long l = (long)f;
        if (l == Long.MIN_VALUE || l == Long.MAX_VALUE) {
            BigInteger bigint = BigDecimal.valueOf(f).toBigInteger();
            return RubyNumeric.posFixable(bigint) && RubyNumeric.negFixable(bigint);
        }
        return RubyNumeric.posFixable(f) && RubyNumeric.negFixable(f);
    }

    public static boolean posFixable(BigInteger f) {
        return f.compareTo(RubyBignum.LONG_MAX) <= 0;
    }

    public static boolean negFixable(BigInteger f) {
        return f.compareTo(RubyBignum.LONG_MIN) >= 0;
    }

    public static boolean posFixable(double l) {
        return l < -9.223372036854776E18;
    }

    public static boolean negFixable(double l) {
        return l >= -9.223372036854776E18;
    }

    @Deprecated
    public IRubyObject floor() {
        return this.floor(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject ceil() {
        return this.ceil(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject round() {
        return this.round(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject truncate() {
        return this.truncate(this.getRuntime().getCurrentContext());
    }

    private static JavaSites.NumericSites sites(ThreadContext context) {
        return context.sites.Numeric;
    }

    @Deprecated
    public static RubyFloat str2fnum19(Ruby runtime2, RubyString arg2, boolean strict) {
        return RubyNumeric.str2fnum(runtime2, arg2, strict);
    }

    @Deprecated
    public final IRubyObject div19(ThreadContext context, IRubyObject other) {
        return this.div(context, other);
    }

    @Deprecated
    public final IRubyObject divmod19(ThreadContext context, IRubyObject other) {
        return this.divmod(context, other);
    }

    @Deprecated
    public final IRubyObject modulo19(ThreadContext context, IRubyObject other) {
        return this.modulo(context, other);
    }

    private static class NumFuncall0
    implements ThreadContext.RecursiveFunctionEx<CallSite> {
        private NumFuncall0() {
        }

        @Override
        public IRubyObject call(ThreadContext context, CallSite site, IRubyObject obj, boolean recur) {
            if (recur) {
                String name2 = site.methodName;
                if (name2.length() > 0 && Character.isLetterOrDigit(name2.charAt(0))) {
                    throw context.runtime.newNameError(name2, obj, name2);
                }
                if (name2.length() == 2 && name2.charAt(1) == '@') {
                    throw context.runtime.newNameError(name2, obj, name2.substring(0, 1));
                }
                throw context.runtime.newNameError(name2, obj, name2);
            }
            return site.call(context, obj, obj);
        }
    }

    private static class NumFuncall1
    implements ThreadContext.RecursiveFunctionEx<CallSite> {
        private final IRubyObject value;

        public NumFuncall1(IRubyObject value2) {
            this.value = value2;
        }

        @Override
        public IRubyObject call(ThreadContext context, CallSite site, IRubyObject obj, boolean recur) {
            if (recur) {
                String name2 = site.methodName;
                if (name2.length() > 0 && Character.isLetterOrDigit(name2.charAt(0))) {
                    throw context.runtime.newNameError(name2, obj, name2);
                }
                throw context.runtime.newNameError(name2, obj, name2);
            }
            return site.call(context, obj, obj, this.value);
        }
    }

    @Deprecated
    public static class NumberTooLargeException
    extends NumberFormatException {
        private static final long serialVersionUID = -1835120694982699449L;

        public NumberTooLargeException() {
        }

        public NumberTooLargeException(String message2) {
            super(message2);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    @Deprecated
    public static class InvalidIntegerException
    extends NumberFormatException {
        private static final long serialVersionUID = 55019452543252148L;

        public InvalidIntegerException() {
        }

        public InvalidIntegerException(String message2) {
            super(message2);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

