/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.asciidoctor.extension.BlockMacroProcessor;
import org.asciidoctor.extension.BlockProcessor;
import org.asciidoctor.extension.DocinfoProcessor;
import org.asciidoctor.extension.ExtensionGroup;
import org.asciidoctor.extension.IncludeProcessor;
import org.asciidoctor.extension.InlineMacroProcessor;
import org.asciidoctor.extension.Postprocessor;
import org.asciidoctor.extension.Preprocessor;
import org.asciidoctor.extension.Treeprocessor;
import org.asciidoctor.jruby.extension.processorproxies.AbstractProcessorProxy;
import org.asciidoctor.jruby.extension.processorproxies.BlockMacroProcessorProxy;
import org.asciidoctor.jruby.extension.processorproxies.BlockProcessorProxy;
import org.asciidoctor.jruby.extension.processorproxies.DocinfoProcessorProxy;
import org.asciidoctor.jruby.extension.processorproxies.IncludeProcessorProxy;
import org.asciidoctor.jruby.extension.processorproxies.InlineMacroProcessorProxy;
import org.asciidoctor.jruby.extension.processorproxies.PostprocessorProxy;
import org.asciidoctor.jruby.extension.processorproxies.PreprocessorProxy;
import org.asciidoctor.jruby.extension.processorproxies.TreeprocessorProxy;
import org.asciidoctor.jruby.internal.JRubyAsciidoctor;
import org.asciidoctor.jruby.internal.RubyUtils;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ExtensionGroupImpl
implements ExtensionGroup {
    private JRubyAsciidoctor asciidoctor;
    private final Ruby rubyRuntime;
    private final String groupName;
    private final RubyModule asciidoctorModule;
    private final RubyClass extensionGroupClass;
    private List<Registrator> registrators = new ArrayList<Registrator>();

    public ExtensionGroupImpl(String groupName, JRubyAsciidoctor asciidoctor, RubyClass extensionGroupClass) {
        this.groupName = groupName;
        this.asciidoctor = asciidoctor;
        this.rubyRuntime = asciidoctor.getRubyRuntime();
        this.asciidoctorModule = this.rubyRuntime.getModule("AsciidoctorModule");
        this.extensionGroupClass = extensionGroupClass;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void register() {
        IRubyObject callback = this.extensionGroupClass.newInstance(this.rubyRuntime.getCurrentContext(), Block.NULL_BLOCK);
        this.asciidoctorModule.callMethod("register_extension_group", new IRubyObject[]{this.rubyRuntime.newString(this.groupName), callback, JavaEmbedUtils.javaToRuby((Ruby)this.rubyRuntime, this.registrators)});
    }

    static RubyClass createExtensionGroupClass(Ruby rubyRuntime) {
        RubyClass extensionGroupClass = rubyRuntime.getModule("AsciidoctorModule").defineClassUnder("ExtensionGroupImpl", rubyRuntime.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                return new ExtensionGroupRegistrationCallback(runtime, klazz);
            }
        });
        extensionGroupClass.defineAnnotatedMethods(ExtensionGroupRegistrationCallback.class);
        return extensionGroupClass;
    }

    public void unregister() {
        this.asciidoctorModule.callMethod("unregister_extension", (IRubyObject)this.rubyRuntime.newString(this.groupName));
    }

    public ExtensionGroup docinfoProcessor(Class<? extends DocinfoProcessor> docInfoProcessor) {
        final RubyClass rubyClass = DocinfoProcessorProxy.register(this.asciidoctor, docInfoProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "docinfo_processor", (IRubyObject)rubyClass);
            }
        });
        return this;
    }

    public ExtensionGroup docinfoProcessor(DocinfoProcessor docInfoProcessor) {
        final RubyClass rubyClass = DocinfoProcessorProxy.register(this.asciidoctor, docInfoProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "docinfo_processor", (IRubyObject)rubyClass);
            }
        });
        return this;
    }

    public ExtensionGroup docinfoProcessor(String docInfoProcessor) {
        try {
            Class<?> docinfoProcessorClass = Class.forName(docInfoProcessor);
            this.docinfoProcessor(docinfoProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public ExtensionGroup preprocessor(Class<? extends Preprocessor> preprocessor) {
        final RubyClass rubyClass = PreprocessorProxy.register(this.asciidoctor, preprocessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "preprocessor", (IRubyObject)rubyClass);
            }
        });
        return this;
    }

    public ExtensionGroup preprocessor(Preprocessor preprocessor) {
        final RubyClass rubyClass = PreprocessorProxy.register(this.asciidoctor, preprocessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "preprocessor", (IRubyObject)rubyClass);
            }
        });
        return this;
    }

    public ExtensionGroup preprocessor(String preprocessor) {
        try {
            Class<?> preprocessorClass = Class.forName(preprocessor);
            this.preprocessor(preprocessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public ExtensionGroup postprocessor(String postprocessor) {
        try {
            Class<?> postprocessorClass = Class.forName(postprocessor);
            this.postprocessor(postprocessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public ExtensionGroup postprocessor(Class<? extends Postprocessor> postprocessor) {
        final RubyClass rubyClass = PostprocessorProxy.register(this.asciidoctor, postprocessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "postprocessor", (IRubyObject)rubyClass);
            }
        });
        return this;
    }

    public ExtensionGroup postprocessor(Postprocessor postprocessor) {
        final RubyClass rubyClass = PostprocessorProxy.register(this.asciidoctor, postprocessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "postprocessor", (IRubyObject)rubyClass);
            }
        });
        return this;
    }

    public ExtensionGroup includeProcessor(String includeProcessor) {
        try {
            Class<?> includeProcessorClass = Class.forName(includeProcessor);
            this.includeProcessor(includeProcessorClass);
            return this;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ExtensionGroup includeProcessor(Class<? extends IncludeProcessor> includeProcessor) {
        final RubyClass rubyClass = IncludeProcessorProxy.register(this.asciidoctor, includeProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "include_processor", (IRubyObject)rubyClass);
            }
        });
        return this;
    }

    public ExtensionGroup includeProcessor(IncludeProcessor includeProcessor) {
        final RubyClass rubyClass = IncludeProcessorProxy.register(this.asciidoctor, includeProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "include_processor", (IRubyObject)rubyClass);
            }
        });
        return this;
    }

    public ExtensionGroup treeprocessor(Treeprocessor treeprocessor) {
        final RubyClass rubyClass = TreeprocessorProxy.register(this.asciidoctor, treeprocessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "tree_processor", (IRubyObject)rubyClass);
            }
        });
        return this;
    }

    public ExtensionGroup treeprocessor(Class<? extends Treeprocessor> treeProcessor) {
        final RubyClass rubyClass = TreeprocessorProxy.register(this.asciidoctor, treeProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "tree_processor", (IRubyObject)rubyClass);
            }
        });
        return this;
    }

    public ExtensionGroup treeprocessor(String treeProcessor) {
        try {
            Class<?> treeProcessorClass = Class.forName(treeProcessor);
            this.treeprocessor(treeProcessorClass);
            return this;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ExtensionGroup block(String blockName, String blockProcessor) {
        try {
            Class<?> blockProcessorClass = Class.forName(blockProcessor);
            return this.block(blockName, blockProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ExtensionGroup block(String blockProcessor) {
        try {
            Class<?> blockProcessorClass = Class.forName(blockProcessor);
            return this.block(blockProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ExtensionGroup block(final String blockName, Class<? extends BlockProcessor> blockProcessor) {
        final RubyClass rubyClass = BlockProcessorProxy.register(this.asciidoctor, blockProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "block", new IRubyObject[]{rubyClass, ExtensionGroupImpl.this.rubyRuntime.newSymbol(blockName)});
            }
        });
        return this;
    }

    public ExtensionGroup block(final Class<? extends BlockProcessor> blockProcessor) {
        final RubyClass rubyClass = BlockProcessorProxy.register(this.asciidoctor, blockProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "block", new IRubyObject[]{rubyClass, ExtensionGroupImpl.this.rubyRuntime.newSymbol(BlockProcessorProxy.getName(blockProcessor))});
            }
        });
        return this;
    }

    public ExtensionGroup block(final BlockProcessor blockProcessor) {
        final RubyClass rubyClass = BlockProcessorProxy.register(this.asciidoctor, blockProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "block", new IRubyObject[]{rubyClass, ExtensionGroupImpl.this.rubyRuntime.newSymbol(blockProcessor.getName())});
            }
        });
        return this;
    }

    public ExtensionGroup block(final String blockName, BlockProcessor blockProcessor) {
        final RubyClass rubyClass = BlockProcessorProxy.register(this.asciidoctor, blockProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "block", new IRubyObject[]{rubyClass, ExtensionGroupImpl.this.rubyRuntime.newSymbol(blockName)});
            }
        });
        return this;
    }

    public ExtensionGroup blockMacro(final String blockName, Class<? extends BlockMacroProcessor> blockMacroProcessor) {
        final RubyClass rubyClass = BlockMacroProcessorProxy.register(this.asciidoctor, blockMacroProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "block_macro", new IRubyObject[]{rubyClass, ExtensionGroupImpl.this.rubyRuntime.newSymbol(blockName)});
            }
        });
        return this;
    }

    public ExtensionGroup blockMacro(final Class<? extends BlockMacroProcessor> blockMacroProcessor) {
        final RubyClass rubyClass = BlockMacroProcessorProxy.register(this.asciidoctor, blockMacroProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "block_macro", new IRubyObject[]{rubyClass, ExtensionGroupImpl.this.rubyRuntime.newSymbol(AbstractProcessorProxy.getName(blockMacroProcessor))});
            }
        });
        return this;
    }

    public ExtensionGroup blockMacro(String blockName, String blockMacroProcessor) {
        try {
            Class<?> blockMacroProcessorClass = Class.forName(blockMacroProcessor);
            return this.blockMacro(blockName, blockMacroProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ExtensionGroup blockMacro(String blockMacroProcessor) {
        try {
            Class<?> blockMacroProcessorClass = Class.forName(blockMacroProcessor);
            return this.blockMacro(blockMacroProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ExtensionGroup blockMacro(final BlockMacroProcessor blockMacroProcessor) {
        final RubyClass rubyClass = BlockMacroProcessorProxy.register(this.asciidoctor, blockMacroProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "block_macro", new IRubyObject[]{rubyClass, ExtensionGroupImpl.this.rubyRuntime.newSymbol(blockMacroProcessor.getName())});
            }
        });
        return this;
    }

    public ExtensionGroup inlineMacro(final InlineMacroProcessor inlineMacroProcessor) {
        final RubyClass rubyClass = InlineMacroProcessorProxy.register(this.asciidoctor, inlineMacroProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "inline_macro", new IRubyObject[]{rubyClass, ExtensionGroupImpl.this.rubyRuntime.newSymbol(inlineMacroProcessor.getName())});
            }
        });
        return this;
    }

    public ExtensionGroup inlineMacro(final String name, Class<? extends InlineMacroProcessor> inlineMacroProcessor) {
        final RubyClass rubyClass = InlineMacroProcessorProxy.register(this.asciidoctor, inlineMacroProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "inline_macro", new IRubyObject[]{rubyClass, ExtensionGroupImpl.this.rubyRuntime.newSymbol(name)});
            }
        });
        return this;
    }

    public ExtensionGroup inlineMacro(final Class<? extends InlineMacroProcessor> inlineMacroProcessor) {
        final RubyClass rubyClass = InlineMacroProcessorProxy.register(this.asciidoctor, inlineMacroProcessor);
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "inline_macro", new IRubyObject[]{rubyClass, ExtensionGroupImpl.this.rubyRuntime.newSymbol(AbstractProcessorProxy.getName(inlineMacroProcessor))});
            }
        });
        return this;
    }

    public ExtensionGroup inlineMacro(String name, String inlineMacroProcessor) {
        try {
            Class<?> inlineMacroProcessorClass = Class.forName(inlineMacroProcessor);
            return this.inlineMacro(name, inlineMacroProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ExtensionGroup inlineMacro(String inlineMacroProcessor) {
        try {
            Class<?> inlineMacroProcessorClass = Class.forName(inlineMacroProcessor);
            return this.inlineMacro(inlineMacroProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ExtensionGroup requireRubyLibrary(String requiredLibrary) {
        RubyUtils.requireLibrary(this.rubyRuntime, requiredLibrary);
        return this;
    }

    public ExtensionGroup loadRubyClass(InputStream rubyClassStream) {
        RubyUtils.loadRubyClass(this.rubyRuntime, rubyClassStream);
        return this;
    }

    public ExtensionGroup rubyPreprocessor(final String preprocessor) {
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "preprocessor", new IRubyObject[]{ExtensionGroupImpl.this.rubyRuntime.newString(preprocessor)});
            }
        });
        return this;
    }

    public ExtensionGroup rubyPostprocessor(final String postprocessor) {
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "postprocessor", new IRubyObject[]{ExtensionGroupImpl.this.rubyRuntime.newString(postprocessor)});
            }
        });
        return this;
    }

    public ExtensionGroup rubyDocinfoProcessor(final String docinfoProcessor) {
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "docinfo_processor", new IRubyObject[]{ExtensionGroupImpl.this.rubyRuntime.newString(docinfoProcessor)});
            }
        });
        return this;
    }

    public ExtensionGroup rubyIncludeProcessor(final String includeProcessor) {
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "include_processor", new IRubyObject[]{ExtensionGroupImpl.this.rubyRuntime.newString(includeProcessor)});
            }
        });
        return this;
    }

    public ExtensionGroup rubyTreeprocessor(final String treeProcessor) {
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "tree_processor", new IRubyObject[]{ExtensionGroupImpl.this.rubyRuntime.newString(treeProcessor)});
            }
        });
        return this;
    }

    public ExtensionGroup rubyBlock(final String blockName, final String blockProcessor) {
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "block", new IRubyObject[]{ExtensionGroupImpl.this.rubyRuntime.newString(blockProcessor), ExtensionGroupImpl.this.rubyRuntime.newSymbol(blockName)});
            }
        });
        return this;
    }

    public ExtensionGroup rubyBlock(final String blockProcessor) {
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "block", new IRubyObject[]{ExtensionGroupImpl.this.rubyRuntime.newString(blockProcessor)});
            }
        });
        return this;
    }

    public ExtensionGroup rubyBlockMacro(final String blockName, final String blockMacroProcessor) {
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "block_macro", new IRubyObject[]{ExtensionGroupImpl.this.rubyRuntime.newString(blockMacroProcessor), ExtensionGroupImpl.this.rubyRuntime.newSymbol(blockName)});
            }
        });
        return this;
    }

    public ExtensionGroup rubyBlockMacro(final String blockMacroProcessor) {
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "block_macro", new IRubyObject[]{ExtensionGroupImpl.this.rubyRuntime.newString(blockMacroProcessor)});
            }
        });
        return this;
    }

    public ExtensionGroup rubyInlineMacro(final String macroName, final String inlineMacroProcessor) {
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "inline_macro", new IRubyObject[]{ExtensionGroupImpl.this.rubyRuntime.newString(inlineMacroProcessor), ExtensionGroupImpl.this.rubyRuntime.newSymbol(macroName)});
            }
        });
        return this;
    }

    public ExtensionGroup rubyInlineMacro(final String inlineMacroProcessor) {
        this.registrators.add(new Registrator(){

            @Override
            public void register(IRubyObject registry) {
                registry.callMethod(ExtensionGroupImpl.this.rubyRuntime.getCurrentContext(), "inline_macro", new IRubyObject[]{ExtensionGroupImpl.this.rubyRuntime.newString(inlineMacroProcessor)});
            }
        });
        return this;
    }

    public static interface Registrator {
        public void register(IRubyObject var1);
    }

    public static class ExtensionGroupRegistrationCallback
    extends RubyObject {
        private List<Registrator> registrators = new ArrayList<Registrator>();

        ExtensionGroupRegistrationCallback(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }

        @JRubyMethod(name={"register_extensions"}, required=2)
        public IRubyObject registerExtensions(ThreadContext context, IRubyObject registry, IRubyObject rubyRegistrators) {
            List registrators = (List)JavaEmbedUtils.rubyToJava((IRubyObject)rubyRegistrators);
            for (Registrator registrator : registrators) {
                registrator.register(registry);
            }
            return context.getRuntime().getNil();
        }
    }
}

