/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences;

import java.util.concurrent.CopyOnWriteArrayList;
import org.omegat.gui.preferences.IPreferencesController;
import org.omegat.util.Preferences;

public abstract class BasePreferencesController
implements IPreferencesController {
    private CopyOnWriteArrayList<IPreferencesController.FurtherActionListener> listeners = new CopyOnWriteArrayList();
    private boolean restartRequired = false;
    private boolean reloadRequired = false;

    @Override
    public void addFurtherActionListener(IPreferencesController.FurtherActionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeFurtherActionListener(IPreferencesController.FurtherActionListener listener) {
        this.listeners.remove(listener);
    }

    protected boolean valueIsDifferent(String prefsKey, Object newValue) {
        String oldValue = Preferences.getPreference(prefsKey);
        return !oldValue.equals(newValue.toString());
    }

    protected void fireRestartRequired() {
        for (IPreferencesController.FurtherActionListener listener : this.listeners) {
            listener.setRestartRequired(this.restartRequired);
        }
    }

    protected void fireReloadRequired() {
        for (IPreferencesController.FurtherActionListener listener : this.listeners) {
            listener.setReloadRequired(this.reloadRequired);
        }
    }

    public void setRestartRequired(boolean restartRequired) {
        this.restartRequired = restartRequired;
        this.fireRestartRequired();
    }

    public void setReloadRequired(boolean reloadRequired) {
        this.reloadRequired = reloadRequired;
        this.fireReloadRequired();
    }

    @Override
    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    @Override
    public boolean isReloadRequired() {
        return this.reloadRequired;
    }

    @Override
    public void undoChanges() {
        this.initFromPrefs();
        this.setReloadRequired(false);
        this.setRestartRequired(false);
    }

    protected abstract void initFromPrefs();

    @Override
    public abstract String toString();
}

