/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.io.File;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;

public class ChoosePluginFile
extends JFileChooser {
    public ChoosePluginFile() {
        super(Preferences.getPreference("current_folder"));
        this.setMultiSelectionEnabled(false);
        this.setFileHidingEnabled(true);
        this.setFileSelectionMode(0);
        this.setDialogTitle(OStrings.getString("GUI_PLUGIN_OPEN"));
        this.setAcceptAllFileFilterUsed(false);
        this.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return OStrings.getString("GUI_PLUGIN_OPEN");
            }

            @Override
            public boolean accept(File f) {
                return ChoosePluginFile.this.isAcceptable(f);
            }
        });
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        return this.isAcceptable(f);
    }

    private boolean isAcceptable(File f) {
        if (!f.isFile()) {
            return false;
        }
        String name = f.getName().toLowerCase(Locale.ENGLISH);
        return name.endsWith(".jar") || name.endsWith(".zip");
    }
}

