/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team2.impl;

import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.ConnectorFactory;
import com.jcraft.jsch.agentproxy.TrileadAgentProxy;
import com.trilead.ssh2.auth.AgentProxy;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import org.omegat.core.Core;
import org.omegat.core.KnownException;
import org.omegat.core.team2.ProjectTeamSettings;
import org.omegat.core.team2.TeamSettings;
import org.omegat.core.team2.impl.SVNUserPassDialog;
import org.omegat.core.team2.impl.TeamUtils;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.ISVNProxyManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SVNAuthenticationManager
implements ISVNAuthenticationManager {
    static final int CONNECT_TIMEOUT = 30000;
    static final int READ_TIMEOUT = 60000;
    static final String KEY_USERNAME_SUFFIX = "username";
    static final String KEY_PASSWORD_SUFFIX = "password";
    private static final Logger LOGGER = Logger.getLogger(SVNAuthenticationManager.class.getName());
    private final String repoUrl;
    private final String predefinedUser;
    private final String predefinedPass;
    ISVNProxyManager NO_PROXY = new ISVNProxyManager(){

        public String getProxyHost() {
            return null;
        }

        public String getProxyPassword() {
            return null;
        }

        public int getProxyPort() {
            return -1;
        }

        public String getProxyUserName() {
            return null;
        }

        public void acknowledgeProxyContext(boolean accepted, SVNErrorMessage errorMessage) {
        }
    };

    public SVNAuthenticationManager(String repoUrl, String predefinedUser, String predefinedPass, ProjectTeamSettings teamSettings) {
        this.repoUrl = repoUrl;
        this.predefinedUser = predefinedUser;
        this.predefinedPass = predefinedPass;
    }

    public void acknowledgeAuthentication(boolean accepted, String kind, String realm, SVNErrorMessage errorMessage, SVNAuthentication authentication) throws SVNException {
        if (!accepted) {
            Log.logDebug(LOGGER, "SVN authentication error: {0}", errorMessage);
        }
    }

    public void acknowledgeTrustManager(TrustManager manager) {
        throw new UnsupportedOperationException();
    }

    public int getConnectTimeout(SVNRepository repository) {
        return 30000;
    }

    public int getReadTimeout(SVNRepository repository) {
        return 60000;
    }

    protected SVNAuthentication ask(String kind, SVNURL url, String message) throws SVNException {
        if (!"svn.simple".equals(kind) && !"svn.ssh".equals(kind)) {
            if ("svn.username".equals(kind)) {
                return SVNUserNameAuthentication.newInstance((String)"", (boolean)false, (SVNURL)url, (boolean)false);
            }
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_UNKNOWN_AUTH));
        }
        if (Core.getMainWindow() == null) {
            Log.log("called ask in headless mode. return null");
            return null;
        }
        SVNUserPassDialog userPassDialog = new SVNUserPassDialog(Core.getMainWindow().getApplicationFrame());
        userPassDialog.setLocationRelativeTo(Core.getMainWindow().getApplicationFrame());
        userPassDialog.descriptionTextArea.setText(message);
        userPassDialog.setVisible(true);
        if (userPassDialog.getReturnStatus() != 1) {
            return null;
        }
        String user = userPassDialog.userText.getText();
        String pass = new String(userPassDialog.passwordField.getPassword());
        String saveUri = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort();
        TeamSettings.set(saveUri + "!username", user);
        TeamSettings.set(saveUri + "!password", TeamUtils.encodePassword(pass));
        if ("svn.simple".equals(kind)) {
            return SVNPasswordAuthentication.newInstance((String)user, (char[])pass.toCharArray(), (boolean)false, (SVNURL)url, (boolean)false);
        }
        if ("svn.ssh".equals(kind)) {
            return SVNSSHAuthentication.newInstance((String)user, (char[])pass.toCharArray(), (int)-1, (boolean)false, (SVNURL)url, (boolean)false);
        }
        throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_UNKNOWN_AUTH));
    }

    public SVNAuthentication getFirstAuthentication(String kind, String realm, SVNURL url) throws SVNException {
        if (this.predefinedUser != null && this.predefinedPass != null) {
            if ("svn.simple".equals(kind)) {
                return SVNPasswordAuthentication.newInstance((String)this.predefinedUser, (char[])this.predefinedPass.toCharArray(), (boolean)false, (SVNURL)url, (boolean)false);
            }
            if ("svn.ssh".equals(kind)) {
                return SVNSSHAuthentication.newInstance((String)this.predefinedUser, (char[])this.predefinedPass.toCharArray(), (int)-1, (boolean)false, (SVNURL)url, (boolean)false);
            }
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_NO_PROVIDER));
        }
        if (this.predefinedUser != null) {
            try {
                return SVNSSHAuthentication.newInstance((String)this.predefinedUser, (AgentProxy)new TrileadAgentProxy(ConnectorFactory.getDefault().createConnector()), (int)-1, (SVNURL)url, (boolean)false);
            }
            catch (AgentProxyException e) {
                Log.logDebug(LOGGER, "ssh-agent support couldn't be initialized: {0}", e.getMessage());
            }
        }
        String user = TeamSettings.get(this.repoUrl + "!username");
        String pass = TeamUtils.decodePassword(TeamSettings.get(this.repoUrl + "!password"));
        if (user == null) {
            String saveUri = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort();
            user = TeamSettings.get(saveUri + "!username");
            pass = TeamUtils.decodePassword(TeamSettings.get(saveUri + "!password"));
        }
        if (user != null && pass != null) {
            if ("svn.simple".equals(kind)) {
                return SVNPasswordAuthentication.newInstance((String)user, (char[])pass.toCharArray(), (boolean)false, (SVNURL)url, (boolean)false);
            }
            if ("svn.ssh".equals(kind)) {
                return SVNSSHAuthentication.newInstance((String)user, (char[])pass.toCharArray(), (int)-1, (boolean)false, (SVNURL)url, (boolean)false);
            }
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_NO_PROVIDER));
        }
        return this.ask(kind, url, OStrings.getString("TEAM_USERPASS_FIRST", url.getPath()));
    }

    public SVNAuthentication getNextAuthentication(String kind, String realm, SVNURL url) throws SVNException {
        if (this.predefinedUser != null && this.predefinedPass != null) {
            throw new KnownException("TEAM_PREDEFINED_CREDENTIALS_ERROR", new Object[0]);
        }
        return this.ask(kind, url, OStrings.getString("TEAM_USERPASS_WRONG", url.getPath()));
    }

    public ISVNProxyManager getProxyManager(SVNURL url) throws SVNException {
        return this.NO_PROXY;
    }

    public TrustManager getTrustManager(SVNURL url) throws SVNException {
        return null;
    }

    public boolean isAuthenticationForced() {
        return false;
    }

    public void setAuthenticationProvider(ISVNAuthenticationProvider provider) {
        throw new UnsupportedOperationException();
    }
}

