/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.doublearray;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.trie4j.AbstractTermIdTrie;
import org.trie4j.Node;
import org.trie4j.TermIdNode;
import org.trie4j.TermIdTrie;
import org.trie4j.Trie;
import org.trie4j.bv.BytesRank1OnlySuccinctBitVector;
import org.trie4j.bv.SuccinctBitVector;
import org.trie4j.tail.SuffixTrieTailArray;
import org.trie4j.tail.TailArray;
import org.trie4j.tail.TailArrayBuilder;
import org.trie4j.tail.TailCharIterator;
import org.trie4j.tail.TailUtil;
import org.trie4j.util.BitSet;
import org.trie4j.util.FastBitSet;
import org.trie4j.util.Pair;

public class TailDoubleArray
extends AbstractTermIdTrie
implements TermIdTrie,
Externalizable {
    private int size;
    private int nodeSize;
    private int[] base;
    private int[] check;
    private int firstEmptyCheck = 1;
    private int last;
    private SuccinctBitVector term;
    private TailArray tailArray;
    private Set<Character> chars = new TreeSet<Character>();
    private char[] charToCode = new char[65536];
    private static final TermIdNode[] emptyNodes = new TermIdNode[0];
    private static final int BASE_EMPTY = Integer.MAX_VALUE;

    public TailDoubleArray() {
    }

    public TailDoubleArray(Trie orig) {
        this(orig, new SuffixTrieTailArray());
    }

    public TailDoubleArray(Trie orig, TailArrayBuilder tab) {
        this(orig, tab, new TermNodeListener(){

            @Override
            public void listen(Node node, int nodeIndex) {
            }
        });
    }

    @Override
    public int nodeSize() {
        return this.nodeSize;
    }

    public TailDoubleArray(Trie orig, TailArrayBuilder tab, TermNodeListener listener) {
        this.size = orig.size();
        this.nodeSize = orig.nodeSize();
        int as = this.size;
        if (as <= 1) {
            as = 2;
        }
        this.base = new int[as];
        Arrays.fill(this.base, Integer.MAX_VALUE);
        this.check = new int[as];
        Arrays.fill(this.check, -1);
        Arrays.fill(this.charToCode, '\u0000');
        FastBitSet bs = new FastBitSet(orig.size() * 2);
        this.build(orig.getRoot(), 0, tab, bs, listener);
        this.term = new BytesRank1OnlySuccinctBitVector(bs.getBytes(), bs.size());
        this.tailArray = tab.build();
        this.base = Arrays.copyOf(this.base, this.last + this.chars.size());
        this.check = Arrays.copyOf(this.check, this.last + this.chars.size());
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public TermIdNode getRoot() {
        return new TailDoubleArrayNode(0);
    }

    public int[] getBase() {
        return this.base;
    }

    public int[] getCheck() {
        return this.check;
    }

    public BitSet getTerm() {
        return this.term;
    }

    public TailArray getTailArray() {
        return this.tailArray;
    }

    @Override
    public int getTermId(String text) {
        int nodeIndex = 0;
        TailCharIterator it = this.tailArray.newIterator();
        int checkLen = this.check.length;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char cid = this.charToCode[text.charAt(i)];
            if (cid == '\u0000') {
                return -1;
            }
            int next = this.base[nodeIndex] + cid;
            if (next < 0 || checkLen <= next || this.check[next] != nodeIndex) {
                return -1;
            }
            nodeIndex = next;
            int ti = this.tailArray.getIteratorOffset(nodeIndex);
            if (ti == -1) continue;
            it.setIndex(ti);
            while (it.hasNext()) {
                if (++i == n) {
                    return -1;
                }
                if (text.charAt(i) == it.next()) continue;
                return -1;
            }
        }
        return this.term.get(nodeIndex) ? this.term.rank1(nodeIndex) - 1 : -1;
    }

    @Override
    public Iterable<Pair<String, Integer>> commonPrefixSearchWithTermId(String query) {
        ArrayList<Pair<String, Integer>> ret = new ArrayList<Pair<String, Integer>>();
        int charsLen = query.length();
        int ni = 0;
        TailCharIterator it = this.tailArray.newIterator();
        for (int ci = 0; ci < charsLen; ++ci) {
            int cid = this.findCharId(query.charAt(ci));
            if (cid == -1) {
                return ret;
            }
            int b = this.base[ni];
            if (b == Integer.MAX_VALUE) {
                return ret;
            }
            int next = b + cid;
            if (next < 0 || this.check.length <= next || this.check[next] != ni) {
                return ret;
            }
            ni = next;
            int ti = this.tailArray.getIteratorOffset(ni);
            if (ti != -1) {
                it.setIndex(ti);
                while (it.hasNext()) {
                    char c = it.next();
                    if (++ci >= charsLen) {
                        return ret;
                    }
                    if (c == query.charAt(ci)) continue;
                    return ret;
                }
            }
            if (!this.term.get(ni)) continue;
            ret.add(Pair.create(query.substring(0, ci + 1), this.term.rank1(ni) - 1));
        }
        return ret;
    }

    @Override
    public Iterable<Pair<String, Integer>> predictiveSearchWithTermId(String prefix) {
        TreeSet<Pair<String, Integer>> ret = new TreeSet<Pair<String, Integer>>(new Comparator<Pair<String, Integer>>(){

            @Override
            public int compare(Pair<String, Integer> o1, Pair<String, Integer> o2) {
                return o1.getFirst().compareTo(o2.getFirst());
            }
        });
        StringBuilder current = new StringBuilder();
        char[] chars = prefix.toCharArray();
        int charsLen = chars.length;
        int checkLen = this.check.length;
        int nodeIndex = 0;
        TailCharIterator it = this.tailArray.newIterator();
        for (int i = 0; i < chars.length; ++i) {
            int cid;
            int ti = this.tailArray.getIteratorOffset(nodeIndex);
            if (ti != -1) {
                int first = i;
                it.setIndex(ti);
                while (it.hasNext()) {
                    if (it.next() != chars[i]) {
                        return ret;
                    }
                    if (++i < charsLen) continue;
                }
                if (i >= charsLen) break;
                current.append(chars, first, i - first);
            }
            if ((cid = this.findCharId(chars[i])) == -1) {
                return ret;
            }
            int next = this.base[nodeIndex] + cid;
            if (next < 0 || checkLen <= next || this.check[next] != nodeIndex) {
                return ret;
            }
            nodeIndex = next;
            current.append(chars[i]);
        }
        LinkedList<Pair<Integer, char[]>> q = new LinkedList<Pair<Integer, char[]>>();
        q.add(Pair.create(nodeIndex, current.toString().toCharArray()));
        while (!q.isEmpty()) {
            int b;
            Pair p = (Pair)q.pop();
            int ni = (Integer)p.getFirst();
            StringBuilder buff = new StringBuilder().append((char[])p.getSecond());
            this.tailArray.getChars(buff, ni);
            if (this.term.get(ni)) {
                ret.add(Pair.create(buff.toString(), this.term.rank1(ni) - 1));
            }
            if ((b = this.base[ni]) == Integer.MAX_VALUE) continue;
            for (char v : this.chars) {
                int next = b + this.charToCode[v];
                if (next < 0 || checkLen <= next || this.check[next] != ni) continue;
                StringBuilder bu = new StringBuilder(buff);
                bu.append(v);
                q.push(Pair.create(next, bu.toString().toCharArray()));
            }
        }
        return ret;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.nodeSize);
        out.writeInt(this.base.length);
        for (int v : this.base) {
            out.writeInt(v);
        }
        for (int v : this.check) {
            out.writeInt(v);
        }
        out.writeObject(this.term);
        out.writeObject(this.tailArray);
        out.writeInt(this.firstEmptyCheck);
        out.writeInt(this.chars.size());
        Object object = this.chars.iterator();
        while (object.hasNext()) {
            char c = ((Character)object.next()).charValue();
            out.writeChar(c);
            out.writeChar(this.charToCode[c]);
        }
    }

    public void save(OutputStream os) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(os);
        try {
            this.writeExternal(out);
        }
        finally {
            out.flush();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        int i;
        this.size = in.readInt();
        this.nodeSize = in.readInt();
        int len = in.readInt();
        this.base = new int[len];
        for (i = 0; i < len; ++i) {
            this.base[i] = in.readInt();
        }
        this.check = new int[len];
        for (i = 0; i < len; ++i) {
            this.check[i] = in.readInt();
        }
        this.term = (SuccinctBitVector)in.readObject();
        this.tailArray = (TailArray)in.readObject();
        this.firstEmptyCheck = in.readInt();
        int n = in.readInt();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = in.readChar();
            char v = in.readChar();
            this.chars.add(Character.valueOf(c));
            this.charToCode[c] = v;
        }
    }

    public void load(InputStream is) throws IOException {
        try {
            this.readExternal(new ObjectInputStream(is));
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(Writer w) {
        PrintWriter writer = new PrintWriter(w);
        try {
            int i;
            int n = Math.min(16, this.base.length);
            writer.println("--- dump " + this.getClass().getSimpleName() + " ---");
            writer.println("array size: " + this.base.length);
            writer.println("last index of valid element: " + this.last);
            int vc = 0;
            for (i = 0; i < this.base.length; ++i) {
                if (this.base[i] == Integer.MAX_VALUE && this.check[i] < 0) continue;
                ++vc;
            }
            writer.println("valid elements: " + vc);
            writer.print("      |");
            for (i = 0; i < n; ++i) {
                writer.print(String.format("%3d|", i));
            }
            writer.println();
            writer.print("|base |");
            for (i = 0; i < n; ++i) {
                if (this.base[i] == Integer.MAX_VALUE) {
                    writer.print("N/A|");
                    continue;
                }
                writer.print(String.format("%3d|", this.base[i]));
            }
            writer.println();
            writer.print("|check|");
            for (i = 0; i < n; ++i) {
                if (this.check[i] < 0) {
                    writer.print("N/A|");
                    continue;
                }
                writer.print(String.format("%3d|", this.check[i]));
            }
            writer.println();
            writer.print("|term |");
            for (i = 0; i < n; ++i) {
                writer.print(String.format("%3d|", this.term.get(i) ? 1 : 0));
            }
            writer.println();
            writer.print("chars: ");
            int c = 0;
            for (char e : this.chars) {
                writer.print(String.format("%c:%d,", Character.valueOf(e), (int)this.charToCode[e]));
                if (++c <= 16) continue;
                break;
            }
            writer.println();
            writer.println("chars count: " + this.chars.size());
            writer.println("calculating max and min base.");
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            int maxDelta = Integer.MIN_VALUE;
            for (int i2 = 0; i2 < this.base.length; ++i2) {
                int b = this.base[i2];
                if (b == Integer.MAX_VALUE) continue;
                min = Math.min(min, b);
                max = Math.max(max, b);
                maxDelta = Math.max(maxDelta, Math.abs(i2 - b));
            }
            writer.println("maxDelta: " + maxDelta);
            writer.println("max: " + max);
            writer.println("min: " + min);
            writer.println("calculating min check.");
            min = Integer.MAX_VALUE;
            for (int i3 = 0; i3 < this.base.length; ++i3) {
                int b = this.check[i3];
                min = Math.min(min, b);
            }
            writer.println("min: " + min);
            writer.println();
        }
        finally {
            writer.flush();
        }
    }

    @Override
    public void trimToSize() {
        int sz = this.last + 1 + 65535;
        this.base = Arrays.copyOf(this.base, sz);
        this.check = Arrays.copyOf(this.check, sz);
    }

    private void build(Node node, int nodeIndex, TailArrayBuilder tailArrayBuilder, FastBitSet bs, TermNodeListener listener) {
        int offset;
        char[] letters = node.getLetters();
        if (letters.length > 1) {
            tailArrayBuilder.append(nodeIndex, letters, 1, letters.length - 1);
        }
        if (node.isTerminate()) {
            bs.set(nodeIndex);
            listener.listen(node, nodeIndex);
        } else {
            bs.unsetIfLE(nodeIndex);
        }
        Node[] children = node.getChildren();
        int childrenLen = children.length;
        if (childrenLen == 0) {
            return;
        }
        int[] heads = new int[childrenLen];
        int maxHead = 0;
        int minHead = Integer.MAX_VALUE;
        for (int i = 0; i < childrenLen; ++i) {
            heads[i] = this.getCharId(children[i].getLetters()[0]);
            maxHead = Math.max(maxHead, heads[i]);
            minHead = Math.min(minHead, heads[i]);
        }
        this.base[nodeIndex] = offset = this.findInsertOffset(heads, minHead, maxHead);
        for (int cid : heads) {
            this.setCheck(offset + cid, nodeIndex);
        }
        TreeMap<Integer, ArrayList<Pair<Node, Integer>>> nodes = new TreeMap<Integer, ArrayList<Pair<Node, Integer>>>(new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return arg0 - arg1;
            }
        });
        for (int i = 0; i < children.length; ++i) {
            ArrayList<Pair<Node, Integer>> p;
            Node[] c = children[i].getChildren();
            int n = 0;
            if (c != null) {
                n = c.length;
            }
            if ((p = (ArrayList<Pair<Node, Integer>>)nodes.get(n)) == null) {
                p = new ArrayList<Pair<Node, Integer>>();
                nodes.put(n, p);
            }
            p.add(Pair.create(children[i], heads[i]));
        }
        for (Map.Entry e : nodes.entrySet()) {
            for (Pair e2 : (List)e.getValue()) {
                this.build((Node)e2.getFirst(), (Integer)e2.getSecond() + offset, tailArrayBuilder, bs, listener);
            }
        }
    }

    private int findInsertOffset(int[] heads, int minHead, int maxHead) {
        int empty = this.findFirstEmptyCheck();
        while (true) {
            int offset;
            if ((offset = empty - minHead) + maxHead >= this.check.length) {
                this.extend(offset + maxHead);
            }
            boolean found = true;
            for (int cid : heads) {
                if (this.check[offset + cid] < 0) continue;
                found = false;
                break;
            }
            if (found) {
                return offset;
            }
            empty = this.findNextEmptyCheck(empty);
        }
    }

    private int getCharId(char c) {
        char v = this.charToCode[c];
        if (v != '\u0000') {
            return v;
        }
        v = (char)(this.chars.size() + 1);
        this.chars.add(Character.valueOf(c));
        this.charToCode[c] = v;
        return v;
    }

    private int findCharId(char c) {
        char v = this.charToCode[c];
        if (v != '\u0000') {
            return v;
        }
        return -1;
    }

    private void extend(int i) {
        int sz = this.base.length;
        int nsz = Math.max(i + 65535, (int)((double)sz * 1.5));
        this.base = Arrays.copyOf(this.base, nsz);
        Arrays.fill(this.base, sz, nsz, Integer.MAX_VALUE);
        this.check = Arrays.copyOf(this.check, nsz);
        Arrays.fill(this.check, sz, nsz, -1);
    }

    private int findFirstEmptyCheck() {
        while (this.check[this.firstEmptyCheck] >= 0 || this.base[this.firstEmptyCheck] != Integer.MAX_VALUE) {
            ++this.firstEmptyCheck;
        }
        return this.firstEmptyCheck;
    }

    private int findNextEmptyCheck(int i) {
        int d = this.check[i] * -1;
        if (d <= 0) {
            throw new RuntimeException();
        }
        int prev = i;
        if ((i += d) >= this.check.length) {
            this.extend(i);
            return i;
        }
        if (this.check[i] < 0) {
            return i;
        }
        ++i;
        while (i < this.check.length) {
            if (this.check[i] < 0) {
                this.check[prev] = prev - i;
                return i;
            }
            ++i;
        }
        this.extend(i);
        this.check[prev] = prev - i;
        return i;
    }

    private void setCheck(int index, int value) {
        if (this.firstEmptyCheck == index) {
            this.firstEmptyCheck = this.findNextEmptyCheck(this.firstEmptyCheck);
        }
        this.check[index] = value;
        this.last = Math.max(this.last, index);
    }

    private class TailDoubleArrayNode
    implements TermIdNode {
        private char firstChar = '\u0000';
        private int nodeId;

        public TailDoubleArrayNode(int nodeId) {
            this.nodeId = nodeId;
        }

        public TailDoubleArrayNode(int nodeId, char firstChar) {
            this.nodeId = nodeId;
            this.firstChar = firstChar;
        }

        @Override
        public boolean isTerminate() {
            return TailDoubleArray.this.term.get(this.nodeId);
        }

        @Override
        public int getTermId() {
            return TailDoubleArray.this.term.get(this.nodeId) ? TailDoubleArray.this.term.rank1(this.nodeId) - 1 : -1;
        }

        @Override
        public char[] getLetters() {
            StringBuilder ret = new StringBuilder();
            ret.append(this.firstChar);
            TailUtil.appendChars(TailDoubleArray.this.tailArray.newIterator(TailDoubleArray.this.tailArray.getIteratorOffset(this.nodeId)), ret);
            return ret.toString().toCharArray();
        }

        @Override
        public TermIdNode[] getChildren() {
            ArrayList<TailDoubleArrayNode> ret = new ArrayList<TailDoubleArrayNode>();
            int b = TailDoubleArray.this.base[this.nodeId];
            for (char c : TailDoubleArray.this.chars) {
                char code = TailDoubleArray.this.charToCode[c];
                int nid = b + code;
                if (nid < 0 || nid >= TailDoubleArray.this.check.length || TailDoubleArray.this.check[nid] != this.nodeId) continue;
                ret.add(new TailDoubleArrayNode(nid, c));
            }
            return ret.toArray(emptyNodes);
        }

        @Override
        public TailDoubleArrayNode getChild(char c) {
            int nid = TailDoubleArray.this.base[this.nodeId] + TailDoubleArray.this.charToCode[c];
            if (0 <= nid && nid < TailDoubleArray.this.check.length && TailDoubleArray.this.check[nid] == this.nodeId) {
                return new TailDoubleArrayNode(nid, c);
            }
            return null;
        }
    }

    public static interface TermNodeListener {
        public void listen(Node var1, int var2);
    }
}

