/*
 * Decompiled with CFR 0.152.
 */
package org.dict.zip;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAccessInputStream
extends InputStream {
    private static final int DEFAULT_BUFSIZE = 4096;
    private RandomAccessFile in;
    private byte[] inbuf;
    private long currentpos = 0L;
    private long startpos = -1L;
    private long endpos = -1L;
    private long mark = 0L;
    private int bufsize;

    public RandomAccessInputStream(RandomAccessFile inFile, int bufsize) {
        this.in = inFile;
        this.bufsize = bufsize;
        this.inbuf = new byte[bufsize];
    }

    public RandomAccessInputStream(RandomAccessFile inFile) {
        this(inFile, 4096);
    }

    public RandomAccessInputStream(String file, String mode) throws IOException {
        this(new RandomAccessFile(file, mode));
    }

    @Override
    public final int available() throws IOException {
        long available = this.length() - this.position();
        if (available > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)available;
    }

    @Override
    public final void close() throws IOException {
        this.in.close();
    }

    public final long length() throws IOException {
        return this.in.length();
    }

    public final int getLength() throws IOException {
        return (int)this.length();
    }

    public final long position() throws IOException {
        return this.currentpos;
    }

    @Deprecated
    public final int getPos() throws IOException {
        return (int)this.position();
    }

    @Override
    public final synchronized void mark(int markpos) {
        this.mark = this.currentpos;
    }

    @Override
    public final boolean markSupported() {
        return true;
    }

    @Override
    public final synchronized int read() throws IOException {
        int c = this.read(this.currentpos);
        if (c == -1) {
            return -1;
        }
        ++this.currentpos;
        return c;
    }

    public int read(long pos) {
        if (pos < this.startpos || pos > this.endpos) {
            int n;
            long blockstart = pos / (long)this.bufsize * (long)this.bufsize;
            try {
                this.in.seek(blockstart);
                n = this.in.read(this.inbuf);
            }
            catch (IOException e) {
                return -1;
            }
            this.startpos = blockstart;
            this.endpos = blockstart + (long)n - 1L;
            if (pos < this.startpos || pos > this.endpos) {
                return -1;
            }
        }
        return this.inbuf[(int)(pos - this.startpos)] & 0xFF;
    }

    @Override
    public final int read(byte[] buf, int off, int len) throws IOException {
        int idx = 0;
        while (idx < len) {
            int c = this.read(this.currentpos);
            if (c == -1) {
                return idx;
            }
            buf[off + idx++] = (byte)c;
            ++this.currentpos;
        }
        return idx;
    }

    public final void readFully(byte[] buf) throws IOException {
        int idx = 0;
        while (idx < buf.length) {
            int c = this.read(this.currentpos);
            if (c == -1) {
                throw new IOException();
            }
            buf[idx++] = (byte)c;
            ++this.currentpos;
        }
    }

    @Override
    public final synchronized void reset() throws IOException {
        this.currentpos = this.mark;
    }

    public final void seek(long pos) throws IOException {
        this.currentpos = pos;
    }

    @Override
    public final long skip(long size) throws IOException {
        this.currentpos = this.currentpos + size > this.length() ? this.length() : (this.currentpos += size);
        return this.currentpos;
    }
}

